import type { Dict } from '@sage/xtrem-shared';
import * as React from 'react';
import type { ScreenBaseDefinition } from '../../../service/screen-base-definition';
import type { CustomDialogOptions, DialogDescription, PageDialogOptions } from '../../../types/dialogs';
import type { ScreenBase } from '../../../service/screen-base';
export interface DialogComponentExternalProps {
    dialogKey: string;
    isFullScreen: boolean;
}
export interface DialogComponentProps extends DialogComponentExternalProps {
    closeDialog: (dialogId: number) => Promise<void>;
    closeTableSidebar: (dialogId: number) => void;
    dialog: DialogDescription<PageDialogOptions & CustomDialogOptions<ScreenBase>>;
    isMobileDialog?: boolean;
    isTabletDialog?: boolean;
    screenDefinitions: Dict<ScreenBaseDefinition>;
    setActiveSection: (screenId: string, activeSection: string) => Promise<void>;
}
interface DialogComponentState {
    activeSection: string | null;
}
export declare class DialogComponent extends React.Component<DialogComponentProps, DialogComponentState> {
    private normalDialogRef;
    constructor(props: DialogComponentProps);
    componentDidUpdate(prevProps: DialogComponentProps): void;
    closeDialog: () => Promise<void>;
    getActiveSection: () => string | null;
    /**
     *
     * @description Carbon Dialog focustrap and AgGrid internal state focus handling are incompatible.
     * They compete and overlap each other for the same browser events and imperative effects (.focus()).
     * Therefore, we disable the focus trap when the page dialog includes a table within.
     * For the same reasons we disable the 'Esc' key.
     *
     * `disableFocusTrap: boolean` does not currently work... so we use the hidden `bespokeFocusTrap`
     * callback property with a noop function, which does the same. We should consider a
     * replacement in the future, when `disableFocusTrap` is back in the Carbon library.
     *
     * Giving its current state, disabling by default the FocusTrap in all/most of the dialogs might
     * not be completely discarded. Browsers defaults may be enough for most cases.
     *
     */
    hasTableField: () => boolean;
    isPageDialog: () => boolean;
    isFullScreenPageDialog: () => boolean;
    setSelectedSection: (selectedSection: string) => void;
    renderSidebarDialog: () => React.ReactNode;
    renderNormalDialog: () => React.ReactNode;
    renderStickerDialog: () => React.ReactNode;
    renderFullScreenStickerDialog: () => React.ReactNode;
    renderFullScreenDialog: () => React.ReactNode;
    render(): React.ReactNode;
}
export declare const ConnectedDialogComponent: import("react-redux").ConnectedComponent<typeof DialogComponent, {
    key?: React.Key | null | undefined;
    ref?: React.LegacyRef<DialogComponent> | undefined;
    dialogKey: string;
    isFullScreen: boolean;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store | undefined;
}>;
export {};
//# sourceMappingURL=dialog-component.d.ts.map