import * as React from 'react';
import { Breadcrumbs, Crumb } from 'carbon-react/esm/components/breadcrumbs';
import { useDispatch, useSelector } from 'react-redux';
import * as xtremRedux from '../../../redux';
import { getPageDefinitionFromState } from '../../../utils/state-utils';
import { QUERY_PARAM_TUNNEL_SEGMENTS } from '../../../utils/constants';
import { kebabCase } from 'lodash';
export function DialogBreadcrumbs({ screenId }) {
    const dispatch = useDispatch();
    const breadcrumbs = useSelector(state => {
        if (!screenId) {
            return [];
        }
        const pageDefinition = getPageDefinitionFromState(screenId, state);
        const segments = pageDefinition.queryParameters[QUERY_PARAM_TUNNEL_SEGMENTS];
        if (!segments) {
            return [];
        }
        return segments.map(s => ({
            children: s.label,
            key: s.screenId,
            onClick: () => {
                dispatch(xtremRedux.actions.closeTunnelByBreadcrumbLink(s.screenId, screenId));
            },
        }));
    });
    if (!screenId || breadcrumbs.length === 0) {
        return null;
    }
    const updatedBreadcrumbs = breadcrumbs.map((b, i) => {
        return { ...b, key: String(i), isCurrent: i === breadcrumbs.length - 1 };
    });
    return (React.createElement("div", { "data-testid": `e-breadcrumb-${kebabCase(screenId)}` },
        React.createElement(Breadcrumbs, { pt: "20px" }, updatedBreadcrumbs.map(c => (
        // eslint-disable-next-line react/jsx-key
        React.createElement(Crumb, { ...c }))))));
}
//# sourceMappingURL=dialog-breadcrumbs.js.map