import Form from 'carbon-react/esm/components/form';
import { isEmpty } from 'lodash';
import * as React from 'react';
import { ContextType } from '../../../../types';
import { focusFirstElement } from '../../../../utils/layout-utils';
import BusinessActions from '../../footer/business-actions';
import PageComponent from '../../page/page-component';
import Button from 'carbon-react/esm/components/button';
import { localize } from '../../../../service/i18n-service';
import { BusinessActionButtonWrapper } from '../../footer/bussiness-action-button-wrapper';
import { dispatchContainerValidation } from '../../../../service/dispatch-service';
import { ContainerValidationErrorsComponent } from '../../page/container-validation-errors';
import { showToast } from '../../../../service/toast-service';
export function DialogBodyPageContent({ availableColumns, dialog, isFirstSection, isLastSection, noHeader, onStepOneSection, screenDefinition, selectedSection, }) {
    const pageDefinition = screenDefinition;
    const businessActions = pageDefinition?.page.$.businessActions ?? [];
    const isWizardMode = pageDefinition ? pageDefinition.page.$.mode === 'wizard' : false;
    const hasBusinessActions = !isEmpty(businessActions);
    const dialogContentSelector = '.e-dialog-content';
    React.useEffect(() => {
        const selector = Array.from(document.querySelectorAll(dialogContentSelector))
            ? dialogContentSelector
            : '[data-element="sidebar"]';
        focusFirstElement(selector);
    }, []);
    React.useEffect(() => {
        if (isWizardMode) {
            const selector = Array.from(document.querySelectorAll(dialogContentSelector))
                ? dialogContentSelector
                : '[data-element="sidebar"]';
            focusFirstElement(selector);
        }
    }, [selectedSection, isWizardMode]);
    const sectionProperties = selectedSection
        ? pageDefinition?.metadata.uiComponentProperties[selectedSection]
        : null;
    const onNextClick = React.useCallback(async () => {
        if (selectedSection && pageDefinition) {
            const result = await dispatchContainerValidation(pageDefinition.page._pageMetadata.screenId, selectedSection);
            if (result.blockingErrors.length > 0) {
                showToast(React.createElement(ContainerValidationErrorsComponent, { validationResults: result.allErrors, pageMetadata: pageDefinition.page._pageMetadata, screenId: pageDefinition.page._pageMetadata.screenId }), {
                    type: 'error',
                    language: 'jsx',
                });
                return;
            }
        }
        onStepOneSection(1);
    }, [onStepOneSection, pageDefinition, selectedSection]);
    const nextButtonLabel = sectionProperties?.wizardNextButtonLabel ||
        (isLastSection
            ? localize('@sage/xtrem-ui/wizard-finish', 'Finish')
            : localize('@sage/xtrem-ui/wizard-next', 'Next'));
    const previousButtonLabel = sectionProperties?.wizardPreviousButtonLabel || localize('@sage/xtrem-ui/wizard-previous', 'Previous');
    if (!pageDefinition) {
        return null;
    }
    return (React.createElement(Form, { onSubmit: (ev) => {
            ev.preventDefault();
        }, "data-pendo-page": dialog.screenId, "data-pendo-page-mode": "dialog", height: dialog.options.height ? `${dialog.options.height}px` : undefined, stickyFooter: hasBusinessActions || isWizardMode, rightSideButtons: (hasBusinessActions || isWizardMode) && (React.createElement("div", { className: "e-dialog-footer e-dialog-type-page", "data-testid": "e-dialog-footer" },
            isWizardMode && (React.createElement(BusinessActionButtonWrapper, { title: nextButtonLabel, id: "next" },
                React.createElement(Button, { ml: "16px", onClick: onNextClick, buttonType: sectionProperties?.wizardNextButtonType }, nextButtonLabel))),
            hasBusinessActions && dialog.screenId && (React.createElement(BusinessActions, { businessActions: businessActions, contextType: ContextType.dialog, defaultButtonType: "primary", key: "e-sticker-business-actions", screenId: dialog.screenId, pendoId: "pageFooterBusinessActions" })))), leftSideButtons: isWizardMode && (React.createElement("div", { className: "e-dialog-footer e-dialog-type-page", "data-testid": "e-dialog-footer" },
            React.createElement(BusinessActionButtonWrapper, { title: previousButtonLabel, id: "previous" },
                React.createElement(Button, { onClick: () => onStepOneSection(-1), disabled: isFirstSection, buttonType: sectionProperties?.wizardPreviousButtonType || 'primary' }, previousButtonLabel)))) },
        React.createElement(PageComponent, { key: dialog.screenId, pageDefinition: pageDefinition, contextType: ContextType.dialog, availableColumns: availableColumns, selectedSection: selectedSection, noHeader: noHeader, isMainListDisplayedInDialog: dialog.options.isMainListDisplayedInDialog, isPageDisplayedInFullScreenDialog: !!dialog.options.fullScreen })));
}
//# sourceMappingURL=page-content.js.map