import Form from 'carbon-react/esm/components/form';
import * as React from 'react';
import { DialogActionButtons } from './dialog-action-buttons';
import * as showdown from 'showdown';
import { escape as lodashEscape } from 'lodash';
import { Checkbox } from 'carbon-react/esm/components/checkbox';
const converter = new showdown.Converter();
export function DialogBodyMessageContent(props) {
    const body = props.dialog.options.mdContent ? (React.createElement("span", { className: "e-dialog-text-content", 
        // eslint-disable-next-line react/no-danger
        dangerouslySetInnerHTML: {
            __html: converter.makeHtml(lodashEscape(props.dialog.content)),
        } })) : (React.createElement("span", { className: "e-dialog-text-content" }, props.dialog.content));
    return (React.createElement(Form, { buttonAlignment: "right", rightSideButtons: React.createElement(DialogActionButtons, { buttons: props.dialog.buttons, reverseButtons: !!props.dialog.options.reverseButtons, pickNegativeButtons: !!props.dialog.options.reverseButtons, defaultFocusRef: props.defaultFocusRef }), leftSideButtons: React.createElement(React.Fragment, null,
            props.dialog.options.footerCheckboxLabel && (React.createElement("div", { className: "e-dialog-footer-checkbox", "data-testid": "e-dialog-footer-checkbox" },
                React.createElement(Checkbox, { label: props.dialog.options.footerCheckboxLabel, labelInline: true, onChange: (ev) => {
                        props.dialog.options.onFooterCheckboxChange?.(ev.target.checked);
                    } }))),
            React.createElement(DialogActionButtons, { buttons: props.dialog.buttons, reverseButtons: !!props.dialog.options.reverseButtons, pickNegativeButtons: !props.dialog.options.reverseButtons })) },
        React.createElement("span", { className: "e-dialog-text-content" }, body)));
}
//# sourceMappingURL=message-content.js.map