import Loader from 'carbon-react/esm/components/loader';
import * as React from 'react';
import { DialogErrorContent } from '../dialog-error-content';
import { ConnectedDialogBodyCustomContent } from './custom-content';
import { LookupContent } from './lookup-content';
import { DialogBodyMessageContent } from './message-content';
import { DialogBodyPageContent } from './page-content';
import { ConnectedTableSidebarBody } from '../../../table-sidebar/table-sidebar-body';
import { AsyncLoaderContent } from './async-loader-content';
export function DialogBodyContent(props) {
    if (props.dialog.type === 'internal' && React.isValidElement(props.dialog.content)) {
        return props.dialog.content;
    }
    if (props.dialog.type === 'table-sidebar') {
        const sidebarTableContent = props.dialog.content;
        if (!props.dialog.screenId) {
            throw new Error('Dialog screenId is required for table-sidebar dialog');
        }
        return (React.createElement(ConnectedTableSidebarBody, { cardDefinition: sidebarTableContent.cardDefinition, columns: sidebarTableContent.columns, dialogId: props.dialog.dialogId, elementId: sidebarTableContent.elementId, isNewRecord: sidebarTableContent.isNewRecord, level: sidebarTableContent.level, recordId: sidebarTableContent.recordId, screenId: props.dialog.screenId, sidebarDefinition: sidebarTableContent.sidebarDefinition }));
    }
    if (props.dialog.content instanceof Error) {
        return React.createElement(DialogErrorContent, { content: props.dialog.content });
    }
    if (props.dialog.type === 'async-loader') {
        return React.createElement(AsyncLoaderContent, { ...props });
    }
    // Message dialog
    if (typeof props.dialog.content === 'string') {
        return React.createElement(DialogBodyMessageContent, { ...props });
    }
    // Page dialog
    if (props.dialog.type === 'page' && props.screenDefinition) {
        return React.createElement(DialogBodyPageContent, { ...props });
    }
    // Loading page definition
    if (props.dialog.type === 'page' && !props.screenDefinition) {
        return (React.createElement("div", { className: "e-dialog-content-loading" },
            React.createElement(Loader, { size: "large" })));
    }
    if (props.dialog.type === 'lookup') {
        return React.createElement(LookupContent, { ...props });
    }
    // Custom dialog STUFF
    return (React.createElement(ConnectedDialogBodyCustomContent, { ...props, content: props.dialog.content, screenId: props.dialog.screenId }));
}
//# sourceMappingURL=dialog-body-content.js.map