import { objectKeys } from '@sage/xtrem-shared';
import Button from 'carbon-react/esm/components/button';
import * as React from 'react';
import { focusFirstElement } from '../../../../utils/layout-utils';
const getButtonType = (button, reverseButtons, preferredButtonType) => {
    if (preferredButtonType) {
        return preferredButtonType;
    }
    if (reverseButtons) {
        return button.isNegative ? 'primary' : 'tertiary';
    }
    return button.isNegative ? 'tertiary' : 'primary';
};
export function DialogActionButtons(props) {
    const positiveButtons = objectKeys(props.buttons).filter(b => !!props.buttons[b].isNegative === !!props.pickNegativeButtons && !props.buttons[b].isHidden);
    React.useEffect(() => {
        focusFirstElement('[data-element="form-footer"]', true);
    }, []);
    return (React.createElement(React.Fragment, null, positiveButtons.map((b) => {
        const buttonProps = {
            className: props.buttons[b].className,
            onClick: () => props.buttons[b].onClick(props.buttons[b].id),
            disabled: props.buttons[b].isDisabled,
            destructive: props.buttons[b].isDestructive,
            buttonType: getButtonType(props.buttons[b], props.reverseButtons, props.buttons[b].buttonType),
        };
        return (React.createElement(Button, { key: b, ...buttonProps }, props.buttons[b].text));
    })));
}
//# sourceMappingURL=dialog-action-buttons.js.map