import Form from 'carbon-react/esm/components/form';
import * as React from 'react';
import { connect } from 'react-redux';
import { RenderingRouter } from '../../../../render/rendering-router';
import { ContextType } from '../../../../types';
import { focusFirstElement } from '../../../../utils/layout-utils';
import { ContainerKey } from '../../../types';
import { GridRow } from '@sage/xtrem-ui-components';
import BusinessActions from '../../footer/business-actions';
import { DialogActionButtons } from './dialog-action-buttons';
import { FieldKey, objectKeys } from '@sage/xtrem-shared';
function DialogBodyBody({ sections, screenId, availableColumns, selectedSection, }) {
    if (sections.length === 1 &&
        (sections[0].componentType === FieldKey.Table ||
            sections[0].componentType === FieldKey.Workflow ||
            sections[0].componentType === FieldKey.FormDesigner)) {
        return (React.createElement(GridRow, { margin: 0, gutter: 16, verticalMargin: 0, columns: availableColumns },
            React.createElement(RenderingRouter, { contextType: ContextType.dialog, screenId: screenId, availableColumns: availableColumns, item: { $bind: sections[0].id, $isFullWidth: true } })));
    }
    const useTabs = sections.length > 1;
    // We only want to take selectedSection from external prop if is rightAligned because the tabs will be handled by dialog component as is rendered in the SidePanel Header
    const selectedSectionDetails = sections.find(section => section?.id === selectedSection);
    if (useTabs && selectedSectionDetails) {
        return (React.createElement(RenderingRouter, { contextType: ContextType.dialog, screenId: screenId, availableColumns: availableColumns, item: selectedSectionDetails.layout }));
    }
    return sections
        .filter(section => section?.id)
        .map(section => (React.createElement(RenderingRouter, { contextType: ContextType.dialog, screenId: screenId, availableColumns: availableColumns, key: section.id, item: section.layout })));
}
export function DialogBodyCustomContent(props) {
    let sections = props.content instanceof Array ? props.content : [props.content];
    sections = sections.filter(c => !!c && !c.isHidden);
    const isBlockContent = sections[0]?.componentType === ContainerKey.Block;
    const stickerDefinition = props.dialog.isSticker ? props.screenDefinition : null;
    const businessActions = stickerDefinition && stickerDefinition.sticker.$.businessActions;
    const hasBusinessActions = businessActions && businessActions.length > 0;
    React.useEffect(() => {
        focusFirstElement('.e-dialog-custom-content');
    }, []);
    const haveButtons = Object.values(props.dialog.buttons || {}).find(b => !b.isHidden);
    const rightSideButtons = (() => {
        if (hasBusinessActions) {
            return (React.createElement("div", { className: "e-dialog-footer e-dialog-type-page", "data-testid": "e-dialog-footer" },
                React.createElement(BusinessActions, { businessActions: businessActions, contextType: ContextType.dialog, defaultButtonType: "primary", key: "e-sticker-business-actions", screenId: props.dialog.screenId || '' })));
        }
        if (haveButtons) {
            return (React.createElement(DialogActionButtons, { buttons: props.dialog.buttons, reverseButtons: !!props.dialog.options.reverseButtons, pickNegativeButtons: false }));
        }
        return undefined;
    })();
    const leftSideButtons = haveButtons ? (React.createElement(DialogActionButtons, { buttons: props.dialog.buttons, reverseButtons: !!props.dialog.options.reverseButtons, pickNegativeButtons: true })) : undefined;
    const dialogBody = (React.createElement(DialogBodyBody, { availableColumns: props.availableColumns, screenId: props.screenId, sections: sections, selectedSection: props.selectedSection || '' }));
    return (React.createElement(Form, { stickyFooter: objectKeys(props.dialog.buttons || {}).length > 0, buttonAlignment: "right", height: props.dialog.options.height ? `${props.dialog.options.height}px` : undefined, rightSideButtons: rightSideButtons, leftSideButtons: leftSideButtons },
        React.createElement("div", { className: "e-dialog-custom-body" },
            React.createElement("div", { className: "e-dialog-custom-content" },
                !isBlockContent && dialogBody,
                isBlockContent && (React.createElement(GridRow, { className: "e-section-body", margin: 0, gutter: 16, verticalMargin: 0, columns: props.availableColumns }, dialogBody))))));
}
export const ConnectedDialogBodyCustomContent = connect()(DialogBodyCustomContent);
//# sourceMappingURL=custom-content.js.map