import * as React from 'react';
import type { ScreenBaseDefinition } from '../../../../service/screen-base-definition';
import type { CustomDialogContentType, CustomDialogOptions, DialogBodyContentProps } from '../../../../types/dialogs';
import type { BlockControlObject, FormDesignerControlObject, SectionControlObject, TableControlObject, WorkflowControlObject } from '../../../control-objects';
import type { ScreenBase } from '../../../../service/screen-base';
export type CustomContentSupportedControlObjects = SectionControlObject | BlockControlObject | WorkflowControlObject | TableControlObject | FormDesignerControlObject;
export interface DialogCustomContentProps extends DialogBodyContentProps<CustomDialogOptions<ScreenBase>> {
    content: CustomDialogContentType;
    screenId: string;
    availableColumns: number;
    screenDefinition?: ScreenBaseDefinition;
}
export declare function DialogBodyCustomContent(props: DialogCustomContentProps): React.ReactElement;
export declare const ConnectedDialogBodyCustomContent: import("react-redux").ConnectedComponent<typeof DialogBodyCustomContent, {
    content: CustomDialogContentType;
    dialog: import("../../../../types/dialogs").DialogDescription<CustomDialogOptions<ScreenBase<any, any>>>;
    screenId: string;
    screenDefinition?: ScreenBaseDefinition | undefined;
    availableColumns: number;
    noHeader?: boolean | undefined;
    selectedSection?: string | null | undefined;
    defaultFocusRef?: React.RefObject<any> | undefined;
    onStepOneSection: (direction: 1 | -1) => void;
    isFirstSection: boolean;
    isLastSection: boolean;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store | undefined;
}>;
//# sourceMappingURL=custom-content.d.ts.map