import Form from 'carbon-react/esm/components/form';
import * as React from 'react';
import LoaderBar from 'carbon-react/esm/components/loader-bar';
import { useEffect } from 'react';
import { localize } from '../../../../service/i18n-service';
import { AsyncLoaderImage } from './async-loader-image';
import Button from 'carbon-react/esm/components/button';
const KEEP_WAITING_TIMEOUT = 8000; // 8 seconds
export function AsyncLoaderContent(props) {
    const content = props.dialog.content;
    const [isWaiting, setIsWaiting] = React.useState(true);
    const onStop = React.useCallback((ev) => {
        ev.preventDefault();
        ev.stopPropagation();
        content.onStop?.();
    }, [content]);
    const onNotifyMe = React.useCallback((ev) => {
        ev.preventDefault();
        ev.stopPropagation();
        content.onNotifyMe?.();
    }, [content]);
    const onKeepWaiting = React.useCallback((ev) => {
        ev?.preventDefault();
        ev?.stopPropagation();
        setIsWaiting(true);
        setTimeout(() => {
            setIsWaiting(false);
        }, KEEP_WAITING_TIMEOUT);
    }, []);
    useEffect(() => {
        onKeepWaiting();
    }, [onKeepWaiting]);
    return (React.createElement(React.Fragment, null,
        isWaiting && (React.createElement("div", { className: "e-async-loading-indicator" },
            React.createElement("div", { className: "e-async-loading-indicator-loader" },
                React.createElement(LoaderBar, { m: 2 })),
            React.createElement("div", { className: "e-async-loading-indicator-animation-container" },
                React.createElement("video", { className: "e-async-loading-indicator-animation", autoPlay: true, loop: true, muted: true, playsInline: true },
                    React.createElement("source", { src: "/async-loader-animation.webm", type: "video/webm" })),
                React.createElement("div", { className: "e-async-loading-indicator-text" }, localize('@sage/xtrem-ui/dialogs-async-loader-waiting', 'This action may take a while...'))))),
        React.createElement(Form, { buttonAlignment: "right", leftSideButtons: content.isStopAvailable ? (React.createElement(Button, { buttonType: "tertiary", destructive: true, onClick: onStop }, localize('@sage/xtrem-ui/dialogs-async-loader-button-stop', 'Stop'))) : undefined, rightSideButtons: React.createElement(React.Fragment, null,
                React.createElement(Button, { key: "keepWaiting", buttonType: "secondary", onClick: onKeepWaiting }, localize('@sage/xtrem-ui/dialogs-async-loader-button-keep-waiting', 'Keep waiting')),
                React.createElement(Button, { key: "notifyMe", buttonType: "secondary", onClick: onNotifyMe }, localize('@sage/xtrem-ui/dialogs-async-loader-button-notify-me', 'Notify me'))) },
            React.createElement("div", { className: "e-dialog-async-loader-container" },
                React.createElement("div", { className: "e-dialog-async-loader-image" },
                    React.createElement(AsyncLoaderImage, null)),
                React.createElement("div", { className: "e-dialog-async-loader-content" }, content.dialogContent)))));
}
//# sourceMappingURL=async-loader-content.js.map