import type { Dict } from '@sage/xtrem-shared';
import type { PageArticleItem } from '../../../service/layout-types';
import type { DataTypeDetails, FormattedNodeDetails } from '../../../service/metadata-types';
import type { DetailPanelDecoratorProperties } from '../../decorator-properties';
import type { ContainerKey, DecoratorTarget, MetadataProps } from '../../types';
import { AbstractLayoutBuilder } from '../layouts';
export interface IDetailPanelLayout {
    detailPanelHeader: DetailPanelDecoratorProperties['header'];
    detailPanelSections: DetailPanelDecoratorProperties['sections'];
}
export declare class DetailPanelLayout extends AbstractLayoutBuilder<ContainerKey.DetailPanel> implements IDetailPanelLayout {
    target: DecoratorTarget<ContainerKey.DetailPanel>;
    elementId: string;
    detailPanelHeader: IDetailPanelLayout['detailPanelHeader'];
    detailPanelSections: IDetailPanelLayout['detailPanelSections'];
    detailPanelSectionsLayout: Partial<PageArticleItem>[];
    detailPanelHeaderLayout: Partial<PageArticleItem>;
    constructor(target: DecoratorTarget<ContainerKey.DetailPanel>, elementId: string, nodeTypes: Dict<FormattedNodeDetails>, dataTypes: Dict<DataTypeDetails>, props: IDetailPanelLayout & MetadataProps<ContainerKey.DetailPanel>);
    buildLayout: () => this;
}
//# sourceMappingURL=detail-panel-layout.d.ts.map