/**
 * @packageDocumentation
 * @module root
 * */
import { getUiComponentProperties, setUiComponentProperties } from '../../../service/transactions-service';
import { AbstractContainer } from '../../abstract-container';
import { ContainerKey } from '../../types';
export const detailPanelId = '$detailPanel';
/**
 * [Container]{@link AbstractContainer} that can be used to display additional information outside of the page layout
 */
export class DetailPanelControlObject extends AbstractContainer {
    static { this.defaultUiProperties = {
        ...AbstractContainer.defaultUiProperties,
        isExtendable: false,
    }; }
    constructor(properties) {
        // TODO: implement validation of the Detail Panel container
        super(properties.screenId, properties.elementId, properties.getUiComponentProperties || getUiComponentProperties, properties.setUiComponentProperties || setUiComponentProperties, ContainerKey.DetailPanel, properties.getValidationState || (async () => true), properties.layout);
        this._headerSection = Object.seal(properties.headerSection);
        this._sections = Object.seal(properties.sections);
        this._footerActions = Object.seal(properties.footerActions);
    }
    /** Which of the helper panel sections is being displayed */
    get activeSection() {
        return this.getUiComponentProperty('activeSection');
    }
    /** Which of the helper panel sections is being displayed */
    set activeSection(newValue) {
        if (newValue && !this.sections.find(s => s.$containerId === newValue)) {
            throw new Error(`"${newValue}" is not a valid helper panel section element id.`);
        }
        this.setUiComponentProperties('activeSection', newValue);
    }
    /** Whether the a cross icon is displayed that enables the user from closing the dialog */
    get isCloseButtonHidden() {
        return this.getUiComponentProperty('isCloseButtonHidden') || false;
    }
    /** Whether the a cross icon is displayed that enables the user from closing the dialog */
    set isCloseButtonHidden(newValue) {
        this.setUiComponentProperties('isCloseButtonHidden', newValue);
    }
    /**
     * Whether the helper panel can be extended into a separate window (extendable = true)
     * or not (extendable = false)
     */
    get isExtendable() {
        return !!this.getUiComponentProperty('isExtendable');
    }
    /**
     * Whether the helper panel can be extended into a separate window (extendable = true)
     * or not (extendable = false)
     */
    set isExtendable(newValue) {
        this.setUiComponentProperties('isExtendable', newValue);
    }
    /** [Section]{@link SectionControlObject} contained in the helper panel header */
    get headerSection() {
        return this._headerSection;
    }
    /** [Sections]{@link SectionControlObject} contained in the helper panel body */
    get sections() {
        return this._sections || [];
    }
    /** [Page Actions]{@link PageAction} rendered in the helper panel footer */
    get footerActions() {
        return this._footerActions;
    }
    async validateWithDetails(
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    _partition = false) {
        // Todo: implement validation of the Detail Panel container
        return [];
    }
}
//# sourceMappingURL=detail-panel-control-object.js.map