import Button from 'carbon-react/esm/components/button';
import * as React from 'react';
import { connect } from 'react-redux';
import * as xtremRedux from '../../../redux';
import { RenderingRouter } from '../../../render/rendering-router';
import { ContextType } from '../../../types';
import { xtremConsole } from '../../../utils/console';
import { resolveByValue } from '../../../utils/resolve-value-utils';
import { COLUMN_COUNT_HELPER_PANEL } from '../../../utils/responsive-utils';
import { detailPanelId } from '../../control-objects';
import { getFieldTitle } from '../../field/carbon-helpers';
import { XtremTabs } from '../../ui/tabs/xtrem-tabs';
import BusinessActions from '../footer/business-actions';
export class DetailPanel extends React.Component {
    constructor() {
        super(...arguments);
        this.onTabSelect = (selectedId) => {
            this.props.setFieldProperties(detailPanelId, {
                ...this.props.detailPanelProperties,
                activeSection: selectedId,
            });
        };
        this.onClose = () => {
            this.props.setFieldProperties(detailPanelId, {
                ...this.props.detailPanelProperties,
                isHidden: true,
            });
        };
    }
    render() {
        const { detailPanelProperties, detailPanel, sectionProperties, screenId } = this.props;
        if (resolveByValue({
            propertyValue: detailPanelProperties.isHidden,
            screenId,
            skipHexFormat: true,
            rowValue: null, // This is not a field context, so no row value can be present
        })) {
            return null;
        }
        // Filter out hidden sections, they are not rendered on the tab section selector
        const visibleSections = detailPanel.sections.filter(s => resolveByValue({
            propertyValue: !sectionProperties[s.$containerId].isHidden,
            screenId,
            skipHexFormat: true,
            rowValue: null, // This is not a field context, so no row value can be present
        }));
        const headerSection = detailPanel.headerSection;
        const shouldRenderHeaderSection = headerSection &&
            sectionProperties[headerSection.$containerId] &&
            !resolveByValue({
                propertyValue: sectionProperties[headerSection.$containerId].isHidden,
                screenId,
                skipHexFormat: true,
                rowValue: null, // This is not a field context, so no row value can be present
            });
        if (shouldRenderHeaderSection && sectionProperties[headerSection.$containerId].title === undefined) {
            xtremConsole.warn(`Detail panel header section ${headerSection.$containerId} has no title`);
        }
        const activeSectionElementId = detailPanelProperties.activeSection || visibleSections[0]?.$containerId || null;
        const activeSection = activeSectionElementId
            ? visibleSections.find(c => c.$containerId === activeSectionElementId)
            : null;
        return (React.createElement("aside", { className: "e-detail-panel", "data-testid": "e-detail-panel" },
            !detailPanelProperties.isCloseButtonHidden && (React.createElement("div", { className: "e-detail-panel-close" },
                React.createElement(Button, { "data-testid": "e-detail-panel-close", iconType: "close", onClick: this.onClose, buttonType: "tertiary" },
                    React.createElement("span", { className: "e-screen-reader-only" }, "Close helper panel")))),
            shouldRenderHeaderSection && (React.createElement("div", { className: "e-detail-panel-header", "data-testid": "e-detail-panel-header" },
                React.createElement(RenderingRouter, { screenId: screenId, item: headerSection, availableColumns: COLUMN_COUNT_HELPER_PANEL, contextType: ContextType.detailPanel }))),
            visibleSections.length > 1 && (React.createElement("div", { className: "e-detail-panel-tab-container", "data-testid": "e-detail-panel-tabs" },
                React.createElement(XtremTabs, { onTabChange: this.onTabSelect, selectedTabId: activeSectionElementId, tabs: visibleSections.map(s => ({
                        id: s.$containerId,
                        title: getFieldTitle(screenId, this.props.sectionProperties[s.$containerId], null),
                        indicatorContent: sectionProperties[s.$containerId].indicatorContent,
                    })) }))),
            React.createElement("div", { className: "e-detail-panel-body", "data-testid": "e-detail-panel-body" },
                React.createElement("div", { className: "e-detail-panel-sections", "data-testid": "e-detail-panel-sections" }, activeSection && (React.createElement(RenderingRouter, { screenId: screenId, contextType: ContextType.detailPanel, availableColumns: COLUMN_COUNT_HELPER_PANEL, item: activeSection })))),
            React.createElement(BusinessActions, { businessActions: detailPanel.footerActions, defaultButtonType: "primary", contextType: ContextType.detailPanel, key: "e-detail-panel-business-actions", screenId: screenId })));
        /* eslint-enable react/no-array-index-key */
    }
}
const mapStateToProps = (state, props) => {
    const footerActions = props.detailPanel.footerActions || [];
    const sections = props.detailPanel.sections || [];
    const visibleFooterActions = footerActions.filter(action => !action.isHidden).length;
    const enabledFooterActions = footerActions.filter(action => !action.isDisabled).length;
    const detailPanelProperties = state.screenDefinitions[props.screenId].metadata.uiComponentProperties[detailPanelId];
    const sectionProperties = [...sections, props.detailPanel.headerSection].reduce((prevValue, currentValue) => {
        if (currentValue) {
            prevValue[currentValue.$containerId] =
                state.screenDefinitions[props.screenId].metadata.uiComponentProperties[currentValue.$containerId];
        }
        return prevValue;
    }, {});
    return {
        ...props,
        sectionProperties,
        enabledFooterActions,
        detailPanelProperties,
        visibleFooterActions,
        setFieldProperties: xtremRedux.actions.actionStub,
    };
};
const mapDispatchToProps = (dispatch, props) => ({
    setFieldProperties: (elementId, value) => {
        dispatch(xtremRedux.actions.setFieldProperties(props.screenId, elementId, value));
    },
});
export default connect(mapStateToProps, mapDispatchToProps)(DetailPanel);
//# sourceMappingURL=detail-panel-component.js.map