/**
 * @packageDocumentation
 * @module root
 * */
import { dispatchContainerValidation } from '../../../service/dispatch-service';
import { getPageMetadata } from '../../../service/page-metadata';
import { getValidationState } from '../../../service/validation-service';
import { getTargetPrototype } from '../../../utils/decorator-utils';
import { AbstractDecorator } from '../../abstract-decorator';
import { BlockControlObject } from '../../control-objects';
import { ContainerKey } from '../../types';
import { BlockLayout } from '../layouts';
import { getDeclarationPackage } from '../../../service/screen-loader-service';
class BlockDecorator extends AbstractDecorator {
    constructor() {
        super(...arguments);
        this._layout = BlockLayout;
        this._controlObjectConstructor = BlockControlObject;
    }
}
/**
 * Initializes the decorated member as a [Block]{@link BlockControlObject} container with the provided properties
 *
 * @param properties The properties that the [Block]{@link BlockControlObject} container will be initialized with
 */
export function block(properties) {
    return function blockDecorator(target, name) {
        const pageMetadata = getPageMetadata(getTargetPrototype(target.constructor), target);
        const extensionPackageName = getDeclarationPackage();
        pageMetadata.definitionOrder.push(name);
        pageMetadata.blockThunks[name] = (nodeTypes, dataTypes) => new BlockDecorator(pageMetadata.target, name, { pageMetadata, properties, extensionPackageName }, ContainerKey.Block, nodeTypes, dataTypes, {
            getValidationState: async () => getValidationState(pageMetadata.screenId, name),
            dispatchBlockValidation: () => {
                if (target.constructor.prototype.___isPageExtension) {
                    return dispatchContainerValidation(target.constructor.basePage, name);
                }
                return dispatchContainerValidation(target.constructor.name, name);
            },
        }).build().layout;
    };
}
//# sourceMappingURL=block-decorator.js.map