import type { AccessStatus } from '@sage/xtrem-shared';
import * as React from 'react';
import type { ReduxResponsive } from '../../../redux/state';
import type { PageArticleItem } from '../../../service/layout-types';
import { ContextType } from '../../../types';
import type { BlockProperties } from '../../control-objects';
export interface BlockComponentExternalProps {
    item: Partial<PageArticleItem>;
    screenId: string;
    contextType?: ContextType;
    availableColumns: number;
    isParentDisabled?: boolean;
    isParentHidden?: boolean;
    accessRule?: AccessStatus;
    isUsingInfiniteScroll?: boolean;
}
export interface BlockComponentProps extends BlockComponentExternalProps {
    screenType: string;
    fieldProperties: Omit<BlockProperties, 'parent'>;
    browser: ReduxResponsive;
}
export declare function BlockComponent(props: BlockComponentProps): React.ReactElement | null;
export declare const ConnectedBlockComponent: import("react-redux").ConnectedComponent<typeof BlockComponent, {
    item: Partial<PageArticleItem>;
    screenId: string;
    contextType?: ContextType | undefined;
    availableColumns: number;
    isParentDisabled?: boolean | undefined;
    isParentHidden?: boolean | undefined;
    accessRule?: AccessStatus | undefined;
    isUsingInfiniteScroll?: boolean | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store | undefined;
}>;
//# sourceMappingURL=block-component.d.ts.map