var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { BaseControlObject } from './base-control-object';
import { ControlObjectProperty } from './property-decorators/control-object-property-decorator';
import { FieldControlObjectResolvedProperty } from './property-decorators/control-object-resolved-property-decorator';
/**
 * Any element than can be placed inside a page and can be interacted with (i.e. retrieving
 * and/or setting element's properties values)
 */
export class AbstractUiControlObject extends BaseControlObject {
    static { this.defaultUiProperties = {
        ...BaseControlObject.defaultUiProperties,
        isHiddenDesktop: false,
        isHiddenMobile: false,
        isTitleHidden: false,
        isTransient: false,
    }; }
    /** Whether the value is bind to a GraphQL node (transient = false) or not (transient = true). */
    get isTransient() {
        return !!this.getUiComponentProperty('isTransient');
    }
}
__decorate([
    ControlObjectProperty()
    /** Whether the element title is hidden or not. Defaults to false */
], AbstractUiControlObject.prototype, "isTitleHidden", void 0);
__decorate([
    FieldControlObjectResolvedProperty()
    /** Title of the component */
], AbstractUiControlObject.prototype, "title", void 0);
__decorate([
    FieldControlObjectResolvedProperty()
    /** Whether the HTML element is visible or not */
], AbstractUiControlObject.prototype, "isHidden", void 0);
//# sourceMappingURL=abstract-ui-control-object.js.map