export class AbstractLayoutBuilder {
    constructor(target, elementId, nodeTypes, dataTypes, metadata) {
        this.target = target;
        this.elementId = elementId;
        this.nodeTypes = nodeTypes;
        this.dataTypes = dataTypes;
        this.metadata = metadata;
        this.build = () => {
            return this.buildLayout();
        };
    }
    buildContainerLayout(elementId, category, isHiddenMobile = false, isHiddenDesktop = false, width) {
        return {
            $containerId: elementId,
            $isHiddenMobile: isHiddenMobile,
            $isHiddenDesktop: isHiddenDesktop,
            $category: category,
            $layout: { $items: [] },
            $columnWidth: width,
        };
    }
    buildFieldLayout({ elementId, containerType = 'block', isHiddenDesktop, isHiddenMobile, width, isFullWidth, }) {
        return {
            $bind: elementId, // IG: We need to maintain the $bind naming because legacy authoring tool on Syracuse
            $isHiddenMobile: isHiddenMobile,
            $isHiddenDesktop: isHiddenDesktop,
            $containerType: containerType,
            $columnWidth: width,
            $isFullWidth: Boolean(isFullWidth),
        };
    }
}
//# sourceMappingURL=abstract-layout-builder.js.map