import { getPageMetadata } from '../service/page-metadata';
import { setDefaultProperties } from '../utils/abstract-fields-utils';
import { overrideExtendedProperties } from './abstract-decorator-utils';
import { withoutNestedTechnical } from './nested-fields';
import { applyDefaultValuesOnNestedField } from '../utils/data-type-utils';
import { set } from 'lodash';
export class AbstractDecorator {
    constructor(target, elementId, _metadataProps, componentType, nodeTypes, dataTypes, _controlObjectConstructorProps) {
        this.target = target;
        this.elementId = elementId;
        this._metadataProps = _metadataProps;
        this.componentType = componentType;
        this.nodeTypes = nodeTypes;
        this.dataTypes = dataTypes;
        this._controlObjectConstructorProps = _controlObjectConstructorProps;
        this.build = () => {
            return this.buildActions().buildLayout().buildControlObject().buildMetadata();
        };
        this.buildLayout = () => {
            if (this._layout && this._metadataProps) {
                this.layoutBuilder = new this._layout(this.target, this.elementId, this.nodeTypes, this.dataTypes, this._metadataProps).build();
            }
            return this;
        };
        this.buildActions = () => {
            return this;
        };
        this.buildControlObject = () => {
            if (!this._controlObjectConstructor || !this._controlObjectConstructorProps) {
                throw new Error('Did you forget to pass a control object to your new component?');
            }
            this.controlObjectInstance = new this._controlObjectConstructor({
                ...this._controlObjectConstructorProps,
                screenId: this.getScreenId(),
                elementId: this.elementId,
                layout: this.layoutBuilder ? this.layoutBuilder.layout : undefined,
                parent: 'parent' in this._metadataProps.properties
                    ? this._metadataProps.properties.parent
                    : undefined,
                insertBefore: 'insertBefore' in this._metadataProps.properties
                    ? this._metadataProps.properties.insertBefore
                    : undefined,
                insertAfter: 'insertAfter' in this._metadataProps.properties
                    ? this._metadataProps.properties.insertAfter
                    : undefined,
            });
            return this;
        };
        this.buildMetadata = () => {
            return this.setTarget().setControlObject().setUiComponentProperties();
        };
        this.setTarget = () => {
            if (this.target && this.elementId) {
                set(this.target, this.elementId, this.controlObjectInstance);
            }
            return this;
        };
        this.setControlObject = () => {
            const actualPageMetadata = this.getPageMetadata();
            if (this.elementId) {
                actualPageMetadata.controlObjects[this.elementId] = this.controlObjectInstance;
            }
            return this;
        };
    }
    getScreenId() {
        const metadata = getPageMetadata(this.target);
        if (typeof metadata.screenId === 'string') {
            return metadata.screenId;
        }
        if (typeof this.target === 'function') {
            return this.target.name;
        }
        return this.target.constructor.name;
    }
    getPageMetadata() {
        const actualPageMetadata = this.layoutBuilder && this.layoutBuilder.metadata
            ? this.layoutBuilder.metadata.pageMetadata
            : this._metadataProps.pageMetadata;
        return actualPageMetadata;
    }
    setUiComponentProperties(dataTypeDefaults = {}) {
        const actualPageMetadata = this.getPageMetadata();
        if (this.elementId) {
            const properties = {
                ...dataTypeDefaults,
                ...setDefaultProperties(overrideExtendedProperties(this.nodeTypes, this.elementId, actualPageMetadata, this._metadataProps.properties, this.componentType), this._controlObjectConstructor.defaultUiProperties, this.componentType, this._metadataProps.extensionPackageName),
            };
            actualPageMetadata.uiComponentProperties[this.elementId] = properties;
            actualPageMetadata.defaultUiComponentProperties[this.elementId] = { ...properties };
            const columns = properties.columns;
            const mobileCard = properties.mobileCard;
            const node = properties.node;
            if (columns) {
                withoutNestedTechnical(columns).forEach(nestedField => {
                    nestedField.properties = setDefaultProperties(nestedField.properties, nestedField.defaultUiProperties);
                    if (node) {
                        applyDefaultValuesOnNestedField(this.nodeTypes, this.dataTypes, nestedField, String(node));
                    }
                });
            }
            if (mobileCard) {
                Object.values(mobileCard).forEach(nestedField => {
                    if (!nestedField)
                        return;
                    nestedField.properties = setDefaultProperties(nestedField.properties, nestedField.defaultUiProperties);
                    if (node) {
                        applyDefaultValuesOnNestedField(this.nodeTypes, this.dataTypes, nestedField, String(node));
                    }
                });
            }
            // TODO Initialize nested fields properties with default values for Calendar and Chart
        }
        return this;
    }
    get layout() {
        return this.layoutBuilder.layout;
    }
    get controlObject() {
        return this.controlObjectInstance;
    }
}
//# sourceMappingURL=abstract-decorator.js.map