import { type Dict } from '@sage/xtrem-shared';
import type { FormattedNodeDetails } from '../service/metadata-types';
import type { PageMetadata } from '../service/page-metadata';
import type { ScreenExtension } from '../types';
import type { MenuSeparatorResult } from '../utils/action-menu-utils';
import type { PageActionControlObject } from './control-objects';
import type { ExtensionLevel, Level } from './field/nested-grid/nested-grid-component-types';
import type { NestedField, NestedFieldTypes } from './nested-fields';
import type { NestedExtensionField } from './nested-fields-extensions';
import type { NestedOverrideField } from './nested-fields-overrides';
import type { SidebarSectionDefinition } from './table-sidebar/table-sidebar-types';
import type { ComponentKey, DecoratorProperties } from './types';
import type { CardDefinition, CardExtensionDefinition } from './ui/card/card-component';
import type { CollectionItemActionOrMenuSeparator } from './ui/table-shared/table-dropdown-actions/table-dropdown-action-types';
export declare function mergeTableActions<T extends Array<CollectionItemActionOrMenuSeparator<any>>, U extends CollectionItemActionOrMenuSeparator<any>>(baseActions: T, newActions: Array<U>): T;
export declare const findColumnIndex: (columns: NestedField<any, NestedFieldTypes>[], match: string) => number;
export declare const insertColumn: (columns: NestedField<any, any>[], column: NestedExtensionField<any, any>, override?: boolean, onlyInsertIfFound?: boolean) => void;
/**
 * It merges the custom fields into the sidePanelLayout and returns a copy with the custom fields on it
 */
export declare const mergeIntoSidebarLayout: (sidePanelLayout: Dict<SidebarSectionDefinition>, customFields: NestedExtensionField<any, any>[]) => Dict<SidebarSectionDefinition>;
/**
 * It merges the columns defined by the base page and the columns provided by the extension.
 *  */
export declare const mergeColumnPropertyDefinitions: <T extends NestedFieldTypes = NestedFieldTypes>(sourcePackage?: string, currentColumns?: NestedField<any, T>[], columnExtensions?: NestedExtensionField<any, T>[]) => NestedField<any, T>[];
export declare const overrideColumnPropertyDefinitions: <T extends NestedFieldTypes = NestedFieldTypes>(sourcePackage: string, currentColumns?: NestedField<any, T>[], columnOverrides?: NestedOverrideField<any, T>[]) => NestedField<any, T>[];
/** Merge the level definition of existing levels */
export declare const mergeLevelPropertyDefinition: (sourcePackage: string, currentLevels?: Level<any, any>[], levelExtensions?: ExtensionLevel<any>[]) => Level<any, any>[];
export declare const insertExtendedActions: <CT extends ScreenExtension<CT>, T extends Array<PageActionControlObject<CT> | MenuSeparatorResult>>(context: CT, baseActions: T, extendedActions?: Array<PageActionControlObject<CT> | MenuSeparatorResult>) => T;
export declare const overrideExtendedProperties: <T extends ComponentKey>(nodeTypes: Dict<FormattedNodeDetails>, elementId: string, pageMetadata: PageMetadata, properties: DecoratorProperties<T>, componentType: ComponentKey) => DecoratorProperties<T>;
/**
 * Merges two mobile card configurations, handling null and explicitly-undefined values as deletions
 *
 * @param {CardDefinition} source - The original mobile card configuration
 * @param {CardExtensionDefinition} extension - The extended mobile card configuration
 * @returns {CardDefinition} The merged mobile card configuration, with null and undefined values from extension removed
 */
export declare const mergeMobileCards: (source: CardDefinition, extension: CardExtensionDefinition) => CardDefinition;
//# sourceMappingURL=abstract-decorator-utils.d.ts.map