import { AbstractUiControlObject } from './abstract-ui-control-object';
/**
 * Any container* than can be placed inside a page and can be interacted with (i.e. retrieving
 * and/or setting container's properties values).
 *
 * *A container is any element than can contain other elements and doesn't have a value itself
 * (e.g. a page, a section, a block, etc.)
 */
export class AbstractContainer extends AbstractUiControlObject {
    static { this.defaultUiProperties = {
        ...AbstractUiControlObject.defaultUiProperties,
        isHidden: false,
    }; }
    constructor(screenId, elementId, _getUiComponentProperties, _setUiComponentProperties, _componentKey, _getValidationState, layout, parent) {
        super(screenId, elementId, _getUiComponentProperties, _setUiComponentProperties, _componentKey);
        this._componentKey = _componentKey;
        this._getValidationState = _getValidationState;
        this.layout = layout;
        this.parent = parent;
    }
    /** Whether the container has some validation errors or not */
    get isValid() {
        return this._getValidationState();
    }
    /**
     * Triggers the validation rules of all the fields in the Fragment Page. Since the validation rules
     * might be asynchronous, this method returns a promise that must be awaited to get
     * the validation result
     */
    async validate() {
        const result = await this.validateWithDetails();
        return result.map(r => r.message);
    }
}
//# sourceMappingURL=abstract-container.js.map