/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.SqlServerPool=void 0,exports.create=create;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_x3_sql_1=require("@sage/xtrem-x3-sql"),mssql=require("mssql"),reader_1=require("./reader"),defaultCollation="Latin1_General_BIN";function fillParameters(e,t){if(!t||0===t.length)return;function processParam(t,s,a){const i=e.parameters[t];if(i)i.value=a;else e.input(t,s,a)}for(let e=0;t&&e<t.length;e+=1)if(t[e]instanceof Buffer)processParam(`p${e}`,{type:mssql.TYPES.Binary},t[e]);else if(t[e]&&t[e].value instanceof Buffer)processParam(`p${e}`,{type:mssql.TYPES.VarBinary},t[e].value);else if(t[e]instanceof Date)processParam(`p${e}`,{type:mssql.TYPES.DateTime},t[e]);else if("number"==typeof t[e])if((0|t[e])===t[e])processParam(`p${e}`,{type:mssql.TYPES.Int},t[e]);else processParam(`p${e}`,{type:mssql.TYPES.Float},t[e]);else processParam(`p${e}`,{type:mssql.TYPES.NVarChar},t[e])}function tdsParam(e){return`@p${e}`}async function tdsQuery(e,t,s,a,i){const n=s?` with ${JSON.stringify(s)}`:"",o=i?.verbose(()=>`[${e}] tds_query: ${t} ${n}`),r=a.transaction?new mssql.Request(a.transaction):new mssql.Request(a.pool);fillParameters(r,s);let c=false;r.on("error",e=>{if(r.removeAllListeners(),o)o?.fail(e.message);c=true});const l=await r.query(t);if(o&&!c)o?.success(`Row count = ${JSON.stringify(l.output)}`);return a.transaction?l.output:l.recordset}function getDecimalFormat(e,t,s){let a,i;if(s=s||{},isNaN(e)||isNaN(t))a=7,i=3;else{if(a=Math.min(e,28),i=t,s.useFloatingPointFormat){if(i>0)a=Math.min(14,a+i);i=Math.min(a-1,28-i)}else a+=Math.max(Math.min(i,28-a-i),0),i+=1;if(a+i>28)i=28-a}return{precision:a+i,scale:i}}const mssqlInstanceRegex=/^(?:([A-Za-z0-9.\-/]+)(?:[,:](\d+))?)(?:(?:\\{1,2}([a-zA-Z_#&][A-Za-z0-9_#&+$-]*))(?:[,:](\d+))?)?$/,validIpAddressRegex=/^(?:(?:[0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5]).){3}(?:[0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$/,validHostnameRegex=/^[a-zA-Z](([a-zA-Z0-9])|(-)[^-.]|\.[^-.])*[a-zA-Z0-9.]$/;function parseHostname(e,t){const s=mssqlInstanceRegex.exec(e);if(!s)throw new Error(`invalid instance ${e}`);const a=s[1],i=parseInt(s[2],10),n=s[3],o=parseInt(s[4],10);if(!validIpAddressRegex.test(a)&&!validHostnameRegex.test(a))throw new Error(`invalid server ${a}`);return{server:a,instanceName:n,port:i||o||t||1433}}function getConfig(e,t){if(e){const s=Math.max(e.poolSize||20,20),a=parseHostname(e.hostname,e.port),i={server:a.server,authentication:{type:"default",options:{userName:e.user||"X3",password:e.password}},pool:{min:s,max:s,log:e=>t?.debug(()=>e)},port:a.port,database:e.database,options:{instanceName:a.instanceName,isolationLevel:mssql.ISOLATION_LEVEL.READ_COMMITTED,packetSize:2048,encrypt:!!e.encrypt,trustServerCertificate:!!e.trustServerCertificate,appName:"xtrem-x3",useUTC:true,connectionRetryInterval:e.connectionRetryMillis||15e3,requestTimeout:e.requestTimeout||15e3,cancelTimeout:15e3}};if(/[,:]/.test(i.server))delete i.port;return i}throw new Error("Missing SQL config")}class SqlServerPool extends xtrem_x3_sql_1.Pool{constructor(e,t){super(e,t),this.dialect="sqlServer",this.cfg=getConfig(e,t),this.collation=e.collation||defaultCollation,this.usePool=false}param(e){return tdsParam(e)}checkConnection(e){return this.connectionPool}async createConnection(){if(this.connectionPool)return this.connectionPool;return this.logger?.debug(()=>`creating mssql pool ${this.cfg.server}...`),this.connectionPool=await mssql.connect(this.cfg),this.logger?.debug(()=>"pool created"),this.connectionPool}async closeConnection(e){}async execute(e,t,s,a){let i,n,o,r;if("string"==typeof e)i=null,n=e,o=t,r=s;else i=e,n=t,o=s,r=a;if(null==i)return this.withConnection(e=>this.execute(e,n,o,r));const c=this.logger?.verbose(()=>`[${this.config.user}] Execute ${n}, args=${o?JSON.stringify(o):""}`);let l;try{l=await tdsQuery(this.config.user,n,o,{pool:i},this.logger),c?.success()}catch(e){throw c?.fail(`Failed: ${e.message} on ${n}`),e}return l}createReader(e,t,s,a){return this.logger?.verbose(()=>`[${this.config.user}] Tedious reader ${t}, ${s?JSON.stringify(s):""}`),(0,reader_1.tediousReader)(e,t,s,{fillParameters,logger:this.logger})}reader(e,t=[]){return new xtrem_async_helper_1.AsyncArrayReader(()=>this.withConnection(s=>this.createReader(s,e,t,{}).readAll()))}async tableExists(e,t){return!!(await this.reader(`SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES\n        WHERE TABLE_SCHEMA = ${this.param(0)}\n        AND TABLE_NAME = ${this.param(1)}`,[t,e]).toArray())[0]}async viewExists(e,t){return!!(await this.reader(`SELECT TABLE_NAME FROM INFORMATION_SCHEMA.VIEWS\n        WHERE TABLE_SCHEMA = ${this.param(0)}\n        AND TABLE_NAME = ${this.param(1)}`,[t,e]).toArray())[0]}async readTableSchema(e,t,s){const a={schemaName:e,tableName:t,isView:await this.viewExists(t,e)};let i,n,o,r="";if(!s.skipColumns||!s.skipSequences){r=`SELECT c.object_id table_id, c.column_id col_id, c.name col_name, c.system_type_id col_type, c.max_length col_max_length, c.is_nullable col_is_nullable, c.precision col_precision, c.scale col_scale, c.default_object_id col_default_object_id, d.definition def_definition, o.schema_id schema_id, t.TYPTYP_0 type_type, t.OPTION_0 type_option, t.LNGTYP_0 type_length, tbl.UPDDATTIM_0 tbl_updateDateTime, z.LONG_0 zone_length, z.OPTION_0 zone_option FROM sys.tables a  JOIN sys.columns c ON a.object_id = c.object_id  LEFT JOIN sys.objects o ON c.object_id = o.object_id LEFT JOIN sys.schemas s ON o.schema_id = s.schema_id LEFT JOIN sys.default_constraints d ON d.object_id = c.default_object_id LEFT JOIN ${this.getFullTableName(a.schemaName,"ATABZON")} z ON z.CODFIC_0 = o.name AND c.name LIKE CONCAT(z.CODZONE_0, '[_]%') LEFT JOIN ${this.getFullTableName(a.schemaName,"ATYPE")} t ON z.CODTYP_0 = t.CODTYP_0 LEFT JOIN ${this.getFullTableName(a.schemaName,"ATABLE")} tbl ON z.CODFIC_0 = tbl.CODFIC_0 WHERE o.name='${a.tableName}' AND s.name='${a.schemaName}' UNION ALL SELECT c.object_id table_id, c.column_id col_id, c.name col_name, c.system_type_id col_type, c.max_length col_max_length, c.is_nullable col_is_nullable, c.precision col_precision, c.scale col_scale, c.default_object_id col_default_object_id, d.definition def_definition, o.schema_id schema_id, t.TYPTYP_0 type_type, t.OPTION_0 type_option, t.LNGTYP_0 type_length, tbl.UPDDATTIM_0 tbl_updateDateTime, z.LNG_0 zone_length, z.OPTION_0 zone_option FROM sys.views a  JOIN sys.columns c ON a.object_id = c.object_id  LEFT JOIN sys.objects o ON c.object_id = o.object_id LEFT JOIN sys.schemas s ON o.schema_id = s.schema_id LEFT JOIN sys.default_constraints d ON d.object_id = c.default_object_id LEFT JOIN ${this.getFullTableName(a.schemaName,"AVIEWD")} z ON z.CODVUE_0 = o.name AND c.name LIKE CONCAT(z.FLDVUE_0, '[_]%') LEFT JOIN ${this.getFullTableName(a.schemaName,"ATYPE")} t ON z.CODTYP_0 = t.CODTYP_0 LEFT JOIN ${this.getFullTableName(a.schemaName,"AVIEW")} tbl ON z.CODVUE_0 = tbl.CODVUE_0 WHERE o.name='${a.tableName}' AND s.name='${a.schemaName}' ORDER BY col_name`,this.logger?.verbose(()=>`[${this.config.user}] READTABLECHEMA sqlQuery1 : ${r}`);try{a.columns=(await this.reader(r).toArray()).map(e=>{if(!i)i=e.table_id,n=e.schema_id,a.lastUpdate=e.tbl_updateDateTime;const t={name:e.col_name,isNullable:e.col_is_nullable};switch(e.col_type){case 48:t.type="byte";break;case 52:t.type="short";break;case 56:t.type="integer";break;case 59:t.type="double";break;case 61:if(t.type="datetime",e.type_type)if(8===e.type_type)t.type="date";break;case 62:t.type="float";break;case 108:{if(t.type="decimal",4!==e.type_type){const s=`${a.tableName}.${t.name}: unexpected TYPTYP value: ${e.type_type}`;this.logger?.warn(`[${this.config.user}] WARNING : ${s}`)}let s=e.zone_length;if(0===s)s=e.type_length;t.precision=Math.floor(s),t.scale=Math.round(10*(s-t.precision));const i=e.zone_option&&-1!==e.zone_option.indexOf("F")||e.type_option&&-1!==e.type_option.indexOf("F"),n=getDecimalFormat(t.precision,t.scale,{useFloatingPointFormat:i});if(n.precision!==e.col_precision||n.scale!==e.col_scale){const s=`${a.tableName}.${t.name}: inconsistent numeric column type: computed ${n.precision}:${n.scale}, got ${e.col_precision}:${e.col_scale}`;this.logger?.warn(`[${this.config.user}] WARNING : ${s}`)}t.useFloatingPointFormat=i,t.precision+=t.scale;break}case 165:t.type="binaryStream";break;case 167:t.type="string",t.maxLength=e.col_max_length;break;case 173:if(16===e.col_max_length)t.type="uuid";else t.type="binary",t.maxLength=e.col_max_length;break;case 231:if(-1===e.col_max_length)t.type="textStream";else t.type="string",t.maxLength=e.col_max_length/2;break;default:throw new Error(`unknown column type ${e.col_type} for column ${this.getFullTableDefName(a)}.${e.col_name}`)}if(e.col_default_object_id)t.default=e.def_definition;else t.default=null;return t}),o?.success()}catch(e){o?.fail(`Failed ${e.message}`)}if(!i)throw new Error(`${this.getFullTableName(a.schemaName,a.tableName)}: no columns found in sys.columns (table probably missing too)!`)}if(!s.skipSecurity){r=`SELECT TOP 1 SECURE_0 FROM ${this.getFullTableName(a.schemaName,"ATABLE")} WHERE CODFIC_0 = ${this.param(0)}`;const e=(await this.reader(r,[a.tableName]).toArray())[0];a.isOpenAccess=!e||2===e.SECURE_0}if(!s.skipIndexes){let e,t;r=`SELECT ic.index_id index_id, ic.index_column_id index_column_id, i.is_unique index_unique, i.is_primary_key index_is_pk, c.name column_name, i.name index_name, ic.is_descending_key column_descending FROM sys.index_columns ic LEFT JOIN sys.indexes i ON i.index_id = ic.index_id AND i.object_id = ic.object_id LEFT JOIN sys.columns c ON c.column_id = ic.column_id AND c.object_id = ic.object_id WHERE i.object_id = ${i} AND i.type > 0\n                ORDER BY i.name, ic.index_column_id`,a.indexes=[],o=this.logger?.verbose(()=>`[${this.config.user}] READTABLECHEMA sqlQuery2 : ${r}`);try{(await this.reader(r).toArray()).forEach(s=>{if(s.index_id!==t)t=s.index_id,e={name:s.index_name,isPrimaryKey:s.index_is_pk,isUnique:s.index_unique,columns:[]},a.indexes.push(e);const i={name:s.column_name,ascending:!s.column_descending};e.columns.push(i)}),o?.success()}catch(e){o?.fail(`Failed ${e.message}`)}}if(!s.skipSequences){r=`\n                SELECT TOP 1 CAST(current_value AS int) seq_value\n                 FROM sys.sequences\n                 WHERE name = 'SEQ_${a.tableName}'\n                 AND schema_id = ${n}`,o=this.logger?.verbose(()=>`[${this.config.user}] READTABLECHEMA sqlQuery2 : ${r}`);try{(await this.reader(r).toArray()).forEach(e=>{a.sequence=e.seq_value}),o?.success()}catch(e){o?.fail(`Failed ${e.message}`)}this.logger?.debug(()=>`[${this.config.user}] READTABLECHEMA result : ${JSON.stringify(a)}`)}return a}getFullTableDefName(e){return this.getFullTableName(e.schemaName,e.tableName)}getFullTableName(e,t,s){const a=e?`[${e}].[${t}]`:`[${t}]`;return s?`${a} as ${s}`:a}}function create(e,t){return new SqlServerPool(e,t)}exports.SqlServerPool=SqlServerPool;
//# sourceMappingURL=pool.js.map