/** @module @sage/xtrem-x3-tedious */
import { AnyValue, AsyncGenericReader } from '@sage/xtrem-async-helper';
import { LoggerInterface } from '@sage/xtrem-shared';
import { PoolConfig, PoolReaderOptions, SqlExecuteOptions, SqlReadTableSchemaOptions, TableDefinition, Pool as XtremX3Pool } from '@sage/xtrem-x3-sql';
import * as mssql from 'mssql';
export type Connection = mssql.ConnectionPool;
export declare class SqlServerPool extends XtremX3Pool<Connection> {
    readonly dialect = "sqlServer";
    cfg: mssql.config;
    readonly collation: string;
    constructor(config: PoolConfig, logger?: LoggerInterface);
    param(i: number): string;
    protected checkConnection(_cnx: Connection): Connection | undefined;
    private connectionPool;
    protected createConnection(): Promise<Connection>;
    protected closeConnection(_cnx: Connection): Promise<void>;
    execute<T extends AnyValue>(sql?: string, args?: any[], opts?: SqlExecuteOptions): Promise<T>;
    execute<T extends AnyValue>(cnx?: Connection, sql?: string, args?: any[], opts?: SqlExecuteOptions): Promise<T>;
    createReader<T extends AnyValue>(cnx: Connection, sql: string, args?: any[], _opts?: PoolReaderOptions): AsyncGenericReader<T>;
    private reader;
    tableExists(tableName: string, schemaName: string): Promise<boolean>;
    viewExists(tableName: string, schemaName: string): Promise<boolean>;
    readTableSchema(schemaName: string, tableName: string, options?: SqlReadTableSchemaOptions): Promise<TableDefinition>;
    getFullTableDefName(tableDef: TableDefinition): string;
    getFullTableName(schemaName: string, tableName: string, alias?: string): string;
}
export declare function create(config: PoolConfig, logger?: LoggerInterface): XtremX3Pool<Connection>;
//# sourceMappingURL=pool.d.ts.map