// From file: @sage/wh-output-stock/build/index.d.ts
declare module '@sage/wh-output-stock/index' {
	export * from '@sage/wh-output-stock/lib/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/wh-output-stock/build/lib/index.d.ts
declare module '@sage/wh-output-stock/lib/index' {
	export * as enums from '@sage/wh-output-stock/lib/enums/index';
	export * as nodeExtensions from '@sage/wh-output-stock/lib/node-extensions/index';
	export * as nodes from '@sage/wh-output-stock/lib/nodes/index';
	export * as serviceOptions from '@sage/wh-output-stock/lib/service-options/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/wh-output-stock/build/lib/service-options/index.d.ts
declare module '@sage/wh-output-stock/lib/service-options/index' {
	export type Dummy = void;
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/wh-output-stock/build/lib/nodes/wave.d.ts
declare module '@sage/wh-output-stock/lib/nodes/wave' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhOutput from '@sage/wh-output';
	import * as sageWhProductData from '@sage/wh-product-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, date, integer, decimal } from '@sage/xtrem-core';
	export class Wave extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly code: Promise<string>;
	    readonly waveType: Promise<sageWhProductData.enums.WaveType>;
	    readonly launchDate: Promise<date | null>;
	    readonly launchTime: Promise<string>;
	    readonly numberOfDeliveryOrders: Promise<integer | null>;
	    readonly numberOfDeliveryOrdersLines: Promise<integer | null>;
	    readonly numberOfReserveMovements: Promise<integer | null>;
	    readonly numberOfPickingMovements: Promise<integer | null>;
	    readonly numberOfCrossDockingMovements: Promise<integer | null>;
	    readonly numberOfIncompletesLines: Promise<integer | null>;
	    readonly numberOfReplenishmentMovements: Promise<integer | null>;
	    readonly numberOfParcelInState: Promise<integer | null>;
	    readonly numberOfParcelinBulk: Promise<integer | null>;
	    readonly numberOfShippingUnitInstate: Promise<integer | null>;
	    readonly numberOfShippingUnitinBulk: Promise<integer | null>;
	    readonly numberOfPickingOrderForReserve: Promise<integer | null>;
	    readonly numberOfPickingOrderForPicking: Promise<integer | null>;
	    readonly numberOfPickingOrderForMixed: Promise<integer | null>;
	    readonly numberOfTransferOrder: Promise<integer | null>;
	    readonly status: Promise<sageWhProductData.enums.WaveStatus | null>;
	    readonly volume: Promise<decimal | null>;
	    readonly weight: Promise<decimal | null>;
	    readonly numberOfTransferMovements: Promise<integer | null>;
	    readonly carrier: Reference<sageWhMasterData.nodes.Carrier | null>;
	    readonly transportationMethod: Reference<sageWhMasterData.nodes.TransportMode | null>;
	    readonly round: Reference<sageWhOutput.nodes.Round | null>;
	    readonly genericWave: Reference<sageWhMasterData.nodes.GenericWave | null>;
	    readonly workCenter: Reference<sageWhMasterData.nodes.WorkCenter | null>;
	    readonly unit: Reference<sageWhMasterData.nodes.UnitOfMeasure | null>;
	    readonly estimatedLoad: Promise<decimal | null>;
	    readonly isAutoLaunch: Promise<boolean>;
	    readonly isMissionToBlock: Promise<boolean>;
	    readonly missionPriority: Promise<integer | null>;
	    readonly transactionInProgress: Promise<string>;
	}
	//# sourceMappingURL=wave.d.ts.map
}
// From file: @sage/wh-output-stock/build/lib/nodes/index.d.ts
declare module '@sage/wh-output-stock/lib/nodes/index' {
	export * from '@sage/wh-output-stock/lib/nodes/wave';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/wh-output-stock/build/lib/node-extensions/transfer-movement-extension.d.ts
declare module '@sage/wh-output-stock/lib/node-extensions/transfer-movement-extension' {
	import * as sageWhStock from '@sage/wh-stock';
	import { NodeExtension, Reference } from '@sage/xtrem-core';
	import * as sageWhOutputStock from '@sage/wh-output-stock/lib/index';
	export class TransferMovementExtension extends NodeExtension<sageWhStock.nodes.TransferMovement> {
	    readonly wave: Reference<sageWhOutputStock.nodes.Wave | null>;
	}
	declare module '@sage/wh-stock/lib/nodes/transfer-movement' {
	    interface TransferMovement extends TransferMovementExtension {
	    }
	}
	//# sourceMappingURL=transfer-movement-extension.d.ts.map
}
// From file: @sage/wh-output-stock/build/lib/node-extensions/shipping-unit-extension.d.ts
declare module '@sage/wh-output-stock/lib/node-extensions/shipping-unit-extension' {
	import * as sageWhOutput from '@sage/wh-output';
	import { NodeExtension, Reference } from '@sage/xtrem-core';
	import * as sageWhOutputStock from '@sage/wh-output-stock/lib/index';
	export class ShippingUnitExtension extends NodeExtension<sageWhOutput.nodes.ShippingUnit> {
	    readonly wave: Reference<sageWhOutputStock.nodes.Wave | null>;
	}
	declare module '@sage/wh-output/lib/nodes/shipping-unit' {
	    interface ShippingUnit extends ShippingUnitExtension {
	    }
	}
	//# sourceMappingURL=shipping-unit-extension.d.ts.map
}
// From file: @sage/wh-output-stock/build/lib/node-extensions/picking-order-extension.d.ts
declare module '@sage/wh-output-stock/lib/node-extensions/picking-order-extension' {
	import * as sageWhOutput from '@sage/wh-output';
	import { NodeExtension, Reference, Collection } from '@sage/xtrem-core';
	import * as sageWhOutputStock from '@sage/wh-output-stock/lib/index';
	export class PickingOrderExtension extends NodeExtension<sageWhOutput.nodes.PickingOrder> {
	    readonly wave: Reference<sageWhOutputStock.nodes.Wave>;
	    readonly outputMovements: Collection<sageWhOutput.nodes.OutputMovement>;
	}
	declare module '@sage/wh-output/lib/nodes/picking-order' {
	    interface PickingOrder extends PickingOrderExtension {
	    }
	}
	//# sourceMappingURL=picking-order-extension.d.ts.map
}
// From file: @sage/wh-output-stock/build/lib/node-extensions/parcel-extension.d.ts
declare module '@sage/wh-output-stock/lib/node-extensions/parcel-extension' {
	import * as sageWhOutput from '@sage/wh-output';
	import { NodeExtension, Reference } from '@sage/xtrem-core';
	import * as sageWhOutputStock from '@sage/wh-output-stock/lib/index';
	export class ParcelExtension extends NodeExtension<sageWhOutput.nodes.Parcel> {
	    readonly wave: Reference<sageWhOutputStock.nodes.Wave>;
	}
	declare module '@sage/wh-output/lib/nodes/parcel' {
	    interface Parcel extends ParcelExtension {
	    }
	}
	//# sourceMappingURL=parcel-extension.d.ts.map
}
// From file: @sage/wh-output-stock/build/lib/node-extensions/output-movement-extension.d.ts
declare module '@sage/wh-output-stock/lib/node-extensions/output-movement-extension' {
	import * as sageWhOutput from '@sage/wh-output';
	import { NodeExtension, Reference } from '@sage/xtrem-core';
	import * as sageWhOutputStock from '@sage/wh-output-stock/lib/index';
	export class OutputMovementExtension extends NodeExtension<sageWhOutput.nodes.OutputMovement> {
	    readonly wave: Reference<sageWhOutputStock.nodes.Wave>;
	}
	declare module '@sage/wh-output/lib/nodes/output-movement' {
	    interface OutputMovement extends OutputMovementExtension {
	    }
	}
	//# sourceMappingURL=output-movement-extension.d.ts.map
}
// From file: @sage/wh-output-stock/build/lib/node-extensions/index.d.ts
declare module '@sage/wh-output-stock/lib/node-extensions/index' {
	export * from '@sage/wh-output-stock/lib/node-extensions/auto-palletization-order-extension';
	export * from '@sage/wh-output-stock/lib/node-extensions/delivery-note-extension';
	export * from '@sage/wh-output-stock/lib/node-extensions/delivery-order-extension';
	export * from '@sage/wh-output-stock/lib/node-extensions/output-movement-extension';
	export * from '@sage/wh-output-stock/lib/node-extensions/parcel-extension';
	export * from '@sage/wh-output-stock/lib/node-extensions/picking-order-extension';
	export * from '@sage/wh-output-stock/lib/node-extensions/shipping-unit-extension';
	export * from '@sage/wh-output-stock/lib/node-extensions/transfer-movement-extension';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/wh-output-stock/build/lib/node-extensions/delivery-order-extension.d.ts
declare module '@sage/wh-output-stock/lib/node-extensions/delivery-order-extension' {
	import * as sageWhOutput from '@sage/wh-output';
	import { NodeExtension, Reference } from '@sage/xtrem-core';
	import * as sageWhOutputStock from '@sage/wh-output-stock/lib/index';
	export class DeliveryOrderExtension extends NodeExtension<sageWhOutput.nodes.DeliveryOrder> {
	    readonly wave: Reference<sageWhOutputStock.nodes.Wave | null>;
	}
	declare module '@sage/wh-output/lib/nodes/delivery-order' {
	    interface DeliveryOrder extends DeliveryOrderExtension {
	    }
	}
	//# sourceMappingURL=delivery-order-extension.d.ts.map
}
// From file: @sage/wh-output-stock/build/lib/node-extensions/delivery-note-extension.d.ts
declare module '@sage/wh-output-stock/lib/node-extensions/delivery-note-extension' {
	import * as sageWhOutput from '@sage/wh-output';
	import { NodeExtension, Reference } from '@sage/xtrem-core';
	import * as sageWhOutputStock from '@sage/wh-output-stock/lib/index';
	export class DeliveryNoteExtension extends NodeExtension<sageWhOutput.nodes.DeliveryNote> {
	    readonly wave: Reference<sageWhOutputStock.nodes.Wave>;
	}
	declare module '@sage/wh-output/lib/nodes/delivery-note' {
	    interface DeliveryNote extends DeliveryNoteExtension {
	    }
	}
	//# sourceMappingURL=delivery-note-extension.d.ts.map
}
// From file: @sage/wh-output-stock/build/lib/node-extensions/auto-palletization-order-extension.d.ts
declare module '@sage/wh-output-stock/lib/node-extensions/auto-palletization-order-extension' {
	import * as sageWhOutput from '@sage/wh-output';
	import { NodeExtension, Reference } from '@sage/xtrem-core';
	import * as sageWhOutputStock from '@sage/wh-output-stock/lib/index';
	export class AutoPalletizationOrderExtension extends NodeExtension<sageWhOutput.nodes.AutoPalletizationOrder> {
	    readonly wave: Reference<sageWhOutputStock.nodes.Wave | null>;
	}
	declare module '@sage/wh-output/lib/nodes/auto-palletization-order' {
	    interface AutoPalletizationOrder extends AutoPalletizationOrderExtension {
	    }
	}
	//# sourceMappingURL=auto-palletization-order-extension.d.ts.map
}
// From file: @sage/wh-output-stock/build/lib/enums/index.d.ts
declare module '@sage/wh-output-stock/lib/enums/index' {
	export type Dummy = void;
	//# sourceMappingURL=index.d.ts.map
}
declare module '@sage/wh-output-stock' {
	export * from '@sage/wh-output-stock/index';
}
