"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Wave = void 0;
const sageWhMasterData = require("@sage/wh-master-data");
const sageWhOutput = require("@sage/wh-output");
const sageWhProductData = require("@sage/wh-product-data");
const sageWhSystem = require("@sage/wh-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const joins = {
    referenceJoins: {
        site: {
            code: 'site',
        },
        depositor: {
            site: 'site',
            code: 'depositor',
        },
        carrier: {
            site: 'site',
            code: 'carrier',
        },
        transportationMethod: {
            site: 'site',
            code: 'transportationMethod',
        },
        round: {
            site: 'site',
            dockType() {
                return 'round';
            },
            code: 'round',
        },
        genericWave: {
            site: 'site',
            depositor: 'depositor',
            code: 'genericWave',
        },
        workCenter: {
            site: 'site',
            code: 'workCenter',
        },
        unit: {
            code: 'unit',
        },
    },
};
let Wave = class Wave extends xtrem_core_1.Node {
};
exports.Wave = Wave;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FCY',
        columnType: 'string',
        node: () => sageWhSystem.nodes.Site,
        lookupAccess: true,
    })
], Wave.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DEP',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Depositor,
        lookupAccess: true,
    })
], Wave.prototype, "depositor", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'WAVNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Wave.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'WAVTYP',
        dataType: () => sageWhProductData.enums.waveTypeDatatype,
        lookupAccess: true,
    })
], Wave.prototype, "waveType", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LNCDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        lookupAccess: true,
    })
], Wave.prototype, "launchDate", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LNCTIM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Wave.prototype, "launchTime", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DLONBR',
        lookupAccess: true,
    })
], Wave.prototype, "numberOfDeliveryOrders", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DOLNBR',
        lookupAccess: true,
    })
], Wave.prototype, "numberOfDeliveryOrdersLines", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RSVMVTNBR',
        lookupAccess: true,
    })
], Wave.prototype, "numberOfReserveMovements", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PICMVTNBR',
        lookupAccess: true,
    })
], Wave.prototype, "numberOfPickingMovements", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CDKMVTNBR',
        lookupAccess: true,
    })
], Wave.prototype, "numberOfCrossDockingMovements", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SSHNBR',
        lookupAccess: true,
    })
], Wave.prototype, "numberOfIncompletesLines", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RPNMVTNBR',
        lookupAccess: true,
    })
], Wave.prototype, "numberOfReplenishmentMovements", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ISPNBR',
        lookupAccess: true,
    })
], Wave.prototype, "numberOfParcelInState", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'NSPNBR',
        lookupAccess: true,
    })
], Wave.prototype, "numberOfParcelinBulk", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ISPNBRSHP',
        lookupAccess: true,
    })
], Wave.prototype, "numberOfShippingUnitInstate", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'NSPNBRSHP',
        lookupAccess: true,
    })
], Wave.prototype, "numberOfShippingUnitinBulk", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RSVPKONBR',
        lookupAccess: true,
    })
], Wave.prototype, "numberOfPickingOrderForReserve", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PICPKONBR',
        lookupAccess: true,
    })
], Wave.prototype, "numberOfPickingOrderForPicking", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MPONBR',
        lookupAccess: true,
    })
], Wave.prototype, "numberOfPickingOrderForMixed", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RPNNBR',
        lookupAccess: true,
    })
], Wave.prototype, "numberOfTransferOrder", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'WAVSTA',
        dataType: () => sageWhProductData.enums.waveStatusDatatype,
        lookupAccess: true,
    })
], Wave.prototype, "status", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VOL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], Wave.prototype, "volume", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'WEI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], Wave.prototype, "weight", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TRFMVTNBR',
        lookupAccess: true,
    })
], Wave.prototype, "numberOfTransferMovements", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CRR',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Carrier,
        lookupAccess: true,
    })
], Wave.prototype, "carrier", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CRRMOD',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.TransportMode,
        lookupAccess: true,
    })
], Wave.prototype, "transportationMethod", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QYMNUM',
        columnType: 'string',
        filters: {
            lookup: {
                dockType: 'round',
            },
            control: {
                dockType: 'round',
            },
        },
        node: () => sageWhOutput.nodes.Round,
        lookupAccess: true,
    })
], Wave.prototype, "round", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'GWVCOD',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.GenericWave,
        lookupAccess: true,
    })
], Wave.prototype, "genericWave", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LOP',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.WorkCenter,
        lookupAccess: true,
    })
], Wave.prototype, "workCenter", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'UOM',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.UnitOfMeasure,
        lookupAccess: true,
    })
], Wave.prototype, "unit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EXPLOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], Wave.prototype, "estimatedLoad", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'AUTLNCFLG',
        lookupAccess: true,
    })
], Wave.prototype, "isAutoLaunch", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MSNLOK',
        lookupAccess: true,
    })
], Wave.prototype, "isMissionToBlock", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MSNPIO',
        lookupAccess: true,
    })
], Wave.prototype, "missionPriority", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TRSPND',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Wave.prototype, "transactionInProgress", void 0);
exports.Wave = Wave = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'VACATION',
        keyPropertyNames: ['site', 'depositor', 'code'],
        indexes: [
            {
                orderBy: {
                    site: 1,
                    depositor: 1,
                    code: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], Wave);
//# sourceMappingURL=wave.js.map