import * as sageWhMasterData from '@sage/wh-master-data';
import * as sageWhOutput from '@sage/wh-output';
import * as sageWhProductData from '@sage/wh-product-data';
import * as sageWhSystem from '@sage/wh-system';
import { Node, Reference, date, integer, decimal } from '@sage/xtrem-core';
export declare class Wave extends Node {
    readonly site: Reference<sageWhSystem.nodes.Site>;
    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
    readonly code: Promise<string>;
    readonly waveType: Promise<sageWhProductData.enums.WaveType>;
    readonly launchDate: Promise<date | null>;
    readonly launchTime: Promise<string>;
    readonly numberOfDeliveryOrders: Promise<integer | null>;
    readonly numberOfDeliveryOrdersLines: Promise<integer | null>;
    readonly numberOfReserveMovements: Promise<integer | null>;
    readonly numberOfPickingMovements: Promise<integer | null>;
    readonly numberOfCrossDockingMovements: Promise<integer | null>;
    readonly numberOfIncompletesLines: Promise<integer | null>;
    readonly numberOfReplenishmentMovements: Promise<integer | null>;
    readonly numberOfParcelInState: Promise<integer | null>;
    readonly numberOfParcelinBulk: Promise<integer | null>;
    readonly numberOfShippingUnitInstate: Promise<integer | null>;
    readonly numberOfShippingUnitinBulk: Promise<integer | null>;
    readonly numberOfPickingOrderForReserve: Promise<integer | null>;
    readonly numberOfPickingOrderForPicking: Promise<integer | null>;
    readonly numberOfPickingOrderForMixed: Promise<integer | null>;
    readonly numberOfTransferOrder: Promise<integer | null>;
    readonly status: Promise<sageWhProductData.enums.WaveStatus | null>;
    readonly volume: Promise<decimal | null>;
    readonly weight: Promise<decimal | null>;
    readonly numberOfTransferMovements: Promise<integer | null>;
    readonly carrier: Reference<sageWhMasterData.nodes.Carrier | null>;
    readonly transportationMethod: Reference<sageWhMasterData.nodes.TransportMode | null>;
    readonly round: Reference<sageWhOutput.nodes.Round | null>;
    readonly genericWave: Reference<sageWhMasterData.nodes.GenericWave | null>;
    readonly workCenter: Reference<sageWhMasterData.nodes.WorkCenter | null>;
    readonly unit: Reference<sageWhMasterData.nodes.UnitOfMeasure | null>;
    readonly estimatedLoad: Promise<decimal | null>;
    readonly isAutoLaunch: Promise<boolean>;
    readonly isMissionToBlock: Promise<boolean>;
    readonly missionPriority: Promise<integer | null>;
    readonly transactionInProgress: Promise<string>;
}
//# sourceMappingURL=wave.d.ts.map