"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PickingOrderExtension = void 0;
const sageWhOutput = require("@sage/wh-output");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageWhOutputStock = require("..");
const joins = {
    referenceJoins: {
        wave: {
            site: 'site',
            depositor: 'depositor',
            code: 'wave',
        },
    },
    collectionJoins: {
        outputMovements: {
            site: 'site',
            depositor: 'depositor',
            wave: 'wave',
            pickingOrder: 'code',
        },
    },
};
let PickingOrderExtension = class PickingOrderExtension extends xtrem_core_1.NodeExtension {
};
exports.PickingOrderExtension = PickingOrderExtension;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'WAVNUM',
        columnType: 'string',
        node: () => sageWhOutputStock.nodes.Wave,
        lookupAccess: true,
    })
], PickingOrderExtension.prototype, "wave", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageWhOutput.nodes.OutputMovement,
        isMutable: true,
        dependsOn: ['site', 'depositor', 'wave', 'code'],
        lookupAccess: true,
    })
], PickingOrderExtension.prototype, "outputMovements", void 0);
exports.PickingOrderExtension = PickingOrderExtension = __decorate([
    xtrem_core_1.decorators.nodeExtension({
        extends: () => sageWhOutput.nodes.PickingOrder,
        externalStorageManagerExtension: new xtrem_x3_gateway_1.X3StorageManagerExtension({
            joins,
        }),
    })
], PickingOrderExtension);
//# sourceMappingURL=picking-order-extension.js.map