// From file: @sage/xtrem-service/build/index.d.ts
declare module '@sage/xtrem-service/index' {
	export * from '@sage/xtrem-service/lib/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/xtrem-service/build/lib/xtrem-ui-app.d.ts
declare module '@sage/xtrem-service/lib/xtrem-ui-app' {
	import { NewRelicConfig } from '@sage/xtrem-shared';
	import { Response } from 'express';
	import { RequestWithNonce } from '@sage/xtrem-service/lib/middlewares/helmet-middleware';
	export interface TemplateConfig extends Partial<NewRelicConfig> {
	    nonce?: string;
	    version?: string;
	    /**
	     * The optional pendo key to use for the front-end app.
	     */
	    pendoApiKey?: string;
	    preferences: {
	        loadPendo: boolean;
	        loadNewRelic: boolean;
	    };
	}
	export const serveStaticXtremUi: (isProd?: boolean, newRelicConfig?: NewRelicConfig, xtremStandaloneVersion?: string, isTemplateCacheDisabled?: boolean) => (req: RequestWithNonce, res: Response) => void;
	//# sourceMappingURL=xtrem-ui-app.d.ts.map
}
// From file: @sage/xtrem-service/build/lib/util.d.ts
declare module '@sage/xtrem-service/lib/util' {
	import { NextFunction, Request, Response } from 'express';
	export function nocache(req: Request, res: Response, next: NextFunction): void;
	/**
	 * Set a wide range of headers to prevent caching
	 * @param res the response for which to set the headers
	 * @see https://developer.mozilla.org/en-US/docs/Web/HTTP/Caching
	 * @see https://github.com/helmetjs/nocache
	 */
	export function setNoCacheHeaders(res: Response): void;
	//# sourceMappingURL=util.d.ts.map
}
// From file: @sage/xtrem-service/build/lib/token-invalidation.d.ts
declare module '@sage/xtrem-service/lib/token-invalidation' {
	import { JwtClaims } from '@sage/xtrem-core';
	import { Config } from '@sage/xtrem-shared';
	export class TokenInvalidationService {
	    private static _isStarted;
	    private constructor();
	    static start(config: Config): void;
	    static stop(): void;
	    static isInvalidatedToken(accessToken: JwtClaims): boolean;
	}
	//# sourceMappingURL=token-invalidation.d.ts.map
}
// From file: @sage/xtrem-service/build/lib/start-application.d.ts
declare module '@sage/xtrem-service/lib/start-application' {
	import { Application } from '@sage/xtrem-core';
	export function startApplication(application: Application): Promise<void>;
	//# sourceMappingURL=start-application.d.ts.map
}
// From file: @sage/xtrem-service/build/lib/loggers.d.ts
declare module '@sage/xtrem-service/lib/loggers' {
	import { Logger } from '@sage/xtrem-core';
	export const loggers: {
	    service: Logger;
	    http: Logger;
	};
	//# sourceMappingURL=loggers.d.ts.map
}
// From file: @sage/xtrem-service/build/lib/index.d.ts
declare module '@sage/xtrem-service/lib/index' {
	export { GraphqlEndpointHooks } from '@sage/xtrem-service/lib/endpoints/graphql-endpoint';
	export { startApplication } from '@sage/xtrem-service/lib/start-application';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/xtrem-service/build/lib/middlewares/xtrem-ui-plugin-middleware.d.ts
declare module '@sage/xtrem-service/lib/middlewares/xtrem-ui-plugin-middleware' {
	import { Application } from '@sage/xtrem-core';
	import * as express from 'express';
	/**
	 * This middleware serves resources for UI plugins. A package may consist of a number of resources, including various
	 * images, fonts etc, therefore for plugin packages we host the entire build folder.
	 * @param application
	 */
	export const xtremUiPluginsMiddleware: (application: Application) => express.Express;
	//# sourceMappingURL=xtrem-ui-plugin-middleware.d.ts.map
}
// From file: @sage/xtrem-service/build/lib/middlewares/too-busy-middleware.d.ts
declare module '@sage/xtrem-service/lib/middlewares/too-busy-middleware' {
	import { Express, Handler } from 'express';
	export const tooBusyMiddleware: Handler;
	export function addMakeMeBusyRoute(app: Express): void;
	//# sourceMappingURL=too-busy-middleware.d.ts.map
}
// From file: @sage/xtrem-service/build/lib/middlewares/standalone-config-middleware.d.ts
declare module '@sage/xtrem-service/lib/middlewares/standalone-config-middleware' {
	import { Application } from '@sage/xtrem-core';
	import { Config } from '@sage/xtrem-shared';
	import { Request, Response } from 'express';
	export const standaloneConfigMiddleware: (config: Config, application: Application) => (req: Request, res: Response) => Promise<void>;
	//# sourceMappingURL=standalone-config-middleware.d.ts.map
}
// From file: @sage/xtrem-service/build/lib/middlewares/index.d.ts
declare module '@sage/xtrem-service/lib/middlewares/index' {
	export * from '@sage/xtrem-service/lib/middlewares/auth-middleware';
	export * from '@sage/xtrem-service/lib/middlewares/cloudflare-middleware';
	export * from '@sage/xtrem-service/lib/middlewares/config-middleware';
	export * from '@sage/xtrem-service/lib/middlewares/csrf-middleware';
	export * from '@sage/xtrem-service/lib/middlewares/standalone-config-middleware';
	export * from '@sage/xtrem-service/lib/middlewares/too-busy-middleware';
	export * from '@sage/xtrem-service/lib/middlewares/xtrem-ui-plugin-middleware';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/xtrem-service/build/lib/middlewares/helmet-middleware.d.ts
declare module '@sage/xtrem-service/lib/middlewares/helmet-middleware' {
	import { Express, Request } from 'express';
	export interface RequestWithNonce extends Request {
	    nonce?: string;
	}
	export function configureHelmetApp(expressApp: Express): void;
	//# sourceMappingURL=helmet-middleware.d.ts.map
}
// From file: @sage/xtrem-service/build/lib/middlewares/health-check-middleware.d.ts
declare module '@sage/xtrem-service/lib/middlewares/health-check-middleware' {
	import { Application } from '@sage/xtrem-core';
	import { Express } from 'express';
	/**
	 * Adds health check routes to the Express application.
	 *
	 * @param expressApp - The Express application.
	 * @param application - The application object.
	 */
	export const addHealthCheckRoutes: (expressApp: Express, application: Application) => void;
	//# sourceMappingURL=health-check-middleware.d.ts.map
}
// From file: @sage/xtrem-service/build/lib/middlewares/error-handlers.d.ts
declare module '@sage/xtrem-service/lib/middlewares/error-handlers' {
	import { Handler, Request, Response } from 'express';
	export const unauthorized: (req: Request, res: Response) => Response;
	export const forbidden: (req: Request, res: Response) => Response;
	export const badRequest: (req: Request, res: Response) => Response;
	export const tooBusyError: (retryAfterInSeconds: number, req: Request, res: Response) => Response;
	export const notFoundApp: Handler;
	//# sourceMappingURL=error-handlers.d.ts.map
}
// From file: @sage/xtrem-service/build/lib/middlewares/csrf-middleware.d.ts
declare module '@sage/xtrem-service/lib/middlewares/csrf-middleware' {
	import { Handler } from 'express';
	export const csrfMiddleware: Handler;
	//# sourceMappingURL=csrf-middleware.d.ts.map
}
// From file: @sage/xtrem-service/build/lib/middlewares/config-middleware.d.ts
declare module '@sage/xtrem-service/lib/middlewares/config-middleware' {
	import { Handler } from 'express';
	export const configMiddleware: Handler;
	//# sourceMappingURL=config-middleware.d.ts.map
}
// From file: @sage/xtrem-service/build/lib/middlewares/cloudflare-middleware.d.ts
declare module '@sage/xtrem-service/lib/middlewares/cloudflare-middleware' {
	import { Handler } from 'express';
	export const cloudflareMiddleware: Handler;
	//# sourceMappingURL=cloudflare-middleware.d.ts.map
}
// From file: @sage/xtrem-service/build/lib/middlewares/auth-middleware.d.ts
declare module '@sage/xtrem-service/lib/middlewares/auth-middleware' {
	import { Handler } from 'express';
	export const authMiddleware: Handler;
	//# sourceMappingURL=auth-middleware.d.ts.map
}
// From file: @sage/xtrem-service/build/lib/endpoints/metrics-endpoint.d.ts
declare module '@sage/xtrem-service/lib/endpoints/metrics-endpoint' {
	import { Application } from '@sage/xtrem-core';
	import { Express } from 'express';
	import { HttpEndpoint, HttpEndpointConfig } from '@sage/xtrem-service/lib/endpoints/http-endpoint';
	/**
	 * Represents an endpoint for handling metrics.
	 */
	export class MetricsEndpoint extends HttpEndpoint {
	    /**
	     * Configures the Express app with the necessary middleware and routes for metrics and health checks.
	     *
	     * @param expressApp - The Express app instance.
	     */
	    configureExpressApp(expressApp: Express): void;
	    /**
	     * Retrieves the configuration for the metrics endpoint.
	     * @returns The HTTP endpoint configuration or undefined if the metrics endpoint is disabled.
	     */
	    static getConfig(application: Application): HttpEndpointConfig | undefined;
	    /**
	     * Creates a new MetricsEndpoint instance.
	     *
	     * @param application - The application instance.
	     * @returns A MetricsEndpoint instance if the endpoint is enabled, otherwise undefined.
	     */
	    static create(application: Application): MetricsEndpoint | undefined;
	}
	//# sourceMappingURL=metrics-endpoint.d.ts.map
}
// From file: @sage/xtrem-service/build/lib/endpoints/interop-endpoint.d.ts
declare module '@sage/xtrem-service/lib/endpoints/interop-endpoint' {
	import { Application } from '@sage/xtrem-core';
	import { Express } from 'express';
	import { HttpEndpoint, HttpEndpointConfig } from '@sage/xtrem-service/lib/endpoints/http-endpoint';
	/**
	 * Represents an endpoint for interop GraphQl calls between apps.
	 */
	export class InteropEndpoint extends HttpEndpoint {
	    /**
	     * Configures the Express app with the interop middleware.
	     *
	     * @param expressApp - The Express app instance.
	     */
	    configureExpressApp(expressApp: Express): void;
	    /**
	     * Retrieves the configuration for the interop endpoint.
	     * @returns The HTTP endpoint configuration or undefined if the configuration is missing or the endpoint is not enabled.
	     */
	    static getConfig(): HttpEndpointConfig | undefined;
	    /**
	     * Creates a new InteropEndpoint instance.
	     *
	     * @param application - The application to associate with the InteropEndpoint.
	     * @returns The created InteropEndpoint instance, or undefined if the endpoint is not enabled.
	     */
	    static create(application: Application): InteropEndpoint | undefined;
	}
	//# sourceMappingURL=interop-endpoint.d.ts.map
}
// From file: @sage/xtrem-service/build/lib/endpoints/http-endpoint.d.ts
declare module '@sage/xtrem-service/lib/endpoints/http-endpoint' {
	import { Application } from '@sage/xtrem-core';
	import { Express } from 'express';
	import * as http from 'http';
	import * as https from 'https';
	import { TlsOptions } from 'tls';
	export interface HttpEndpointConfig {
	    port: number;
	    description: string;
	    ssl?: TlsOptions;
	    exclusive?: boolean;
	    sendPortToParentProcess?: boolean;
	}
	/**
	 * Base class for HTTP endpoints
	 */
	export abstract class HttpEndpoint {
	    readonly application: Application;
	    private readonly config;
	    protected httpServer: http.Server | https.Server;
	    protected constructor(application: Application, config: HttpEndpointConfig);
	    /** The port number for the HTTP endpoint. */
	    get port(): number;
	    /** The description of the HTTP endpoint. */
	    get description(): string;
	    /**
	     * Configures the Express app with the necessary middleware, routes, etc.
	     * This method should be implemented by subclasses to provide the specific configuration.
	     *
	     * @param expressApp The Express app instance.
	     */
	    protected abstract configureExpressApp(expressApp: Express): void;
	    /**
	     * Sends the dynamic port allocated back to the parent process via the worker instance 'message' event listener.
	     * This method is intended to be used in a worker process.
	     * @param port The dynamic port allocated for the worker process.
	     * @param workerId The ID of the worker process.
	     */
	    private static sendPortToParentProcess;
	    /**
	     * Starts the HTTP server and listens for incoming requests.
	     * If SSL is enabled, it creates an HTTPS server, otherwise it creates an HTTP server.
	     * If running in a worker process, it allocates a dynamic port, otherwise it uses the configured port.
	     *
	     * @returns A Promise that resolves when the server has started successfully.
	     */
	    start(): Promise<void>;
	}
	//# sourceMappingURL=http-endpoint.d.ts.map
}
// From file: @sage/xtrem-service/build/lib/endpoints/graphql-endpoint.d.ts
declare module '@sage/xtrem-service/lib/endpoints/graphql-endpoint' {
	import { Application, AsyncResponse } from '@sage/xtrem-core';
	import { Express } from 'express';
	import * as http from 'http';
	import { HttpEndpoint, HttpEndpointConfig } from '@sage/xtrem-service/lib/endpoints/http-endpoint';
	export class GraphqlEndpoint extends HttpEndpoint {
	    configureExpressApp(expressApp: Express): this;
	    private addStandardGraphqlRoutes;
	    private addNotFoundMiddleware;
	    addAllGraphqlRoutes(expressApp: Express): void;
	    start(): Promise<void>;
	    static getConfig(): HttpEndpointConfig;
	    static create(application: Application): GraphqlEndpoint;
	}
	export const GraphqlEndpointHooks: {
	    setAuthenticationMiddlewares(expressApp: Express, application: Application): void;
	    addSpecialRoutes(_expressApp: Express, _application: Application): void;
	    getRequestSource(_request: http.IncomingMessage): AsyncResponse<string>;
	    getSourcesToSeed(): string[];
	    getSourceMaxWorkers(_requestSource: string): number | undefined;
	    /**
	     * Starts the websocket services.
	     * This is done via a hook because x3-services should not load the xtrem-infrastucture-adapter dependency
	     * @param _application
	     */
	    startWebSocketServices(_application: Application): void;
	};
	//# sourceMappingURL=graphql-endpoint.d.ts.map
}
declare module '@sage/xtrem-service' {
	export * from '@sage/xtrem-service/index';
}
