/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.startApplication=startApplication;const xtrem_core_1=require("@sage/xtrem-core"),graphql_endpoint_1=require("./endpoints/graphql-endpoint"),interop_endpoint_1=require("./endpoints/interop-endpoint"),metrics_endpoint_1=require("./endpoints/metrics-endpoint"),loggers_1=require("./loggers"),token_invalidation_1=require("./token-invalidation"),logger=loggers_1.loggers.service;function logApplicationInfo(e){const t=xtrem_core_1.ConfigManager.current;if(logger.info(`Deployment mode is ${t.deploymentMode}`),logger.info("Framework packages:"),e.getPlatformPackages().forEach(e=>{logger.info(`\t- ${e.name}: ${e.version}`)}),logger.info("Application packages:"),e.getPackages().forEach(e=>{logger.info(`\t- ${e.name}: ${e.packageJson.version}`)}),xtrem_core_1.Logger.isLogAsJson())logger.info(`Start options: ${(0,xtrem_core_1.json5Stringify)(e.startOptions)}`);else logger.info("Start options:"),Object.keys(e.startOptions).forEach(t=>{logger.info(`\t${t}: ${e.startOptions[t]}`)})}function requiresInteropService(e){const t=xtrem_core_1.ConfigManager.current;return!t.storage?.managedExternal&&"routing"!==e.startOptions.channels.join()}Error.stackTraceLimit=100,(0,xtrem_core_1.sourceMapSetup)(),process.on("SIGINT",()=>{token_invalidation_1.TokenInvalidationService.stop(),console.error(`process ${process.pid} killed by SIGINT`),process.exit(1)});const canStartHealthMonitoring=requiresInteropService;function startContainerHeartbeatMonitor(e){if(canStartHealthMonitoring(e))xtrem_core_1.ContainerHeartbeatMonitor.activateHeartbeatPublications(e),xtrem_core_1.ContainerHeartbeatMonitor.activate()}function startAppsHealthCheckMonitor(e){if(canStartHealthMonitoring(e))xtrem_core_1.InteropAppHealthMonitor.start()}function startUnhandledErrorMonitor(){const e=xtrem_core_1.ConfigManager.current;xtrem_core_1.unhandledErrorMonitor.start(e.errorMonitoringInterval,e.errorMonitoringThreshold)}async function startPackageServices(e){if(xtrem_core_1.ConfigManager.current.storage?.managedExternal)return;const t=e.servicePackagesStarted;await(0,xtrem_core_1.asyncArray)(t.filter(t=>e.startOptions.services.includes(t.name))).forEach(async t=>{if(t.api.startService)logger.info(()=>`starting service ${t.name}`),await t.api.startService(e)})}async function startApplication(e){e.activityManager.resolvePermissions(),e.validateActivities(),logApplicationInfo(e),startUnhandledErrorMonitor(),startContainerHeartbeatMonitor(e),startAppsHealthCheckMonitor(e);const t=graphql_endpoint_1.GraphqlEndpoint.create(e);if(await startPackageServices(e),await t.start(),requiresInteropService(e))await(interop_endpoint_1.InteropEndpoint.create(e)?.start());await(metrics_endpoint_1.MetricsEndpoint.create(e)?.start()),e.setReady()}
//# sourceMappingURL=start-application.js.map