/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.xtremUiPluginsMiddleware=void 0;const xtrem_core_1=require("@sage/xtrem-core"),express=require("express"),path=require("path"),logger=xtrem_core_1.Logger.getLogger(__filename,"xtrem-ui-plugin-service"),getPackageName=e=>{const r=Buffer.from(e.params.pluginName,"base64").toString("ascii");if(r.startsWith("/")||r.includes("."))throw new Error(`Invalid package name: ${r}`);return r},findPluginPath=(e,r)=>{const t=e.getPackages();for(const e of t)try{return path.dirname(require.resolve(`${r}/package.json`,{paths:[e.dir]}))}catch{}throw new Error(`Plugin package is not found: ${r}`)},xtremUiPluginsMiddleware=e=>{const r=express();return r.get("/:pluginName",(r,t)=>{try{if(r.params.pluginName){const a=getPackageName(r),s=findPluginPath(e,a),i=require(`${s}/package.json`);if(i.xtremPlugin)return void t.redirect(`/plugins/${r.params.pluginName}/${i.main}`)}t.status(404).send()}catch(e){logger.warn(`Failed to resolve plugin entry file. ${r.path} (FYI: plugin name is base64 encoded).`),logger.warn(e),t.status(404).send()}}),r.get("/:pluginName{/*path}",(r,t)=>{try{if(!(r.params.pluginName&&r.path.includes("build")&&!r.path.includes("..")))return void t.status(404).send();const a=getPackageName(r),s=findPluginPath(e,a),i=require(`${s}/package.json`);if(!i.xtremPlugin)return void t.status(404).send();const n=r.path.replace(`/${r.params.pluginName}/`,""),g=path.resolve(s,n);(async()=>{if(await(0,xtrem_core_1.fileExists)(g)){t.setHeader("X-XTREM-PLUGIN-VERSION",i.version);const e=path.relative(s,g);t.sendFile(e,{root:s})}else t.status(404).send()})().catch(e=>{logger.error(e),t.status(500).send()})}catch(e){logger.warn(`Failed to return requested plugin file: ${r.path} (FYI: plugin name is base64 encoded).`),logger.warn(e),t.status(404).send()}}),r};exports.xtremUiPluginsMiddleware=xtremUiPluginsMiddleware;
//# sourceMappingURL=xtrem-ui-plugin-middleware.js.map