/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.tooBusyMiddleware=void 0,exports.addMakeMeBusyRoute=addMakeMeBusyRoute;const xtrem_core_1=require("@sage/xtrem-core"),xtrem_shared_1=require("@sage/xtrem-shared"),loggers_1=require("../loggers"),error_handlers_1=require("./error-handlers"),toobusy=require("toobusy-js"),defaultConfig={retryAfterInSeconds:5,maxLagInMillis:3e3,intervalInMillis:1e3,smoothingFactor:toobusy.smoothingFactor()};toobusy.maxLag(defaultConfig.maxLagInMillis),toobusy.interval(defaultConfig.intervalInMillis),toobusy.smoothingFactor(defaultConfig.smoothingFactor),loggers_1.loggers.service.info(`Set toobusy default config: maxLag=${toobusy.maxLag()}ms, interval=${toobusy.interval()}, smoothingFactor=${toobusy.smoothingFactor()}`),xtrem_core_1.ConfigManager.emitter.addListener("loaded",()=>{const e=xtrem_core_1.ConfigManager.current.security?.services?.tooBusy;if(!e?.disabled)toobusy.maxLag(e?.maxLagInMillis||defaultConfig.maxLagInMillis),toobusy.interval(e?.intervalInMillis||defaultConfig.intervalInMillis),toobusy.smoothingFactor(e?.smoothingFactor||defaultConfig.smoothingFactor),loggers_1.loggers.service.info(`Set toobusy config: maxLag=${toobusy.maxLag()}ms, interval=${toobusy.interval()}, smoothingFactor=${toobusy.smoothingFactor()}`);else loggers_1.loggers.service.warn("toobusy middleware is disabled")});const tooBusyMiddleware=(e,o,r)=>{const t=xtrem_core_1.ConfigManager.current.security?.services?.tooBusy;if(!t?.disabled&&toobusy())(0,error_handlers_1.tooBusyError)(t?.retryAfterInSeconds||defaultConfig.retryAfterInSeconds,e,o);else r()};function addMakeMeBusyRoute(e){if((0,xtrem_shared_1.isDevelopmentConfig)(xtrem_core_1.ConfigManager.current)&&["1","true"].includes(process.env.XTREM_DEV_BUSY_ROUTE??""))e.get("/dev/make-me-busy/:factor",(e,o)=>{let r=0;const t=Date.now(),s=1e6*parseInt(e.params.factor||"1",10);for(;r<s;)r++;o.json({factor:e.params.factor,elapsed:Date.now()-t})})}exports.tooBusyMiddleware=tooBusyMiddleware,toobusy.onLag(e=>{loggers_1.loggers.service.warn(`Event loop lag detected! Latency: ${Math.floor(1e3*e)/1e3}ms`)});
//# sourceMappingURL=too-busy-middleware.js.map