/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.standaloneConfigMiddleware=void 0;const xtrem_core_1=require("@sage/xtrem-core"),xtrem_shared_1=require("@sage/xtrem-shared"),logger=xtrem_core_1.Logger.getLogger(__filename,"aggrid"),getEncryptedLicenceKey=(e,a)=>{if(a.locals.context&&e.agGridLicenceKey){const a=Buffer.from(e.agGridLicenceKey).toString("base64");return logger.debug(()=>`Encrypted licence: ${a}`),a}return null},getAvailableLocales=(e,a)=>{if(a.locals.context&&e.mainPackage.isMain&&e.mainPackage.packageJson?.xtrem?.locales){const a=e.mainPackage.packageJson?.xtrem?.locales.filter(e=>void 0!==xtrem_shared_1.locales.find(a=>e===a));if(0===a.length)return;return logger.info(()=>`Available locales for package ${e.mainPackage.name} : ${a}`),a}return},standaloneConfigMiddleware=(e,a)=>{if(e.agGridLicenceKey)logger.debug(()=>`Configured ag-grid key: ${e.agGridLicenceKey}`);else logger.debug(()=>"No ag grid key is configured.");return async(r,t)=>{if(!t.locals.context)return void t.json(null);const o=t.locals.config;let i=false,n=false;await a.withReadonlyContext((0,xtrem_core_1.getTenantId)(a,o),async e=>{try{const r=xtrem_core_1.CoreHooks.getChatbotManager(a);i=await r.isChatbotEnabled(e)}catch(e){logger.warn(()=>`Error checking Xtrem Chatbot availability: ${e}`)}try{const a=xtrem_core_1.CoreHooks.getSageAiManager();n=await a.isSageAiEnabled(e)}catch(e){logger.warn(()=>`Error checking Sage AI availability: ${e}`)}},{userEmail:t.locals?.config?.email});const c={agGridLicenceKey:getEncryptedLicenceKey(e,t),chatbotBackendUrl:n?e.copilot?.serviceUrl:void 0,chatbotGmsClient:n?e.copilot?.gmsClient??"sdmo_v1":void 0,chatbotAccessCodeLifeTimeInMinutes:n?e.copilot?.accessCodeLifeTimeInMinutes:void 0,productName:e.productName||"Sage Distribution and Manufacturing Operations",app:e.app,pendoClusterTag:e.pendo?.clusterTag,locales:getAvailableLocales(a,t),isXtremChatbotAvailable:i};t.json(c)}};exports.standaloneConfigMiddleware=standaloneConfigMiddleware;
//# sourceMappingURL=standalone-config-middleware.js.map