/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.configureHelmetApp=configureHelmetApp;const xtrem_core_1=require("@sage/xtrem-core"),helmet_1=require("helmet"),_=require("lodash"),loggers_1=require("../loggers"),logger=loggers_1.loggers.service,defaultPendoSubscriptionId="5069687185997824",wellKnownUrl={pendo:"https://cdn.pendo.io",pendoStaticStorage:"https://pendo-io-static.storage.googleapis.com",pendoSubIdStaticStorage:"https://pendo-static-{{SUB_ID}}.storage.googleapis.com",pendoApp:"https://app.pendo.io",pendoData:"https://data.pendo.io",sageIdStaging:"https://id-shadow.sage.com",sageIdProd:"https://id.sage.com",sageFontCdn:"https://fonts.sage.com",newRelic:"https://bam.nr-data.net",newRelicCdn:"https://js-agent.newrelic.com",youTube:"https://www.youtube.com",wistia:"https://fast.wistia.net",wistiaThumbnail:"https://embed-ssl.wistia.com"};function configureHelmetApp(e){const t=xtrem_core_1.ConfigManager.current,o=t.documentationServiceUrl?new URL(t.documentationServiceUrl).origin:"",l=t.s3Storage?.s3BucketUrlPrefix,n=t.security,r=n?.redirectUrl?new URL(n.redirectUrl):null,i=n?.loginUrl?new URL(n?.loginUrl).origin:"",s=n?.renewalUrl?new URL(n?.renewalUrl).origin:"",c=n?_.uniq([i,i.replace("http://","https://"),s,s.replace("http://","https://")].filter(e=>!!e)):[];if(t.copilot?.serviceUrl)c.push(new URL(t.copilot.serviceUrl).origin);if(t.copilot?.oauthEndpointUrl)c.push(new URL(t.copilot.oauthEndpointUrl).origin);if("development"===t.deploymentMode)c.push("ws://websocket.localhost:8240");if(r)if(c.push(`wss://websocket.${r.hostname.split(".").slice(1).join(".")}`),"development"===t.deploymentMode)c.push(`ws://websocket.${r.hostname.split(".").slice(1).join(".")}:8240`);if(l)c.push(l);const a=n?.services?.helmet,p=!a?.disabledOptions?.csp;if(!p)logger.warn("Helmet: CSP (Content Security Policy) is disabled");const d="https:"===r?.protocol&&!a?.disabledOptions?.hsts?a?.hsts||true:false;if(!d)logger.warn("Helmet: HSTS (HTTP Strict Transport Security) is disabled");const w=helmet_1.default.contentSecurityPolicy.getDefaultDirectives(),u=wellKnownUrl.pendoSubIdStaticStorage.replace("{{SUB_ID}}",t.pendo?.subscriptionId||defaultPendoSubscriptionId),g=["'self'","data:",wellKnownUrl.pendo,wellKnownUrl.pendoStaticStorage,u,wellKnownUrl.pendoApp],h={scriptSrc:["'unsafe-eval'","'unsafe-inline'",...g,u,wellKnownUrl.pendoData,wellKnownUrl.sageIdStaging,wellKnownUrl.sageIdProd,wellKnownUrl.newRelic,wellKnownUrl.newRelicCdn],imgSrc:[...g,u,wellKnownUrl.pendoData,wellKnownUrl.youTube,wellKnownUrl.wistiaThumbnail,"blob:"],workerSrc:["blob:","data:","'self'"],styleSrc:["'unsafe-inline'",...g,wellKnownUrl.sageFontCdn],objectSrc:["'self'","blob:"],frameSrc:[...g,i,o,wellKnownUrl.youTube,wellKnownUrl.wistia,"blob:"],connectSrc:["'self'","blob:",wellKnownUrl.pendoApp,wellKnownUrl.pendoData,u,wellKnownUrl.newRelic,...c],childSrc:["'self'",wellKnownUrl.pendoApp],upgradeInsecureRequests:d?w["upgrade-insecure-requests"]:null},U=a?.csp?.directives||{};Object.entries(U).forEach(([e,t])=>{if(null==t)return;h[e]=[...h[e]||[],...t]});const f=_.cloneDeep(h),cspMiddleware=(e,t,o)=>{helmet_1.default.contentSecurityPolicy({useDefaults:true,directives:f})(e,t,o)};if(e.use((0,helmet_1.default)({strictTransportSecurity:d,contentSecurityPolicy:p,hidePoweredBy:true})),p)e.use(cspMiddleware)}
//# sourceMappingURL=helmet-middleware.js.map