/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.authMiddleware=void 0;const xtrem_core_1=require("@sage/xtrem-core"),xtrem_metrics_1=require("@sage/xtrem-metrics"),xtrem_shared_1=require("@sage/xtrem-shared"),axios_1=require("axios"),jwt=require("jsonwebtoken"),jwksClient=require("jwks-rsa"),token_invalidation_1=require("../token-invalidation"),error_handlers_1=require("./error-handlers"),auth0WebUserPrefix="auth0",auth0ApiPrefix="api",auth0CopilotPrefix="copilot",isNewrelicDisabled="true"!==process.env.NEW_RELIC_ENABLED,logger=xtrem_core_1.Logger.getLogger(__filename,"auth");function extractToken(e){if(!e||e.length<8)return null;if(0!==e.indexOf("Bearer "))return null;const t=/^Bearer\s+([a-zA-Z0-9_-]+\.[a-zA-Z0-9_-]+\.[a-zA-Z0-9_-]+)/.exec(e);return t&&t[1]}function redirectToLogin(e,t,r){if(e.accepts("html")){if(!r.loginUrl)throw new Error("Cannot redirect: no login URL configured");const o=r.redirectUrl?`?fromUrl=${encodeURIComponent(r.redirectUrl+e.url)}`:"";return void t.redirect(`${r.loginUrl}${o}`)}(0,error_handlers_1.unauthorized)(e,t)}function extractRemoteContextHeader(e,t,r){const o=e.headers["x-xtrem-remote-context"];if(o)try{t.locals.remoteContext=JSON.parse(o)}catch{throw new Error("failed to parse x-xtrem-remote-context header as JSON")}else if(r?.remoteContext)t.locals.remoteContext=r.remoteContext;return}const authMiddleware=async(e,t,r)=>{const o=xtrem_core_1.ConfigManager.current,{security:n}=o;if(t.locals.auth={},(0,xtrem_shared_1.isDevelopmentConfig)(o)){if((0,xtrem_shared_1.isEnvVarTrue)(process.env.UNSECURE_DEV_LOGIN)){if("/unsecuredevlogin"===e.path){if(!e.query.user||!e.query.tenant)return void unauthorizedError("user and tenant are mandatory for unsecure dev login",e,t);t.locals.auth={login:e.query.user,tenantId:e.query.tenant},t.cookie("access_token",`${e.query.tenant}_${t.locals.auth.login}`),t.cookie("access_token_sign",`${e.query.tenant}_${t.locals.auth.login}`);const r=e.get("host");if(r)t.location(`${e.protocol}://${r}`),t.status(302);return void t.send()}const{access_token:r,access_token_sign:o}=e.cookies;if(r&&o&&r===o){const[e,o]=r.split("_");t.locals.auth={login:o,tenantId:e}}else if(e.headers.authorization){const r=/^Basic\s+(.*)/.exec(e.headers.authorization||"");if(r){const o=Buffer.from(r[1],"base64").toString();if(o)t.locals.auth={login:o.split(":")[0],tenantId:e.cookies.access_token.split("_")[0]}}}}if(o.auth)t.locals.auth.login??=o.auth?.login,t.locals.auth.tenantId??=o.auth?.tenantId,t.locals.auth.auth0??=o.auth?.auth0;else t.locals.auth.login??=o.user??xtrem_core_1.Test.defaultEmail,t.locals.auth.tenantId??=o.tenantId??xtrem_core_1.Test.defaultTenantId;const r=t.locals.auth.login;if(t.locals.context={email:r,tenantId:t.locals.auth.tenantId},r){const e=/^api-(\w+)@((?:[a-zA-Z0-9-]+\.)+[a-zA-Z]{2,7})$/.exec(r);t.locals.context.auth0=e?`api|${e[1]}`:"auth0|7bda53083aef4b4780ecbb73a318a966"}sharpenNewrelicContext(auth0WebUserPrefix,t.locals.auth.tenantId,t.locals.context.auth0,e.headers);const n=`xtrem_${t.locals.auth.tenantId}_persona`;if(e.cookies[n])t.locals.auth.persona=e.cookies[n];extractRemoteContextHeader(e,t)}if(!n||shouldIgnoreAuthentication(e,n))return void r();try{const{token:a,auth0Type:i}=await verifyAuth(n,e);if(!a){if(e.accepts("html")){if(!n.loginUrl)throw new Error("Cannot redirect: no login URL configured");return void redirectToLogin(e,t,n)}throw new Error("no token")}else{if(token_invalidation_1.TokenInvalidationService.isInvalidatedToken(a))throw new Error("token has been invalidated");if(verifyTokenClaims(a,o),n.enableAutoRefresh&&e.accepts("html"))await tryAutoRefeshToken(a,n,e,t);if(!a.pref&&a.auth0&&i===auth0WebUserPrefix)return void redirectToLogin(e,t,n);t.locals.context={email:a.sub,tenantId:a.tenantId,pref:a.pref},t.locals.auth={...t.locals.auth,login:a.sub,tenantId:a.tenantId,auth0:a.auth0},extractRemoteContextHeader(e,t,a),sharpenNewrelicContext(i,a.tenantId||"unknown",a.auth0,e.headers);const s=`xtrem_${t.locals.context.tenantId}_persona`;if(e.cookies[s])t.locals.auth.persona=e.cookies[s];r()}}catch(r){if(n.loginUrl&&e.accepts("html")&&r instanceof jwt.JsonWebTokenError){if(r instanceof jwt.TokenExpiredError||/^jwt audience invalid\./i.test(r.message))return logger.warn(`Redirecting to ${n.loginUrl} request ${e.method} ${e.url} [${r.message}]`),void t.redirect("GET"===e.method?302:307,n.loginUrl)}unauthorizedError(r.message,e,t)}};function shouldIgnoreAuthentication(e,t){const r=/^\/(ping)$/.test(e.path)||/^\/login-service$/.test(e.path);return!t?.loginUrl||r}function sharpenNewrelicContext(e,t,r,o){if(isNewrelicDisabled)return;const n=o["cf-ray"],a={tenantId:t,requestOrigin:getNewRelicSourceFromAuth0Type(e),cfRay:n};if((e===auth0ApiPrefix||e===auth0CopilotPrefix)&&r){const e=r.split("|");if(e.length>=2)a.developerId=e[1];else logger.warn(`Unable to extract the develpperId from an api gateway call, auth0field is : ${r}`),a.developerId="unknown"}try{(0,xtrem_metrics_1.addCustomAttributesToNewrelic)(a)}catch({message:e}){logger.warn(`Failed to send custom attributes to newrelic ${e}`)}}function getNewRelicSourceFromAuth0Type(e){if(!e)return"unknown";switch(e){case auth0WebUserPrefix:return"webuser";case auth0CopilotPrefix:return"copilot";case auth0ApiPrefix:return"apigateway";default:return logger.warn(`unknown source for newrelic request context : ${e}`),"unknown"}}function unauthorizedError(e,t,r){return(0,xtrem_core_1.logSecurityAlert)(t,"unauthorized",e),(0,error_handlers_1.unauthorized)(t,r)}async function verifyAuth(e,t){const r={authHeader:t.headers.authorization};let o;if(r.authHeader){if(r.authScheme=r.authHeader.split(" ")[0],o=extractToken(r.authHeader),!o)throw new Error(`Invalid token: authorization scheme ${r.authScheme}`)}else if(t.cookies.access_token&&t.cookies.access_token_sign)o=`${t.cookies.access_token}.${t.cookies.access_token_sign}`;else return{};if(3!==o?.split(".").length)throw new Error("Invalid token: must contain 3 segments");if(r.token=await verifyAuthToken(o,e),r.auth0Type=(r.token.auth0||"").split("|")[0],r.authHeader){if(r.auth0Type!==auth0ApiPrefix&&r.auth0Type!==auth0CopilotPrefix)throw new Error(`Bearer authentication expects an api token, got '${r.token.auth0}'`)}else if(r.auth0Type===auth0ApiPrefix||r.auth0Type===auth0CopilotPrefix)throw new Error(`Cookie authentication cannot use an api token, got '${r.token.auth0}'`);return r}let cachedClient;function getJwksClient(e){if(!cachedClient){if(!e)throw new Error("missing 'jwksUrl' value in security config");cachedClient=jwksClient({cache:true,jwksUri:e||""})}return cachedClient}function verifyAuthToken(e,t){const{issuer:r,audience:o,jwksUrl:n}=t,a=(()=>{const e=getJwksClient(n);return(t,r)=>e.getSigningKey(t.kid,(e,t)=>{if(e)r(e);else r(null,t.getPublicKey())})})(),i={issuer:r,algorithm:"RS256",audience:o};return new Promise((t,r)=>{jwt.verify(e,a,i,(e,o)=>{if(e)r(e);else t(o)})})}async function tryAutoRefeshToken(e,t,r,o){const n=null==e.exp?-1:e.exp-Math.floor(Date.now()/1e3),a=t.renewalThreshold||300;if(n>=0&&n<a&&r.cookies.refresh_token&&r.cookies.refresh_token_sign){const e={timeout:500,headers:{"x-refresh-token":`${r.cookies.refresh_token}.${r.cookies.refresh_token_sign}`,"x-access-token":`${r.cookies.access_token}.${r.cookies.access_token_sign}`,connection:"Keep-Alive"}};try{const r=t.renewalUrl||`${t.loginUrl}/renew`,n=(await axios_1.default.get(r,e)).headers["set-cookie"].filter(e=>/^(?:access|refresh)_token(?:_sign)?=/.test(e));o.set("set-cookie",n)}catch(e){logger.error(`Failed to auto-refresh token: ${e.message}`)}}}function verifyTokenClaims(e,t){const{security:r,app:o}=t;if(!o)return true;if(!e.app)throw new Error("token does not contain app claim");if(!e.apps)throw new Error("token does not contain apps claim");if(!e.apps.includes(o))throw new Error(`token is not valid for app '${o}'`);if(e.aud!==r?.audience)throw new Error(`jwt audience invalid. It does not match security config, expected: ${r?.audience}, got: ${e.aud}`);return true}exports.authMiddleware=authMiddleware;
//# sourceMappingURL=auth-middleware.js.map