/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.HttpEndpoint=void 0;const xtrem_core_1=require("@sage/xtrem-core"),express=require("express"),http=require("http"),https=require("https"),loggers_1=require("../loggers"),logger=loggers_1.loggers.service;class HttpEndpoint{constructor(e,t){this.application=e,this.config=t}get port(){return this.config.port}get description(){return this.config.description}static sendPortToParentProcess(e,t){if(t&&process.send)process.send({event:"listening",workerId:process.env.XTREM_WORKER_ID,port:e},void 0,void 0,e=>{if(e)logger.info(`Error sending message to worker parent process for worker ${t}, ${e?.message}`)})}async start(){const e=express();if(this.configureExpressApp(e),this.config?.ssl)this.httpServer=https.createServer(this.config.ssl,e),xtrem_core_1.TlsHelper.registerTlsChangeListener(this.httpServer,"server.ssl","HTTPS");else this.httpServer=http.createServer(e);const t=process.env.XTREM_WORKER_ID,r=!!this.config.exclusive,s=null!=t?0:this.port;await new Promise((e,o)=>{const i=this.httpServer.listen({port:s,exclusive:r});i.on("listening",()=>{const r=i.address().port,s=null!=t?` for worker ${t}`:"",o=this.config.ssl?" over TLS":"";if(logger.info(`${this.description} started on port ${r||this.port}${s}${o}`),this.config.sendPortToParentProcess)HttpEndpoint.sendPortToParentProcess(r,t);e()}).on("error",e=>{console.error(`Cannot start ${this.description}: ${e.stack}`),o(e)})})}}exports.HttpEndpoint=HttpEndpoint;
//# sourceMappingURL=http-endpoint.js.map