/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.GraphqlEndpointHooks=exports.GraphqlEndpoint=void 0;const xtrem_chatbot_service_1=require("@sage/xtrem-chatbot-service"),xtrem_core_1=require("@sage/xtrem-core"),xtrem_shared_1=require("@sage/xtrem-shared"),body_parser_1=require("body-parser"),compression=require("compression"),cookieParser=require("cookie-parser"),loggers_1=require("../loggers"),middlewares_1=require("../middlewares"),error_handlers_1=require("../middlewares/error-handlers"),health_check_middleware_1=require("../middlewares/health-check-middleware"),helmet_middleware_1=require("../middlewares/helmet-middleware"),token_invalidation_1=require("../token-invalidation"),xtrem_ui_app_1=require("../xtrem-ui-app"),http_endpoint_1=require("./http-endpoint"),logger=loggers_1.loggers.service;class GraphqlEndpoint extends http_endpoint_1.HttpEndpoint{configureExpressApp(e){if(e.use(middlewares_1.cloudflareMiddleware),e.use((0,xtrem_core_1.requestLoggerMiddleware)(loggers_1.loggers.http)),e.use(cookieParser()),e.use((0,body_parser_1.json)({limit:xtrem_core_1.ConfigManager.getSizeLimit("maxRequestSize")})),e.use((0,xtrem_core_1.bodyLoggerMiddleware)(loggers_1.loggers.http)),(0,xtrem_core_1.loggerAllowsCompress)(loggers_1.loggers.http))e.use(compression());else logger.warn("compression middleware disabled in HTTP verbose mode");if((0,helmet_middleware_1.configureHelmetApp)(e),(0,health_check_middleware_1.addHealthCheckRoutes)(e,this.application),e.use(middlewares_1.tooBusyMiddleware),this.application.startOptions.channels.includes("graphql"))this.addAllGraphqlRoutes(e);return this}addStandardGraphqlRoutes(e){const r=xtrem_core_1.ConfigManager.current;if(xtrem_core_1.FileStorageManager.addAuthenticatedRoutes(e,this.application),e.use("/graphql",(e,r)=>{if(e.accepts("text/html"))r.redirect("/explorer");else r.redirect("/api")}),e.use("/explorer",middlewares_1.csrfMiddleware,(0,xtrem_core_1.graphQlApp)(this.application,{endpoint:"/explorer"})),e.use("/api",middlewares_1.csrfMiddleware,(0,xtrem_core_1.graphQlApp)(this.application,{graphiqlDisabled:true})),e.use("/metadata",middlewares_1.csrfMiddleware,(0,xtrem_core_1.graphQlMetadata)(this.application)),e.use("/login-service",(e,t)=>{t.json(r?.security?.loginUrl)}),e.use("/standalone-config",(0,middlewares_1.standaloneConfigMiddleware)(r,this.application)),e.use("/plugins",(0,middlewares_1.xtremUiPluginsMiddleware)(this.application)),e.get("/documentation",(e,t)=>{if(r.documentationServiceUrl)t.redirect(r.documentationServiceUrl),t.end();else throw new Error("Documentation service URL is not configured.")}),r.mcpServer?.enabled)e.use("/chat",(0,xtrem_chatbot_service_1.getChatRouter)(this.application)),logger.info("/chat route is enabled");if((0,xtrem_shared_1.isDevelopmentConfig)(r))(0,middlewares_1.addMakeMeBusyRoute)(e)}addNotFoundMiddleware(e){const r=xtrem_core_1.ConfigManager.current;if(r.noUi)e.use(error_handlers_1.notFoundApp);else{const t=this.application.getPlatformPackages().find(e=>"@sage/xtrem-standalone"===e.name)?.version;e.get("*path",(0,xtrem_ui_app_1.serveStaticXtremUi)("production"===r.deploymentMode||r.prodUi,r.newRelic,t,r.disableUiTemplateCache))}}addAllGraphqlRoutes(e){logger.info("Adding graphql routes to express app"),exports.GraphqlEndpointHooks.setAuthenticationMiddlewares(e,this.application),this.addStandardGraphqlRoutes(e),exports.GraphqlEndpointHooks.addSpecialRoutes(e,this.application),this.addNotFoundMiddleware(e)}async start(){await super.start(),this.application.graphqlHttpServer=this.httpServer,exports.GraphqlEndpointHooks.startWebSocketServices(this.application)}static getConfig(){const e=xtrem_core_1.ConfigManager.current,r=process.env.XTREM_WORKER_ID,t=!!r,o=e.apps?.[e.app||""]?.appUrl,i=o&&parseInt(new URL(o).port,10),a=null!=r?0:i||e.server?.port;if(null==a)throw new Error("missing port in config");const s=e.server?.ssl;return{port:a,description:"graphql endpoint",ssl:s,exclusive:t,sendPortToParentProcess:!!r}}static create(e){return new GraphqlEndpoint(e,this.getConfig())}}exports.GraphqlEndpoint=GraphqlEndpoint,exports.GraphqlEndpointHooks={setAuthenticationMiddlewares(e,r){if(!e)throw new Error("expressApp not found");xtrem_core_1.FileStorageManager.addUnauthenticatedRoutes(e,r),e.use(middlewares_1.authMiddleware),e.use(middlewares_1.configMiddleware),token_invalidation_1.TokenInvalidationService.start(xtrem_core_1.ConfigManager.load(r.dir))},addSpecialRoutes(e,r){},getRequestSource(e){throw new xtrem_core_1.SystemError("getRequestSource hook not implemented")},getSourcesToSeed(){throw new xtrem_core_1.SystemError("getSourcesToSeed hook not implemented")},getSourceMaxWorkers(e){return},startWebSocketServices(e){throw new xtrem_core_1.SystemError("startWebSocketService hook not implemented")}};
//# sourceMappingURL=graphql-endpoint.js.map