// From file: @sage/wh-input/build/index.d.ts
declare module '@sage/wh-input/index' {
	export * from '@sage/wh-input/lib/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/wh-input/build/lib/index.d.ts
declare module '@sage/wh-input/lib/index' {
	export * as enums from '@sage/wh-input/lib/enums/index';
	export * as nodeExtensions from '@sage/wh-input/lib/node-extensions/index';
	export * as nodes from '@sage/wh-input/lib/nodes/index';
	export * as serviceOptions from '@sage/wh-input/lib/service-options/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/wh-input/build/lib/service-options/index.d.ts
declare module '@sage/wh-input/lib/service-options/index' {
	export type Dummy = void;
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/wh-input/build/lib/nodes/storing-list.d.ts
declare module '@sage/wh-input/lib/nodes/storing-list' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhProductData from '@sage/wh-product-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, date, Collection, Context } from '@sage/xtrem-core';
	import * as sageWhInput from '@sage/wh-input/lib/index';
	export class StoringList extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly code: Promise<string>;
	    readonly status: Promise<sageWhProductData.enums.StoringListPurchaseOrderStatus>;
	    readonly date: Promise<date>;
	    readonly store: Reference<sageWhMasterData.nodes.Store | null>;
	    readonly directInput: Reference<sageWhInput.nodes.DirectInput | null>;
	    readonly identifier: Promise<string>;
	    readonly order: Promise<sageWhMasterData.enums.PrintingSequence | null>;
	    readonly validationType: Promise<sageWhMasterData.enums.ValidationType | null>;
	    readonly validatingOperator: Reference<sageWhMasterData.nodes.Operand | null>;
	    readonly validatingUser: Promise<string>;
	    readonly postingDate: Promise<date | null>;
	    readonly addressedReceiptMovements: Collection<sageWhInput.nodes.ReceiptMovementAddressed>;
	    readonly closedReceiptMovements: Collection<sageWhInput.nodes.ReceiptMovementClosed>;
	    readonly operatorCode: Promise<string>;
	    static putaway(context: Context, parameter: StoringList): Promise<StoringList>;
	}
	//# sourceMappingURL=storing-list.d.ts.map
}
// From file: @sage/wh-input/build/lib/nodes/receipt-movement-in-progress.d.ts
declare module '@sage/wh-input/lib/nodes/receipt-movement-in-progress' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhProductData from '@sage/wh-product-data';
	import * as sageWhStockData from '@sage/wh-stock-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, decimal, date, integer, Collection } from '@sage/xtrem-core';
	import * as sageWhInput from '@sage/wh-input/lib/index';
	export class ReceiptMovementInProgress extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly directInput: Reference<sageWhInput.nodes.DirectInput>;
	    readonly directInputLine: Reference<sageWhInput.nodes.DirectInputLine>;
	    readonly code: Promise<string>;
	    readonly store: Reference<sageWhMasterData.nodes.Store | null>;
	    readonly imposedStore: Reference<sageWhMasterData.nodes.Store | null>;
	    readonly isExclusiveStore: Promise<boolean>;
	    readonly location: Reference<sageWhMasterData.nodes.Location | null>;
	    readonly locationType: Promise<sageWhMasterData.enums.LocationType | null>;
	    readonly stockObject: Reference<sageWhStockData.nodes.StockObject | null>;
	    readonly containerNumber: Promise<string>;
	    readonly product: Reference<sageWhProductData.nodes.Product>;
	    readonly stockStatus: Reference<sageWhMasterData.nodes.StockNature | null>;
	    readonly source: Reference<sageWhProductData.nodes.Origin | null>;
	    readonly lotNumber: Promise<string>;
	    readonly reservationNumber: Promise<string>;
	    readonly supportNumber: Promise<string>;
	    readonly numberOfContainers: Promise<decimal>;
	    readonly container: Reference<sageWhProductData.nodes.ProductContainer>;
	    readonly quantityInConsumptionUnit: Promise<decimal>;
	    readonly level: Promise<sageWhMasterData.enums.ContainerLevel>;
	    readonly homogeneousQuantity: Promise<decimal>;
	    readonly homogeneousContainer: Reference<sageWhProductData.nodes.ProductContainer>;
	    readonly homogeneousContainerCoefficient: Promise<decimal>;
	    readonly movementCode: Reference<sageWhMasterData.nodes.MovementCode>;
	    readonly status: Promise<sageWhProductData.enums.InputMovementStatus>;
	    readonly fifoDate: Promise<date>;
	    readonly receiptDate: Promise<date | null>;
	    readonly manufacturedDate: Promise<date | null>;
	    readonly detentionDate: Promise<date | null>;
	    readonly sellByDate: Promise<date | null>;
	    readonly useByDate: Promise<date | null>;
	    readonly shipByDate: Promise<date | null>;
	    readonly storingList: Reference<sageWhInput.nodes.StoringList | null>;
	    readonly storingListLineNumber: Promise<integer | null>;
	    readonly movementType: Promise<sageWhProductData.enums.MovementType | null>;
	    readonly containerLevels: Collection<sageWhInput.nodes.ReceiptMovementInProgressContainerLevels>;
	}
	//# sourceMappingURL=receipt-movement-in-progress.d.ts.map
}
// From file: @sage/wh-input/build/lib/nodes/receipt-movement-in-progress-container-levels.d.ts
declare module '@sage/wh-input/lib/nodes/receipt-movement-in-progress-container-levels' {
	import * as sageWhProductData from '@sage/wh-product-data';
	import { Node, integer, Reference, decimal } from '@sage/xtrem-core';
	import * as sageWhInput from '@sage/wh-input/lib/index';
	export class ReceiptMovementInProgressContainerLevels extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly depositor: Promise<string>;
	    readonly directInput: Promise<string>;
	    readonly directInputLine: Promise<integer>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhInput.nodes.ReceiptMovementInProgress>;
	    readonly containerLevel: Reference<sageWhProductData.nodes.ProductContainer | null>;
	    readonly quantityOfConsumptionUnitPerLevel: Promise<decimal | null>;
	}
	//# sourceMappingURL=receipt-movement-in-progress-container-levels.d.ts.map
}
// From file: @sage/wh-input/build/lib/nodes/receipt-movement-closed.d.ts
declare module '@sage/wh-input/lib/nodes/receipt-movement-closed' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhProductData from '@sage/wh-product-data';
	import * as sageWhStockData from '@sage/wh-stock-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, decimal, date, integer, Collection } from '@sage/xtrem-core';
	import * as sageWhInput from '@sage/wh-input/lib/index';
	export class ReceiptMovementClosed extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly directInput: Reference<sageWhInput.nodes.DirectInput>;
	    readonly directInputLine: Reference<sageWhInput.nodes.DirectInputLine>;
	    readonly code: Promise<string>;
	    readonly store: Reference<sageWhMasterData.nodes.Store | null>;
	    readonly imposedStore: Reference<sageWhMasterData.nodes.Store | null>;
	    readonly isExclusiveStore: Promise<boolean>;
	    readonly location: Reference<sageWhMasterData.nodes.Location | null>;
	    readonly locationType: Promise<sageWhMasterData.enums.LocationType | null>;
	    readonly stockObject: Reference<sageWhStockData.nodes.StockObject | null>;
	    readonly containerNumber: Promise<string>;
	    readonly product: Reference<sageWhProductData.nodes.Product>;
	    readonly stockStatus: Reference<sageWhMasterData.nodes.StockNature | null>;
	    readonly source: Reference<sageWhProductData.nodes.Origin | null>;
	    readonly lotNumber: Promise<string>;
	    readonly reservationNumber: Promise<string>;
	    readonly supportNumber: Promise<string>;
	    readonly numberOfContainers: Promise<decimal>;
	    readonly container: Reference<sageWhProductData.nodes.ProductContainer>;
	    readonly quantityInConsumptionUnit: Promise<decimal>;
	    readonly level: Promise<sageWhMasterData.enums.ContainerLevel>;
	    readonly homogeneousQuantity: Promise<decimal>;
	    readonly homogeneousContainer: Reference<sageWhProductData.nodes.ProductContainer>;
	    readonly homogeneousContainerCoefficient: Promise<decimal>;
	    readonly movementCode: Reference<sageWhMasterData.nodes.MovementCode>;
	    readonly status: Promise<sageWhProductData.enums.InputMovementStatus>;
	    readonly fifoDate: Promise<date>;
	    readonly receiptDate: Promise<date | null>;
	    readonly manufacturedDate: Promise<date | null>;
	    readonly detentionDate: Promise<date | null>;
	    readonly sellByDate: Promise<date | null>;
	    readonly useByDate: Promise<date | null>;
	    readonly shipByDate: Promise<date | null>;
	    readonly storingList: Reference<sageWhInput.nodes.StoringList | null>;
	    readonly storingListLineNumber: Promise<integer | null>;
	    readonly movementType: Promise<sageWhProductData.enums.MovementType | null>;
	    readonly containerLevels: Collection<sageWhInput.nodes.ReceiptMovementClosedContainerLevels>;
	}
	//# sourceMappingURL=receipt-movement-closed.d.ts.map
}
// From file: @sage/wh-input/build/lib/nodes/receipt-movement-closed-container-levels.d.ts
declare module '@sage/wh-input/lib/nodes/receipt-movement-closed-container-levels' {
	import * as sageWhProductData from '@sage/wh-product-data';
	import { Node, integer, Reference, decimal } from '@sage/xtrem-core';
	import * as sageWhInput from '@sage/wh-input/lib/index';
	export class ReceiptMovementClosedContainerLevels extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly depositor: Promise<string>;
	    readonly directInput: Promise<string>;
	    readonly directInputLine: Promise<integer>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhInput.nodes.ReceiptMovementClosed>;
	    readonly containerLevel: Reference<sageWhProductData.nodes.ProductContainer | null>;
	    readonly quantityOfConsumptionUnitPerLevel: Promise<decimal | null>;
	}
	//# sourceMappingURL=receipt-movement-closed-container-levels.d.ts.map
}
// From file: @sage/wh-input/build/lib/nodes/receipt-movement-addressed.d.ts
declare module '@sage/wh-input/lib/nodes/receipt-movement-addressed' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhProductData from '@sage/wh-product-data';
	import * as sageWhStockData from '@sage/wh-stock-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, decimal, date, integer, Collection } from '@sage/xtrem-core';
	import * as sageWhInput from '@sage/wh-input/lib/index';
	export class ReceiptMovementAddressed extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly directInput: Reference<sageWhInput.nodes.DirectInput>;
	    readonly directInputLine: Reference<sageWhInput.nodes.DirectInputLine>;
	    readonly code: Promise<string>;
	    readonly store: Reference<sageWhMasterData.nodes.Store | null>;
	    readonly imposedStore: Reference<sageWhMasterData.nodes.Store | null>;
	    readonly isExclusiveStore: Promise<boolean>;
	    readonly location: Reference<sageWhMasterData.nodes.Location | null>;
	    readonly locationType: Promise<sageWhMasterData.enums.LocationType | null>;
	    readonly stockObject: Reference<sageWhStockData.nodes.StockObject | null>;
	    readonly containerNumber: Promise<string>;
	    readonly product: Reference<sageWhProductData.nodes.Product>;
	    readonly stockStatus: Reference<sageWhMasterData.nodes.StockNature | null>;
	    readonly source: Reference<sageWhProductData.nodes.Origin | null>;
	    readonly lotNumber: Promise<string>;
	    readonly reservationNumber: Promise<string>;
	    readonly supportNumber: Promise<string>;
	    readonly numberOfContainers: Promise<decimal>;
	    readonly container: Reference<sageWhProductData.nodes.ProductContainer>;
	    readonly quantityInConsumptionUnit: Promise<decimal>;
	    readonly level: Promise<sageWhMasterData.enums.ContainerLevel>;
	    readonly homogeneousQuantity: Promise<decimal>;
	    readonly homogeneousContainer: Reference<sageWhProductData.nodes.ProductContainer>;
	    readonly homogeneousContainerCoefficient: Promise<decimal>;
	    readonly movementCode: Reference<sageWhMasterData.nodes.MovementCode>;
	    readonly status: Promise<sageWhProductData.enums.InputMovementStatus>;
	    readonly fifoDate: Promise<date>;
	    readonly receiptDate: Promise<date | null>;
	    readonly manufacturedDate: Promise<date | null>;
	    readonly detentionDate: Promise<date | null>;
	    readonly sellByDate: Promise<date | null>;
	    readonly useByDate: Promise<date | null>;
	    readonly shipByDate: Promise<date | null>;
	    readonly storingList: Reference<sageWhInput.nodes.StoringList | null>;
	    readonly storingListLineNumber: Promise<integer | null>;
	    readonly movementType: Promise<sageWhProductData.enums.MovementType | null>;
	    readonly serialNumbers: Collection<sageWhStockData.nodes.SerialNumber>;
	    readonly controlCode: Promise<string>;
	    readonly containerLevels: Collection<sageWhInput.nodes.ReceiptMovementAddressedContainerLevels>;
	}
	//# sourceMappingURL=receipt-movement-addressed.d.ts.map
}
// From file: @sage/wh-input/build/lib/nodes/receipt-movement-addressed-container-levels.d.ts
declare module '@sage/wh-input/lib/nodes/receipt-movement-addressed-container-levels' {
	import * as sageWhProductData from '@sage/wh-product-data';
	import { Node, integer, Reference, decimal } from '@sage/xtrem-core';
	import * as sageWhInput from '@sage/wh-input/lib/index';
	export class ReceiptMovementAddressedContainerLevels extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly depositor: Promise<string>;
	    readonly directInput: Promise<string>;
	    readonly directInputLine: Promise<integer>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhInput.nodes.ReceiptMovementAddressed>;
	    readonly containerLevel: Reference<sageWhProductData.nodes.ProductContainer | null>;
	    readonly quantityOfConsumptionUnitPerLevel: Promise<decimal | null>;
	}
	//# sourceMappingURL=receipt-movement-addressed-container-levels.d.ts.map
}
// From file: @sage/wh-input/build/lib/nodes/index.d.ts
declare module '@sage/wh-input/lib/nodes/index' {
	export * from '@sage/wh-input/lib/nodes/administrative-receipt-line-in-progress';
	export * from '@sage/wh-input/lib/nodes/administrative-receipt-line-validated';
	export * from '@sage/wh-input/lib/nodes/administrative-receipt-movement-in-progress';
	export * from '@sage/wh-input/lib/nodes/administrative-receipt-movement-validated';
	export * from '@sage/wh-input/lib/nodes/administrative-receipt';
	export * from '@sage/wh-input/lib/nodes/direct-input-addresses';
	export * from '@sage/wh-input/lib/nodes/direct-input-line';
	export * from '@sage/wh-input/lib/nodes/direct-input-supplier-names';
	export * from '@sage/wh-input/lib/nodes/direct-input';
	export * from '@sage/wh-input/lib/nodes/expected-input-addresses';
	export * from '@sage/wh-input/lib/nodes/expected-input-line';
	export * from '@sage/wh-input/lib/nodes/expected-input-supplier-names';
	export * from '@sage/wh-input/lib/nodes/expected-input';
	export * from '@sage/wh-input/lib/nodes/receipt-movement-addressed-container-levels';
	export * from '@sage/wh-input/lib/nodes/receipt-movement-addressed';
	export * from '@sage/wh-input/lib/nodes/receipt-movement-closed-container-levels';
	export * from '@sage/wh-input/lib/nodes/receipt-movement-closed';
	export * from '@sage/wh-input/lib/nodes/receipt-movement-in-progress-container-levels';
	export * from '@sage/wh-input/lib/nodes/receipt-movement-in-progress';
	export * from '@sage/wh-input/lib/nodes/storing-list';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/wh-input/build/lib/nodes/expected-input.d.ts
declare module '@sage/wh-input/lib/nodes/expected-input' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhProductData from '@sage/wh-product-data';
	import * as sageWhStructure from '@sage/wh-structure';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, date, Collection } from '@sage/xtrem-core';
	import * as sageWhInput from '@sage/wh-input/lib/index';
	export class ExpectedInput extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly code: Promise<string>;
	    readonly date: Promise<date>;
	    readonly time: Promise<string>;
	    readonly receiptMode: Reference<sageWhProductData.nodes.ReceiptMode>;
	    readonly movementCode: Reference<sageWhMasterData.nodes.MovementCode>;
	    readonly referenceNumber: Promise<string>;
	    readonly carrierAppointment: Reference<sageWhMasterData.nodes.AppointmentManagement | null>;
	    readonly appointmentDate: Promise<date>;
	    readonly appointmentTime: Promise<string>;
	    readonly supplier: Reference<sageWhMasterData.nodes.Supplier | null>;
	    readonly postalCode: Promise<string>;
	    readonly countryCode: Reference<sageWhStructure.nodes.Country | null>;
	    readonly countryName: Promise<string>;
	    readonly city: Promise<string>;
	    readonly region: Promise<string>;
	    readonly telephone: Promise<string>;
	    readonly fax: Promise<string>;
	    readonly carrier: Reference<sageWhMasterData.nodes.Carrier | null>;
	    readonly carrierName: Promise<string>;
	    readonly carriageReference: Promise<string>;
	    readonly transportationMethod: Reference<sageWhMasterData.nodes.TransportMode | null>;
	    readonly status: Promise<sageWhProductData.enums.ExpectedInputStatus>;
	    readonly lastReceipt: Reference<sageWhInput.nodes.AdministrativeReceipt | null>;
	    readonly previousReceipt: Reference<sageWhInput.nodes.AdministrativeReceipt | null>;
	    readonly transmittedFromL3: Promise<sageWhProductData.enums.TransmissionL3 | null>;
	    readonly isQualityControlManagement: Promise<boolean>;
	    readonly orderNumber: Promise<string>;
	    readonly orderReference: Promise<string>;
	    readonly lines: Collection<sageWhInput.nodes.ExpectedInputLine>;
	    readonly addresses: Collection<sageWhInput.nodes.ExpectedInputAddresses>;
	    readonly supplierNames: Collection<sageWhInput.nodes.ExpectedInputSupplierNames>;
	}
	//# sourceMappingURL=expected-input.d.ts.map
}
// From file: @sage/wh-input/build/lib/nodes/expected-input-supplier-names.d.ts
declare module '@sage/wh-input/lib/nodes/expected-input-supplier-names' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhInput from '@sage/wh-input/lib/index';
	export class ExpectedInputSupplierNames extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly depositor: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhInput.nodes.ExpectedInput>;
	    readonly supplierName: Promise<string>;
	}
	//# sourceMappingURL=expected-input-supplier-names.d.ts.map
}
// From file: @sage/wh-input/build/lib/nodes/expected-input-line.d.ts
declare module '@sage/wh-input/lib/nodes/expected-input-line' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhProductData from '@sage/wh-product-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, integer, date, decimal } from '@sage/xtrem-core';
	import * as sageWhInput from '@sage/wh-input/lib/index';
	export class ExpectedInputLine extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly expectedInput: Reference<sageWhInput.nodes.ExpectedInput>;
	    readonly lineNumber: Promise<integer>;
	    readonly referenceNumber: Promise<string>;
	    readonly product: Reference<sageWhProductData.nodes.Product>;
	    readonly inputContainer: Reference<sageWhProductData.nodes.ProductContainer>;
	    readonly supportNumber: Promise<string>;
	    readonly reservationNumber: Promise<string>;
	    readonly lotNumber: Promise<string>;
	    readonly movementCode: Reference<sageWhMasterData.nodes.MovementCode>;
	    readonly source: Reference<sageWhProductData.nodes.Origin | null>;
	    readonly stockStatus: Reference<sageWhMasterData.nodes.StockNature | null>;
	    readonly store: Reference<sageWhMasterData.nodes.Store | null>;
	    readonly isExclusiveStore: Promise<boolean>;
	    readonly multipleProducts: Promise<string>;
	    readonly isCustomerReturn: Promise<boolean>;
	    readonly receiptDate: Promise<date>;
	    readonly manufacturedDate: Promise<date | null>;
	    readonly detentionDate: Promise<date | null>;
	    readonly sellByDate: Promise<date | null>;
	    readonly useByDate: Promise<date | null>;
	    readonly shipByDate: Promise<date | null>;
	    readonly fifoDate: Promise<date | null>;
	    readonly status: Promise<sageWhProductData.enums.ExpectedInputLineStatus>;
	    readonly expectedQuantityInConsumptionUnit: Promise<decimal>;
	    readonly remainingQuantityInConsumptionUnit: Promise<decimal | null>;
	    readonly receivedQuantityInConsumptionUnit: Promise<decimal | null>;
	    readonly disputedQuantityInConsumptionUnit: Promise<decimal | null>;
	}
	//# sourceMappingURL=expected-input-line.d.ts.map
}
// From file: @sage/wh-input/build/lib/nodes/expected-input-addresses.d.ts
declare module '@sage/wh-input/lib/nodes/expected-input-addresses' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhInput from '@sage/wh-input/lib/index';
	export class ExpectedInputAddresses extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly depositor: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhInput.nodes.ExpectedInput>;
	    readonly address: Promise<string>;
	}
	//# sourceMappingURL=expected-input-addresses.d.ts.map
}
// From file: @sage/wh-input/build/lib/nodes/direct-input.d.ts
declare module '@sage/wh-input/lib/nodes/direct-input' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhProductData from '@sage/wh-product-data';
	import * as sageWhStructure from '@sage/wh-structure';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, date, Collection } from '@sage/xtrem-core';
	import * as sageWhInput from '@sage/wh-input/lib/index';
	export class DirectInput extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly code: Promise<string>;
	    readonly movementCode: Reference<sageWhMasterData.nodes.MovementCode>;
	    readonly referenceNumber: Promise<string>;
	    readonly date: Promise<date>;
	    readonly supplier: Reference<sageWhMasterData.nodes.Supplier | null>;
	    readonly postalCode: Promise<string>;
	    readonly country: Reference<sageWhStructure.nodes.Country | null>;
	    readonly countryName: Promise<string>;
	    readonly city: Promise<string>;
	    readonly region: Promise<string>;
	    readonly telephone: Promise<string>;
	    readonly fax: Promise<string>;
	    readonly carrier: Reference<sageWhMasterData.nodes.Carrier | null>;
	    readonly carrierName: Promise<string>;
	    readonly carriageReference: Promise<string>;
	    readonly transportationMethod: Reference<sageWhMasterData.nodes.TransportMode | null>;
	    readonly status: Promise<sageWhProductData.enums.InputHeaderStatus>;
	    readonly expectedInputNumber: Promise<string>;
	    readonly receipt: Reference<sageWhInput.nodes.AdministrativeReceipt | null>;
	    readonly receiptDate: Promise<date | null>;
	    readonly transmittedFromL3: Promise<sageWhProductData.enums.TransmissionL3 | null>;
	    readonly isControlled: Promise<boolean>;
	    readonly isCrossDocking: Promise<boolean>;
	    readonly lines: Collection<sageWhInput.nodes.DirectInputLine>;
	    readonly addresses: Collection<sageWhInput.nodes.DirectInputAddresses>;
	    readonly supplierNames: Collection<sageWhInput.nodes.DirectInputSupplierNames>;
	}
	//# sourceMappingURL=direct-input.d.ts.map
}
// From file: @sage/wh-input/build/lib/nodes/direct-input-supplier-names.d.ts
declare module '@sage/wh-input/lib/nodes/direct-input-supplier-names' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhInput from '@sage/wh-input/lib/index';
	export class DirectInputSupplierNames extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly depositor: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhInput.nodes.DirectInput>;
	    readonly supplierName: Promise<string>;
	}
	//# sourceMappingURL=direct-input-supplier-names.d.ts.map
}
// From file: @sage/wh-input/build/lib/nodes/direct-input-line.d.ts
declare module '@sage/wh-input/lib/nodes/direct-input-line' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhProductData from '@sage/wh-product-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, integer, decimal, date, Collection } from '@sage/xtrem-core';
	import * as sageWhInput from '@sage/wh-input/lib/index';
	export class DirectInputLine extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly directInput: Reference<sageWhInput.nodes.DirectInput>;
	    readonly lineNumber: Promise<integer>;
	    readonly linePointerNumber: Promise<integer | null>;
	    readonly referenceNumber: Promise<string>;
	    readonly product: Reference<sageWhProductData.nodes.Product>;
	    readonly multipleProduct: Promise<string>;
	    readonly numberOfConsumptionUnit: Promise<decimal>;
	    readonly numberOfContainers: Promise<decimal>;
	    readonly container: Reference<sageWhProductData.nodes.ProductContainer>;
	    readonly inputContainer: Reference<sageWhProductData.nodes.ProductContainer>;
	    readonly movementCode: Reference<sageWhMasterData.nodes.MovementCode>;
	    readonly supportNumber: Promise<string>;
	    readonly reservationNumber: Promise<string>;
	    readonly lotNumber: Promise<string>;
	    readonly stockStatus: Reference<sageWhMasterData.nodes.StockNature | null>;
	    readonly fifoDate: Promise<date>;
	    readonly receiptDate: Promise<date | null>;
	    readonly manufacturedDate: Promise<date | null>;
	    readonly detentionDate: Promise<date | null>;
	    readonly sellByDate: Promise<date | null>;
	    readonly useByDate: Promise<date | null>;
	    readonly shipByDate: Promise<date | null>;
	    readonly status: Promise<sageWhProductData.enums.InputLineStatus>;
	    readonly numberOfConsumptionUnitStored: Promise<decimal | null>;
	    readonly receipt: Reference<sageWhInput.nodes.AdministrativeReceipt | null>;
	    readonly receiptLineNumber: Promise<integer | null>;
	    readonly expectedInputLineNumber: Promise<integer | null>;
	    readonly inputLineType: Promise<string>;
	    readonly imposedStore: Reference<sageWhMasterData.nodes.Store | null>;
	    readonly isExclusiveStore: Promise<boolean>;
	    readonly isKeyInSerialNumber: Promise<boolean>;
	    readonly source: Reference<sageWhProductData.nodes.Origin | null>;
	    readonly isCustomerReturn: Promise<boolean>;
	    readonly addressedReceiptMovements: Collection<sageWhInput.nodes.ReceiptMovementAddressed>;
	    readonly closedReceiptMovements: Collection<sageWhInput.nodes.ReceiptMovementClosed>;
	    readonly inProgressReceiptMovements: Collection<sageWhInput.nodes.ReceiptMovementInProgress>;
	    readonly numberOfConsumptionUnitRemaining: Promise<decimal | null>;
	}
	//# sourceMappingURL=direct-input-line.d.ts.map
}
// From file: @sage/wh-input/build/lib/nodes/direct-input-addresses.d.ts
declare module '@sage/wh-input/lib/nodes/direct-input-addresses' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhInput from '@sage/wh-input/lib/index';
	export class DirectInputAddresses extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly depositor: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhInput.nodes.DirectInput>;
	    readonly address: Promise<string>;
	}
	//# sourceMappingURL=direct-input-addresses.d.ts.map
}
// From file: @sage/wh-input/build/lib/nodes/administrative-receipt.d.ts
declare module '@sage/wh-input/lib/nodes/administrative-receipt' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhProductData from '@sage/wh-product-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, date, integer, decimal, Collection, Context } from '@sage/xtrem-core';
	import * as sageWhInput from '@sage/wh-input/lib/index';
	export class AdministrativeReceipt extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly code: Promise<string>;
	    readonly carrierAppointment: Reference<sageWhMasterData.nodes.AppointmentManagement | null>;
	    readonly carrier: Reference<sageWhMasterData.nodes.Carrier | null>;
	    readonly carrierName: Promise<string>;
	    readonly carriageReference: Promise<string>;
	    readonly transportationMethod: Reference<sageWhMasterData.nodes.TransportMode | null>;
	    readonly store: Reference<sageWhMasterData.nodes.Store | null>;
	    readonly dock: Reference<sageWhMasterData.nodes.Location | null>;
	    readonly date: Promise<date>;
	    readonly time: Promise<string>;
	    readonly numberOfLoads: Promise<integer | null>;
	    readonly grossWeight: Promise<decimal | null>;
	    readonly status: Promise<sageWhProductData.enums.ReceiptStatus>;
	    readonly duration: Promise<string>;
	    readonly inProgressLines: Collection<sageWhInput.nodes.AdministrativeReceiptLineInProgress>;
	    readonly validatedLines: Collection<sageWhInput.nodes.AdministrativeReceiptLineValidated>;
	    readonly operatorCode: Promise<string>;
	    static validateReceipt(context: Context, parameter: AdministrativeReceipt): Promise<AdministrativeReceipt>;
	}
	//# sourceMappingURL=administrative-receipt.d.ts.map
}
// From file: @sage/wh-input/build/lib/nodes/administrative-receipt-movement-validated.d.ts
declare module '@sage/wh-input/lib/nodes/administrative-receipt-movement-validated' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhProductData from '@sage/wh-product-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, integer, decimal } from '@sage/xtrem-core';
	import * as sageWhInput from '@sage/wh-input/lib/index';
	export class AdministrativeReceiptMovementValidated extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly receipt: Reference<sageWhInput.nodes.AdministrativeReceipt>;
	    readonly lineNumber: Promise<integer | null>;
	    readonly receiptMovementNumber: Promise<integer>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly product: Reference<sageWhProductData.nodes.Product>;
	    readonly numberOfContainers: Promise<decimal>;
	    readonly container: Reference<sageWhProductData.nodes.ProductContainer>;
	    readonly numberOfConsumptionUnit: Promise<decimal>;
	    readonly homogeneousQuantity: Promise<decimal>;
	    readonly homogeneousContainer: Reference<sageWhProductData.nodes.ProductContainer>;
	    readonly receiptLine: Reference<sageWhInput.nodes.AdministrativeReceiptLineValidated>;
	}
	//# sourceMappingURL=administrative-receipt-movement-validated.d.ts.map
}
// From file: @sage/wh-input/build/lib/nodes/administrative-receipt-movement-in-progress.d.ts
declare module '@sage/wh-input/lib/nodes/administrative-receipt-movement-in-progress' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhProductData from '@sage/wh-product-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, integer, decimal } from '@sage/xtrem-core';
	import * as sageWhInput from '@sage/wh-input/lib/index';
	export class AdministrativeReceiptMovementInProgress extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly receipt: Reference<sageWhInput.nodes.AdministrativeReceipt>;
	    readonly lineNumber: Promise<integer | null>;
	    readonly receiptMovementNumber: Promise<integer>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly product: Reference<sageWhProductData.nodes.Product>;
	    readonly numberOfContainers: Promise<decimal>;
	    readonly container: Reference<sageWhProductData.nodes.ProductContainer>;
	    readonly numberOfConsumptionUnit: Promise<decimal>;
	    readonly homogeneousQuantity: Promise<decimal>;
	    readonly homogeneousContainer: Reference<sageWhProductData.nodes.ProductContainer>;
	    readonly receiptLine: Reference<sageWhInput.nodes.AdministrativeReceiptLineInProgress>;
	}
	//# sourceMappingURL=administrative-receipt-movement-in-progress.d.ts.map
}
// From file: @sage/wh-input/build/lib/nodes/administrative-receipt-line-validated.d.ts
declare module '@sage/wh-input/lib/nodes/administrative-receipt-line-validated' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhProductData from '@sage/wh-product-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, integer, decimal, date, Collection } from '@sage/xtrem-core';
	import * as sageWhInput from '@sage/wh-input/lib/index';
	export class AdministrativeReceiptLineValidated extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly receipt: Reference<sageWhInput.nodes.AdministrativeReceipt>;
	    readonly expectedInput: Reference<sageWhInput.nodes.ExpectedInput>;
	    readonly expectedInputLine: Reference<sageWhInput.nodes.ExpectedInputLine>;
	    readonly splitLineNumber: Promise<integer | null>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly lineNumber: Promise<integer | null>;
	    readonly status: Promise<sageWhProductData.enums.ReceiptLineStatus | null>;
	    readonly product: Reference<sageWhProductData.nodes.Product>;
	    readonly receivedQuantityInConsumptionUnit: Promise<decimal>;
	    readonly inputContainer: Reference<sageWhProductData.nodes.ProductContainer>;
	    readonly lotNumber: Promise<string>;
	    readonly supportNumber: Promise<string>;
	    readonly reservationNumber: Promise<string>;
	    readonly stockStatus: Reference<sageWhMasterData.nodes.StockNature | null>;
	    readonly store: Reference<sageWhMasterData.nodes.Store | null>;
	    readonly isExclusiveStore: Promise<boolean>;
	    readonly isDispute: Promise<boolean>;
	    readonly isPutaway: Promise<boolean>;
	    readonly source: Reference<sageWhProductData.nodes.Origin | null>;
	    readonly manufacturedDate: Promise<date | null>;
	    readonly detentionDate: Promise<date | null>;
	    readonly sellByDate: Promise<date | null>;
	    readonly useByDate: Promise<date | null>;
	    readonly shipByDate: Promise<date | null>;
	    readonly fifoDate: Promise<date>;
	    readonly administrativeReceiptMovements: Collection<sageWhInput.nodes.AdministrativeReceiptMovementValidated>;
	}
	//# sourceMappingURL=administrative-receipt-line-validated.d.ts.map
}
// From file: @sage/wh-input/build/lib/nodes/administrative-receipt-line-in-progress.d.ts
declare module '@sage/wh-input/lib/nodes/administrative-receipt-line-in-progress' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhProductData from '@sage/wh-product-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, integer, decimal, date, Collection } from '@sage/xtrem-core';
	import * as sageWhInput from '@sage/wh-input/lib/index';
	export class AdministrativeReceiptLineInProgress extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly receipt: Reference<sageWhInput.nodes.AdministrativeReceipt>;
	    readonly expectedInput: Reference<sageWhInput.nodes.ExpectedInput>;
	    readonly expectedInputLine: Reference<sageWhInput.nodes.ExpectedInputLine>;
	    readonly splitLineNumber: Promise<integer | null>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly lineNumber: Promise<integer | null>;
	    readonly status: Promise<sageWhProductData.enums.ReceiptLineStatus | null>;
	    readonly product: Reference<sageWhProductData.nodes.Product>;
	    readonly receivedQuantityInConsumptionUnit: Promise<decimal>;
	    readonly inputContainer: Reference<sageWhProductData.nodes.ProductContainer>;
	    readonly lotNumber: Promise<string>;
	    readonly supportNumber: Promise<string>;
	    readonly reservationNumber: Promise<string>;
	    readonly stockStatus: Reference<sageWhMasterData.nodes.StockNature | null>;
	    readonly store: Reference<sageWhMasterData.nodes.Store | null>;
	    readonly isExclusiveStore: Promise<boolean>;
	    readonly isDispute: Promise<boolean>;
	    readonly isPutaway: Promise<boolean>;
	    readonly source: Reference<sageWhProductData.nodes.Origin | null>;
	    readonly manufacturedDate: Promise<date | null>;
	    readonly detentionDate: Promise<date | null>;
	    readonly sellByDate: Promise<date | null>;
	    readonly useByDate: Promise<date | null>;
	    readonly shipByDate: Promise<date | null>;
	    readonly fifoDate: Promise<date>;
	    readonly administrativeReceiptMovements: Collection<sageWhInput.nodes.AdministrativeReceiptMovementInProgress>;
	    readonly actionImport: Promise<string>;
	}
	//# sourceMappingURL=administrative-receipt-line-in-progress.d.ts.map
}
// From file: @sage/wh-input/build/lib/node-extensions/stock-object-extension.d.ts
declare module '@sage/wh-input/lib/node-extensions/stock-object-extension' {
	import * as sageWhStockData from '@sage/wh-stock-data';
	import { NodeExtension, Reference } from '@sage/xtrem-core';
	import * as sageWhInput from '@sage/wh-input/lib/index';
	export class StockObjectExtension extends NodeExtension<sageWhStockData.nodes.StockObject> {
	    readonly directInput: Reference<sageWhInput.nodes.DirectInput | null>;
	}
	declare module '@sage/wh-stock-data/lib/nodes/stock-object' {
	    interface StockObject extends StockObjectExtension {
	    }
	}
	//# sourceMappingURL=stock-object-extension.d.ts.map
}
// From file: @sage/wh-input/build/lib/node-extensions/serial-number-extension.d.ts
declare module '@sage/wh-input/lib/node-extensions/serial-number-extension' {
	import * as sageWhStockData from '@sage/wh-stock-data';
	import { NodeExtension, Reference } from '@sage/xtrem-core';
	import * as sageWhInput from '@sage/wh-input/lib/index';
	export class SerialNumberExtension extends NodeExtension<sageWhStockData.nodes.SerialNumber> {
	    readonly directInput: Reference<sageWhInput.nodes.DirectInput | null>;
	    readonly inputMovement: Reference<sageWhInput.nodes.ReceiptMovementAddressed | null>;
	}
	declare module '@sage/wh-stock-data/lib/nodes/serial-number' {
	    interface SerialNumber extends SerialNumberExtension {
	    }
	}
	//# sourceMappingURL=serial-number-extension.d.ts.map
}
// From file: @sage/wh-input/build/lib/node-extensions/index.d.ts
declare module '@sage/wh-input/lib/node-extensions/index' {
	export * from '@sage/wh-input/lib/node-extensions/serial-number-extension';
	export * from '@sage/wh-input/lib/node-extensions/stock-object-extension';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/wh-input/build/lib/enums/index.d.ts
declare module '@sage/wh-input/lib/enums/index' {
	export type Dummy = void;
	//# sourceMappingURL=index.d.ts.map
}
declare module '@sage/wh-input' {
	export * from '@sage/wh-input/index';
}
