"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StoringList = void 0;
const sageWhMasterData = require("@sage/wh-master-data");
const sageWhProductData = require("@sage/wh-product-data");
const sageWhSystem = require("@sage/wh-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageWhInput = require("..");
const joins = {
    referenceJoins: {
        site: {
            code: 'site',
        },
        depositor: {
            site: 'site',
            code: 'depositor',
        },
        store: {
            site: 'site',
            code: 'store',
        },
        directInput: {
            site: 'site',
            depositor: 'depositor',
            code: 'directInput',
        },
        validatingOperator: {
            site: 'site',
            code: 'validatingOperator',
        },
    },
    collectionJoins: {
        addressedReceiptMovements: {
            site: 'site',
            depositor: 'depositor',
            storingList: 'code',
        },
        closedReceiptMovements: {
            site: 'site',
            depositor: 'depositor',
            storingList: 'code',
        },
    },
};
let StoringList = class StoringList extends xtrem_core_1.Node {
    static putaway(context, parameter) {
        return xtrem_x3_gateway_1.X3StorageManager.executeApiOperation(context, 'IMPORT', 'StoringList', 'putaway', parameter);
    }
};
exports.StoringList = StoringList;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FCY',
        columnType: 'string',
        node: () => sageWhSystem.nodes.Site,
        lookupAccess: true,
    })
], StoringList.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DEP',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Depositor,
        lookupAccess: true,
    })
], StoringList.prototype, "depositor", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'STLNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], StoringList.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STLSTA',
        dataType: () => sageWhProductData.enums.storingListPurchaseOrderStatusDatatype,
        lookupAccess: true,
    })
], StoringList.prototype, "status", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        lookupAccess: true,
    })
], StoringList.prototype, "date", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STLSTO',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Store,
        lookupAccess: true,
    })
], StoringList.prototype, "store", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STLINP',
        columnType: 'string',
        node: () => sageWhInput.nodes.DirectInput,
        lookupAccess: true,
    })
], StoringList.prototype, "directInput", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'IDENT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], StoringList.prototype, "identifier", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STLSRT',
        dataType: () => sageWhMasterData.enums.printingSequenceDatatype,
        lookupAccess: true,
    })
], StoringList.prototype, "order", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STLVLD',
        dataType: () => sageWhMasterData.enums.validationTypeDatatype,
        lookupAccess: true,
    })
], StoringList.prototype, "validationType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VLDOPE',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Operand,
        lookupAccess: true,
    })
], StoringList.prototype, "validatingOperator", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'VLDUSR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], StoringList.prototype, "validatingUser", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VLDDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        lookupAccess: true,
    })
], StoringList.prototype, "postingDate", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageWhInput.nodes.ReceiptMovementAddressed,
        isMutable: true,
        dependsOn: ['site', 'depositor', 'code'],
        lookupAccess: true,
    })
], StoringList.prototype, "addressedReceiptMovements", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageWhInput.nodes.ReceiptMovementClosed,
        dependsOn: ['site', 'depositor', 'code'],
        lookupAccess: true,
    })
], StoringList.prototype, "closedReceiptMovements", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isTransientInput: true,
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StoringList.prototype, "operatorCode", void 0);
__decorate([
    xtrem_core_1.decorators.mutation({
        isPublished: true,
        parameters: [{ name: 'parameter', type: 'instance', isTransientInput: true, node: () => StoringList }],
        return: { type: 'instance', node: () => StoringList },
    })
], StoringList, "putaway", null);
exports.StoringList = StoringList = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'STORINGLST',
        keyPropertyNames: ['site', 'depositor', 'code'],
        indexes: [
            {
                orderBy: {
                    site: 1,
                    depositor: 1,
                    code: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        getFilters() {
            return [{ status: { _ne: 'beingCreated' } }];
        },
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], StoringList);
//# sourceMappingURL=storing-list.js.map