import * as sageWhMasterData from '@sage/wh-master-data';
import * as sageWhProductData from '@sage/wh-product-data';
import * as sageWhSystem from '@sage/wh-system';
import { Node, Reference, date, Collection, Context } from '@sage/xtrem-core';
import * as sageWhInput from '..';
export declare class StoringList extends Node {
    readonly site: Reference<sageWhSystem.nodes.Site>;
    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
    readonly code: Promise<string>;
    readonly status: Promise<sageWhProductData.enums.StoringListPurchaseOrderStatus>;
    readonly date: Promise<date>;
    readonly store: Reference<sageWhMasterData.nodes.Store | null>;
    readonly directInput: Reference<sageWhInput.nodes.DirectInput | null>;
    readonly identifier: Promise<string>;
    readonly order: Promise<sageWhMasterData.enums.PrintingSequence | null>;
    readonly validationType: Promise<sageWhMasterData.enums.ValidationType | null>;
    readonly validatingOperator: Reference<sageWhMasterData.nodes.Operand | null>;
    readonly validatingUser: Promise<string>;
    readonly postingDate: Promise<date | null>;
    readonly addressedReceiptMovements: Collection<sageWhInput.nodes.ReceiptMovementAddressed>;
    readonly closedReceiptMovements: Collection<sageWhInput.nodes.ReceiptMovementClosed>;
    readonly operatorCode: Promise<string>;
    static putaway(context: Context, parameter: StoringList): Promise<StoringList>;
}
//# sourceMappingURL=storing-list.d.ts.map