"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReceiptMovementInProgressContainerLevels = void 0;
const sageWhProductData = require("@sage/wh-product-data");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageWhInput = require("..");
const denormalized = {
    maxRepeat: (context) => sageXtremX3SystemUtils.getSizingFromActivityCode(context, 'CTR'),
};
const joins = {
    referenceJoins: {
        _denormalizedParent: {
            site: 'site',
            depositor: 'depositor',
            directInput: 'directInput',
            directInputLine: 'directInputLine',
            code: 'code',
        },
        containerLevel: {
            site: 'site',
            depositor: 'depositor',
            product: 'product',
            container: 'containerLevel',
        },
    },
};
let ReceiptMovementInProgressContainerLevels = class ReceiptMovementInProgressContainerLevels extends xtrem_core_1.Node {
};
exports.ReceiptMovementInProgressContainerLevels = ReceiptMovementInProgressContainerLevels;
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        lookupAccess: true,
    })
], ReceiptMovementInProgressContainerLevels.prototype, "denormalizedIndex", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'FCY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], ReceiptMovementInProgressContainerLevels.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'DEP',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], ReceiptMovementInProgressContainerLevels.prototype, "depositor", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'INPNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], ReceiptMovementInProgressContainerLevels.prototype, "directInput", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INPLIN',
        lookupAccess: true,
    })
], ReceiptMovementInProgressContainerLevels.prototype, "directInputLine", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'MVTNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], ReceiptMovementInProgressContainerLevels.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isVitalParent: true,
        columnType: 'string',
        node: () => sageWhInput.nodes.ReceiptMovementInProgress,
    })
], ReceiptMovementInProgressContainerLevels.prototype, "_denormalizedParent", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CTRLVL',
        columnType: 'string',
        node: () => sageWhProductData.nodes.ProductContainer,
        lookupAccess: true,
    })
], ReceiptMovementInProgressContainerLevels.prototype, "containerLevel", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CUQLVL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], ReceiptMovementInProgressContainerLevels.prototype, "quantityOfConsumptionUnitPerLevel", void 0);
exports.ReceiptMovementInProgressContainerLevels = ReceiptMovementInProgressContainerLevels = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'INPUTM',
        keyPropertyNames: ['denormalizedIndex', 'site', 'depositor', 'directInput', 'directInputLine', 'code'],
        indexes: [],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            isDenormalized: true,
            denormalized,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
        isVitalCollectionChild: true,
    })
], ReceiptMovementInProgressContainerLevels);
//# sourceMappingURL=receipt-movement-in-progress-container-levels.js.map