import * as sageWhMasterData from '@sage/wh-master-data';
import * as sageWhProductData from '@sage/wh-product-data';
import * as sageWhStockData from '@sage/wh-stock-data';
import * as sageWhSystem from '@sage/wh-system';
import { Node, Reference, decimal, date, integer, Collection } from '@sage/xtrem-core';
import * as sageWhInput from '..';
export declare class ReceiptMovementAddressed extends Node {
    readonly site: Reference<sageWhSystem.nodes.Site>;
    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
    readonly directInput: Reference<sageWhInput.nodes.DirectInput>;
    readonly directInputLine: Reference<sageWhInput.nodes.DirectInputLine>;
    readonly code: Promise<string>;
    readonly store: Reference<sageWhMasterData.nodes.Store | null>;
    readonly imposedStore: Reference<sageWhMasterData.nodes.Store | null>;
    readonly isExclusiveStore: Promise<boolean>;
    readonly location: Reference<sageWhMasterData.nodes.Location | null>;
    readonly locationType: Promise<sageWhMasterData.enums.LocationType | null>;
    readonly stockObject: Reference<sageWhStockData.nodes.StockObject | null>;
    readonly containerNumber: Promise<string>;
    readonly product: Reference<sageWhProductData.nodes.Product>;
    readonly stockStatus: Reference<sageWhMasterData.nodes.StockNature | null>;
    readonly source: Reference<sageWhProductData.nodes.Origin | null>;
    readonly lotNumber: Promise<string>;
    readonly reservationNumber: Promise<string>;
    readonly supportNumber: Promise<string>;
    readonly numberOfContainers: Promise<decimal>;
    readonly container: Reference<sageWhProductData.nodes.ProductContainer>;
    readonly quantityInConsumptionUnit: Promise<decimal>;
    readonly level: Promise<sageWhMasterData.enums.ContainerLevel>;
    readonly homogeneousQuantity: Promise<decimal>;
    readonly homogeneousContainer: Reference<sageWhProductData.nodes.ProductContainer>;
    readonly homogeneousContainerCoefficient: Promise<decimal>;
    readonly movementCode: Reference<sageWhMasterData.nodes.MovementCode>;
    readonly status: Promise<sageWhProductData.enums.InputMovementStatus>;
    readonly fifoDate: Promise<date>;
    readonly receiptDate: Promise<date | null>;
    readonly manufacturedDate: Promise<date | null>;
    readonly detentionDate: Promise<date | null>;
    readonly sellByDate: Promise<date | null>;
    readonly useByDate: Promise<date | null>;
    readonly shipByDate: Promise<date | null>;
    readonly storingList: Reference<sageWhInput.nodes.StoringList | null>;
    readonly storingListLineNumber: Promise<integer | null>;
    readonly movementType: Promise<sageWhProductData.enums.MovementType | null>;
    readonly serialNumbers: Collection<sageWhStockData.nodes.SerialNumber>;
    readonly controlCode: Promise<string>;
    readonly containerLevels: Collection<sageWhInput.nodes.ReceiptMovementAddressedContainerLevels>;
}
//# sourceMappingURL=receipt-movement-addressed.d.ts.map