import * as sageWhMasterData from '@sage/wh-master-data';
import * as sageWhProductData from '@sage/wh-product-data';
import * as sageWhStructure from '@sage/wh-structure';
import * as sageWhSystem from '@sage/wh-system';
import { Node, Reference, date, Collection } from '@sage/xtrem-core';
import * as sageWhInput from '..';
export declare class ExpectedInput extends Node {
    readonly site: Reference<sageWhSystem.nodes.Site>;
    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
    readonly code: Promise<string>;
    readonly date: Promise<date>;
    readonly time: Promise<string>;
    readonly receiptMode: Reference<sageWhProductData.nodes.ReceiptMode>;
    readonly movementCode: Reference<sageWhMasterData.nodes.MovementCode>;
    readonly referenceNumber: Promise<string>;
    readonly carrierAppointment: Reference<sageWhMasterData.nodes.AppointmentManagement | null>;
    readonly appointmentDate: Promise<date>;
    readonly appointmentTime: Promise<string>;
    readonly supplier: Reference<sageWhMasterData.nodes.Supplier | null>;
    readonly postalCode: Promise<string>;
    readonly countryCode: Reference<sageWhStructure.nodes.Country | null>;
    readonly countryName: Promise<string>;
    readonly city: Promise<string>;
    readonly region: Promise<string>;
    readonly telephone: Promise<string>;
    readonly fax: Promise<string>;
    readonly carrier: Reference<sageWhMasterData.nodes.Carrier | null>;
    readonly carrierName: Promise<string>;
    readonly carriageReference: Promise<string>;
    readonly transportationMethod: Reference<sageWhMasterData.nodes.TransportMode | null>;
    readonly status: Promise<sageWhProductData.enums.ExpectedInputStatus>;
    readonly lastReceipt: Reference<sageWhInput.nodes.AdministrativeReceipt | null>;
    readonly previousReceipt: Reference<sageWhInput.nodes.AdministrativeReceipt | null>;
    readonly transmittedFromL3: Promise<sageWhProductData.enums.TransmissionL3 | null>;
    readonly isQualityControlManagement: Promise<boolean>;
    readonly orderNumber: Promise<string>;
    readonly orderReference: Promise<string>;
    readonly lines: Collection<sageWhInput.nodes.ExpectedInputLine>;
    readonly addresses: Collection<sageWhInput.nodes.ExpectedInputAddresses>;
    readonly supplierNames: Collection<sageWhInput.nodes.ExpectedInputSupplierNames>;
}
//# sourceMappingURL=expected-input.d.ts.map