import * as sageWhMasterData from '@sage/wh-master-data';
import * as sageWhProductData from '@sage/wh-product-data';
import * as sageWhSystem from '@sage/wh-system';
import { Node, Reference, integer, date, decimal } from '@sage/xtrem-core';
import * as sageWhInput from '..';
export declare class ExpectedInputLine extends Node {
    readonly site: Reference<sageWhSystem.nodes.Site>;
    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
    readonly expectedInput: Reference<sageWhInput.nodes.ExpectedInput>;
    readonly lineNumber: Promise<integer>;
    readonly referenceNumber: Promise<string>;
    readonly product: Reference<sageWhProductData.nodes.Product>;
    readonly inputContainer: Reference<sageWhProductData.nodes.ProductContainer>;
    readonly supportNumber: Promise<string>;
    readonly reservationNumber: Promise<string>;
    readonly lotNumber: Promise<string>;
    readonly movementCode: Reference<sageWhMasterData.nodes.MovementCode>;
    readonly source: Reference<sageWhProductData.nodes.Origin | null>;
    readonly stockStatus: Reference<sageWhMasterData.nodes.StockNature | null>;
    readonly store: Reference<sageWhMasterData.nodes.Store | null>;
    readonly isExclusiveStore: Promise<boolean>;
    readonly multipleProducts: Promise<string>;
    readonly isCustomerReturn: Promise<boolean>;
    readonly receiptDate: Promise<date>;
    readonly manufacturedDate: Promise<date | null>;
    readonly detentionDate: Promise<date | null>;
    readonly sellByDate: Promise<date | null>;
    readonly useByDate: Promise<date | null>;
    readonly shipByDate: Promise<date | null>;
    readonly fifoDate: Promise<date | null>;
    readonly status: Promise<sageWhProductData.enums.ExpectedInputLineStatus>;
    readonly expectedQuantityInConsumptionUnit: Promise<decimal>;
    readonly remainingQuantityInConsumptionUnit: Promise<decimal | null>;
    readonly receivedQuantityInConsumptionUnit: Promise<decimal | null>;
    readonly disputedQuantityInConsumptionUnit: Promise<decimal | null>;
}
//# sourceMappingURL=expected-input-line.d.ts.map