import * as sageWhMasterData from '@sage/wh-master-data';
import * as sageWhProductData from '@sage/wh-product-data';
import * as sageWhStructure from '@sage/wh-structure';
import * as sageWhSystem from '@sage/wh-system';
import { Node, Reference, date, Collection } from '@sage/xtrem-core';
import * as sageWhInput from '..';
export declare class DirectInput extends Node {
    readonly site: Reference<sageWhSystem.nodes.Site>;
    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
    readonly code: Promise<string>;
    readonly movementCode: Reference<sageWhMasterData.nodes.MovementCode>;
    readonly referenceNumber: Promise<string>;
    readonly date: Promise<date>;
    readonly supplier: Reference<sageWhMasterData.nodes.Supplier | null>;
    readonly postalCode: Promise<string>;
    readonly country: Reference<sageWhStructure.nodes.Country | null>;
    readonly countryName: Promise<string>;
    readonly city: Promise<string>;
    readonly region: Promise<string>;
    readonly telephone: Promise<string>;
    readonly fax: Promise<string>;
    readonly carrier: Reference<sageWhMasterData.nodes.Carrier | null>;
    readonly carrierName: Promise<string>;
    readonly carriageReference: Promise<string>;
    readonly transportationMethod: Reference<sageWhMasterData.nodes.TransportMode | null>;
    readonly status: Promise<sageWhProductData.enums.InputHeaderStatus>;
    readonly expectedInputNumber: Promise<string>;
    readonly receipt: Reference<sageWhInput.nodes.AdministrativeReceipt | null>;
    readonly receiptDate: Promise<date | null>;
    readonly transmittedFromL3: Promise<sageWhProductData.enums.TransmissionL3 | null>;
    readonly isControlled: Promise<boolean>;
    readonly isCrossDocking: Promise<boolean>;
    readonly lines: Collection<sageWhInput.nodes.DirectInputLine>;
    readonly addresses: Collection<sageWhInput.nodes.DirectInputAddresses>;
    readonly supplierNames: Collection<sageWhInput.nodes.DirectInputSupplierNames>;
}
//# sourceMappingURL=direct-input.d.ts.map