import * as sageWhMasterData from '@sage/wh-master-data';
import * as sageWhProductData from '@sage/wh-product-data';
import * as sageWhSystem from '@sage/wh-system';
import { Node, Reference, integer, decimal, date, Collection } from '@sage/xtrem-core';
import * as sageWhInput from '..';
export declare class DirectInputLine extends Node {
    readonly site: Reference<sageWhSystem.nodes.Site>;
    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
    readonly directInput: Reference<sageWhInput.nodes.DirectInput>;
    readonly lineNumber: Promise<integer>;
    readonly linePointerNumber: Promise<integer | null>;
    readonly referenceNumber: Promise<string>;
    readonly product: Reference<sageWhProductData.nodes.Product>;
    readonly multipleProduct: Promise<string>;
    readonly numberOfConsumptionUnit: Promise<decimal>;
    readonly numberOfContainers: Promise<decimal>;
    readonly container: Reference<sageWhProductData.nodes.ProductContainer>;
    readonly inputContainer: Reference<sageWhProductData.nodes.ProductContainer>;
    readonly movementCode: Reference<sageWhMasterData.nodes.MovementCode>;
    readonly supportNumber: Promise<string>;
    readonly reservationNumber: Promise<string>;
    readonly lotNumber: Promise<string>;
    readonly stockStatus: Reference<sageWhMasterData.nodes.StockNature | null>;
    readonly fifoDate: Promise<date>;
    readonly receiptDate: Promise<date | null>;
    readonly manufacturedDate: Promise<date | null>;
    readonly detentionDate: Promise<date | null>;
    readonly sellByDate: Promise<date | null>;
    readonly useByDate: Promise<date | null>;
    readonly shipByDate: Promise<date | null>;
    readonly status: Promise<sageWhProductData.enums.InputLineStatus>;
    readonly numberOfConsumptionUnitStored: Promise<decimal | null>;
    readonly receipt: Reference<sageWhInput.nodes.AdministrativeReceipt | null>;
    readonly receiptLineNumber: Promise<integer | null>;
    readonly expectedInputLineNumber: Promise<integer | null>;
    readonly inputLineType: Promise<string>;
    readonly imposedStore: Reference<sageWhMasterData.nodes.Store | null>;
    readonly isExclusiveStore: Promise<boolean>;
    readonly isKeyInSerialNumber: Promise<boolean>;
    readonly source: Reference<sageWhProductData.nodes.Origin | null>;
    readonly isCustomerReturn: Promise<boolean>;
    readonly addressedReceiptMovements: Collection<sageWhInput.nodes.ReceiptMovementAddressed>;
    readonly closedReceiptMovements: Collection<sageWhInput.nodes.ReceiptMovementClosed>;
    readonly inProgressReceiptMovements: Collection<sageWhInput.nodes.ReceiptMovementInProgress>;
    readonly numberOfConsumptionUnitRemaining: Promise<decimal | null>;
}
//# sourceMappingURL=direct-input-line.d.ts.map