import * as sageWhMasterData from '@sage/wh-master-data';
import * as sageWhProductData from '@sage/wh-product-data';
import * as sageWhSystem from '@sage/wh-system';
import { Node, Reference, date, integer, decimal, Collection, Context } from '@sage/xtrem-core';
import * as sageWhInput from '..';
export declare class AdministrativeReceipt extends Node {
    readonly site: Reference<sageWhSystem.nodes.Site>;
    readonly code: Promise<string>;
    readonly carrierAppointment: Reference<sageWhMasterData.nodes.AppointmentManagement | null>;
    readonly carrier: Reference<sageWhMasterData.nodes.Carrier | null>;
    readonly carrierName: Promise<string>;
    readonly carriageReference: Promise<string>;
    readonly transportationMethod: Reference<sageWhMasterData.nodes.TransportMode | null>;
    readonly store: Reference<sageWhMasterData.nodes.Store | null>;
    readonly dock: Reference<sageWhMasterData.nodes.Location | null>;
    readonly date: Promise<date>;
    readonly time: Promise<string>;
    readonly numberOfLoads: Promise<integer | null>;
    readonly grossWeight: Promise<decimal | null>;
    readonly status: Promise<sageWhProductData.enums.ReceiptStatus>;
    readonly duration: Promise<string>;
    readonly inProgressLines: Collection<sageWhInput.nodes.AdministrativeReceiptLineInProgress>;
    readonly validatedLines: Collection<sageWhInput.nodes.AdministrativeReceiptLineValidated>;
    readonly operatorCode: Promise<string>;
    static validateReceipt(context: Context, parameter: AdministrativeReceipt): Promise<AdministrativeReceipt>;
}
//# sourceMappingURL=administrative-receipt.d.ts.map