"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AdministrativeReceiptMovementInProgress = void 0;
const sageWhMasterData = require("@sage/wh-master-data");
const sageWhProductData = require("@sage/wh-product-data");
const sageWhSystem = require("@sage/wh-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageWhInput = require("..");
const joins = {
    referenceJoins: {
        site: {
            code: 'site',
        },
        receipt: {
            site: 'site',
            code: 'receipt',
        },
        depositor: {
            site: 'site',
            code: 'depositor',
        },
        product: {
            site: 'site',
            depositor: 'depositor',
            code: 'product',
        },
        container: {
            site: 'site',
            depositor: 'depositor',
            product: 'product',
            container: 'container',
        },
        homogeneousContainer: {
            site: 'site',
            depositor: 'depositor',
            product: 'product',
            container: 'homogeneousContainer',
        },
        receiptLine: {
            site: 'site',
            receipt: 'receipt',
            lineNumber: 'lineNumber',
        },
    },
};
let AdministrativeReceiptMovementInProgress = class AdministrativeReceiptMovementInProgress extends xtrem_core_1.Node {
};
exports.AdministrativeReceiptMovementInProgress = AdministrativeReceiptMovementInProgress;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FCY',
        columnType: 'string',
        node: () => sageWhSystem.nodes.Site,
        lookupAccess: true,
    })
], AdministrativeReceiptMovementInProgress.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'RCPNUM',
        columnType: 'string',
        node: () => sageWhInput.nodes.AdministrativeReceipt,
        lookupAccess: true,
    })
], AdministrativeReceiptMovementInProgress.prototype, "receipt", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RCPLIN',
        lookupAccess: true,
    })
], AdministrativeReceiptMovementInProgress.prototype, "lineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MVTLIN',
        lookupAccess: true,
    })
], AdministrativeReceiptMovementInProgress.prototype, "receiptMovementNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DEP',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Depositor,
        lookupAccess: true,
    })
], AdministrativeReceiptMovementInProgress.prototype, "depositor", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITM',
        columnType: 'string',
        node: () => sageWhProductData.nodes.Product,
        lookupAccess: true,
    })
], AdministrativeReceiptMovementInProgress.prototype, "product", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CTRQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], AdministrativeReceiptMovementInProgress.prototype, "numberOfContainers", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CTR',
        columnType: 'string',
        node: () => sageWhProductData.nodes.ProductContainer,
        lookupAccess: true,
    })
], AdministrativeReceiptMovementInProgress.prototype, "container", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CSUQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], AdministrativeReceiptMovementInProgress.prototype, "numberOfConsumptionUnit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        columnName: 'HMGQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], AdministrativeReceiptMovementInProgress.prototype, "homogeneousQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'HMGCTR',
        columnType: 'string',
        node: () => sageWhProductData.nodes.ProductContainer,
        lookupAccess: true,
    })
], AdministrativeReceiptMovementInProgress.prototype, "homogeneousContainer", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnType: 'string',
        node: () => sageWhInput.nodes.AdministrativeReceiptLineInProgress,
        lookupAccess: true,
    })
], AdministrativeReceiptMovementInProgress.prototype, "receiptLine", void 0);
exports.AdministrativeReceiptMovementInProgress = AdministrativeReceiptMovementInProgress = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'RECEIPTM',
        keyPropertyNames: ['site', 'receipt', 'lineNumber', 'receiptMovementNumber'],
        indexes: [
            {
                orderBy: {
                    site: 1,
                    receipt: 1,
                    lineNumber: 1,
                    receiptMovementNumber: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['lineNumber'],
        }),
        getFilters() {
            return [{ receiptLine: { status: { _nin: ['dripAndDropValidated', 'validated'] } } }];
        },
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], AdministrativeReceiptMovementInProgress);
//# sourceMappingURL=administrative-receipt-movement-in-progress.js.map