"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AdministrativeReceiptLineValidated = void 0;
const sageWhMasterData = require("@sage/wh-master-data");
const sageWhProductData = require("@sage/wh-product-data");
const sageWhSystem = require("@sage/wh-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageWhInput = require("..");
const joins = {
    referenceJoins: {
        site: {
            code: 'site',
        },
        receipt: {
            site: 'site',
            code: 'receipt',
        },
        expectedInput: {
            site: 'site',
            depositor: 'depositor',
            code: 'expectedInput',
        },
        expectedInputLine: {
            site: 'site',
            depositor: 'depositor',
            expectedInput: 'expectedInput',
            lineNumber: 'expectedInputLine',
        },
        depositor: {
            site: 'site',
            code: 'depositor',
        },
        product: {
            site: 'site',
            depositor: 'depositor',
            code: 'product',
        },
        inputContainer: {
            site: 'site',
            depositor: 'depositor',
            product: 'product',
            container: 'inputContainer',
        },
        stockStatus: {
            site: 'site',
            code: 'stockStatus',
        },
        store: {
            site: 'site',
            code: 'store',
        },
        source: {
            site: 'site',
            depositor: 'depositor',
            code: 'source',
        },
    },
    collectionJoins: {
        administrativeReceiptMovements: {
            site: 'site',
            receipt: 'receipt',
            lineNumber: 'lineNumber',
        },
    },
};
let AdministrativeReceiptLineValidated = class AdministrativeReceiptLineValidated extends xtrem_core_1.Node {
};
exports.AdministrativeReceiptLineValidated = AdministrativeReceiptLineValidated;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FCY',
        columnType: 'string',
        node: () => sageWhSystem.nodes.Site,
        lookupAccess: true,
    })
], AdministrativeReceiptLineValidated.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'RCPNUM',
        columnType: 'string',
        node: () => sageWhInput.nodes.AdministrativeReceipt,
        lookupAccess: true,
    })
], AdministrativeReceiptLineValidated.prototype, "receipt", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'EINNUM',
        columnType: 'string',
        node: () => sageWhInput.nodes.ExpectedInput,
        lookupAccess: true,
    })
], AdministrativeReceiptLineValidated.prototype, "expectedInput", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'EINLIN',
        columnType: 'integer',
        node: () => sageWhInput.nodes.ExpectedInputLine,
        lookupAccess: true,
    })
], AdministrativeReceiptLineValidated.prototype, "expectedInputLine", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SPLLIN',
        lookupAccess: true,
    })
], AdministrativeReceiptLineValidated.prototype, "splitLineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DEP',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Depositor,
        lookupAccess: true,
    })
], AdministrativeReceiptLineValidated.prototype, "depositor", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RCPLIN',
        lookupAccess: true,
    })
], AdministrativeReceiptLineValidated.prototype, "lineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RCLSTA',
        dataType: () => sageWhProductData.enums.receiptLineStatusDatatype,
        lookupAccess: true,
    })
], AdministrativeReceiptLineValidated.prototype, "status", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITM',
        columnType: 'string',
        node: () => sageWhProductData.nodes.Product,
        lookupAccess: true,
    })
], AdministrativeReceiptLineValidated.prototype, "product", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        columnName: 'RCPCSUQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], AdministrativeReceiptLineValidated.prototype, "receivedQuantityInConsumptionUnit", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CTRGNR',
        columnType: 'string',
        node: () => sageWhProductData.nodes.ProductContainer,
        lookupAccess: true,
    })
], AdministrativeReceiptLineValidated.prototype, "inputContainer", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LOT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], AdministrativeReceiptLineValidated.prototype, "lotNumber", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SPT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], AdministrativeReceiptLineValidated.prototype, "supportNumber", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'RSA',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], AdministrativeReceiptLineValidated.prototype, "reservationNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SKN',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.StockNature,
        lookupAccess: true,
    })
], AdministrativeReceiptLineValidated.prototype, "stockStatus", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STO',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Store,
        lookupAccess: true,
    })
], AdministrativeReceiptLineValidated.prototype, "store", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STOXCL',
        lookupAccess: true,
    })
], AdministrativeReceiptLineValidated.prototype, "isExclusiveStore", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DSCLIN',
        lookupAccess: true,
    })
], AdministrativeReceiptLineValidated.prototype, "isDispute", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DSCALL',
        lookupAccess: true,
    })
], AdministrativeReceiptLineValidated.prototype, "isPutaway", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ITMORI',
        columnType: 'string',
        node: () => sageWhProductData.nodes.Origin,
        lookupAccess: true,
    })
], AdministrativeReceiptLineValidated.prototype, "source", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MND',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        lookupAccess: true,
    })
], AdministrativeReceiptLineValidated.prototype, "manufacturedDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RTD',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        lookupAccess: true,
    })
], AdministrativeReceiptLineValidated.prototype, "detentionDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SLD',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        lookupAccess: true,
    })
], AdministrativeReceiptLineValidated.prototype, "sellByDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'USD',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        lookupAccess: true,
    })
], AdministrativeReceiptLineValidated.prototype, "useByDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SND',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        lookupAccess: true,
    })
], AdministrativeReceiptLineValidated.prototype, "shipByDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FIFDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        lookupAccess: true,
    })
], AdministrativeReceiptLineValidated.prototype, "fifoDate", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageWhInput.nodes.AdministrativeReceiptMovementValidated,
        dependsOn: ['site', 'receipt', 'lineNumber'],
        lookupAccess: true,
    })
], AdministrativeReceiptLineValidated.prototype, "administrativeReceiptMovements", void 0);
exports.AdministrativeReceiptLineValidated = AdministrativeReceiptLineValidated = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'RECEIPTL',
        keyPropertyNames: ['site', 'receipt', 'expectedInput', 'expectedInputLine', 'splitLineNumber'],
        indexes: [
            {
                orderBy: {
                    site: 1,
                    receipt: 1,
                    expectedInput: 1,
                    expectedInputLine: 1,
                    splitLineNumber: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
            {
                orderBy: {
                    site: 1,
                    receipt: 1,
                    lineNumber: 1,
                },
                isUnique: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['splitLineNumber'],
        }),
        getFilters() {
            return [{ status: { _in: ['dripAndDropValidated', 'validated'] } }];
        },
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], AdministrativeReceiptLineValidated);
//# sourceMappingURL=administrative-receipt-line-validated.js.map