import * as sageWhMasterData from '@sage/wh-master-data';
import * as sageWhProductData from '@sage/wh-product-data';
import * as sageWhSystem from '@sage/wh-system';
import { Node, Reference, integer, decimal, date, Collection } from '@sage/xtrem-core';
import * as sageWhInput from '..';
export declare class AdministrativeReceiptLineInProgress extends Node {
    readonly site: Reference<sageWhSystem.nodes.Site>;
    readonly receipt: Reference<sageWhInput.nodes.AdministrativeReceipt>;
    readonly expectedInput: Reference<sageWhInput.nodes.ExpectedInput>;
    readonly expectedInputLine: Reference<sageWhInput.nodes.ExpectedInputLine>;
    readonly splitLineNumber: Promise<integer | null>;
    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
    readonly lineNumber: Promise<integer | null>;
    readonly status: Promise<sageWhProductData.enums.ReceiptLineStatus | null>;
    readonly product: Reference<sageWhProductData.nodes.Product>;
    readonly receivedQuantityInConsumptionUnit: Promise<decimal>;
    readonly inputContainer: Reference<sageWhProductData.nodes.ProductContainer>;
    readonly lotNumber: Promise<string>;
    readonly supportNumber: Promise<string>;
    readonly reservationNumber: Promise<string>;
    readonly stockStatus: Reference<sageWhMasterData.nodes.StockNature | null>;
    readonly store: Reference<sageWhMasterData.nodes.Store | null>;
    readonly isExclusiveStore: Promise<boolean>;
    readonly isDispute: Promise<boolean>;
    readonly isPutaway: Promise<boolean>;
    readonly source: Reference<sageWhProductData.nodes.Origin | null>;
    readonly manufacturedDate: Promise<date | null>;
    readonly detentionDate: Promise<date | null>;
    readonly sellByDate: Promise<date | null>;
    readonly useByDate: Promise<date | null>;
    readonly shipByDate: Promise<date | null>;
    readonly fifoDate: Promise<date>;
    readonly administrativeReceiptMovements: Collection<sageWhInput.nodes.AdministrativeReceiptMovementInProgress>;
    readonly actionImport: Promise<string>;
}
//# sourceMappingURL=administrative-receipt-line-in-progress.d.ts.map