declare module '@sage/wh-input-api-partial' {
    import type {
        AppointmentManagement,
        Carrier,
        Depositor,
        Location,
        MovementCode,
        Operand,
        Package as SageWhMasterData$Package,
        SerialGroup,
        StockNature,
        Store,
        Supplier,
        TransportMode,
    } from '@sage/wh-master-data-api';
    import type {
        Origin,
        Package as SageWhProductData$Package,
        Product,
        ProductContainer,
        ReceiptMode,
    } from '@sage/wh-product-data-api';
    import type {
        Package as SageWhStockData$Package,
        SerialNumber,
        SerialNumberInput,
        StockObject,
        StockObjectContainerLevels,
        StockObjectContainerLevelsBinding,
        StockObjectContainerLevelsInput,
        StockObjectInput,
    } from '@sage/wh-stock-data-api';
    import type { Country, Package as SageWhStructure$Package } from '@sage/wh-structure-api';
    import type { Package as SageWhSystem$Package, Site } from '@sage/wh-system-api';
    import type { Package as SageXtremAppMetadata$Package } from '@sage/xtrem-app-metadata-api';
    import type { Package as SageXtremX3SystemUtils$Package, SysUser } from '@sage/xtrem-x3-system-utils-api';
    import type {
        AggregateQueryOperation,
        AggregateReadOperation,
        ClientCollection,
        ClientNode,
        ClientNodeInput,
        GetDefaultsOperation,
        Operation as Node$Operation,
        QueryOperation,
        ReadOperation,
        VitalClientNode,
        VitalClientNodeInput,
        decimal,
        integer,
    } from '@sage/xtrem-client';
    export interface AdministrativeReceiptLineInProgress extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        receipt: AdministrativeReceipt;
        expectedInput: ExpectedInput;
        expectedInputLine: ExpectedInputLine;
        splitLineNumber: integer;
        depositor: Depositor;
        lineNumber: integer;
        status: ReceiptLineStatus;
        product: Product;
        receivedQuantityInConsumptionUnit: string;
        inputContainer: ProductContainer;
        lotNumber: string;
        supportNumber: string;
        reservationNumber: string;
        stockStatus: StockNature;
        store: Store;
        isExclusiveStore: boolean;
        isDispute: boolean;
        isPutaway: boolean;
        source: Origin;
        manufacturedDate: string;
        detentionDate: string;
        sellByDate: string;
        useByDate: string;
        shipByDate: string;
        fifoDate: string;
        administrativeReceiptMovements: ClientCollection<AdministrativeReceiptMovementInProgress>;
    }
    export interface AdministrativeReceiptLineInProgressInput extends ClientNodeInput {
        site?: string;
        receipt?: string;
        expectedInput?: string;
        expectedInputLine?: integer | string;
        splitLineNumber?: integer | string;
        depositor?: string;
        lineNumber?: integer | string;
        status?: ReceiptLineStatus;
        product?: string;
        receivedQuantityInConsumptionUnit?: decimal | string;
        inputContainer?: string;
        lotNumber?: string;
        supportNumber?: string;
        reservationNumber?: string;
        stockStatus?: string;
        store?: string;
        isExclusiveStore?: boolean | string;
        isDispute?: boolean | string;
        isPutaway?: boolean | string;
        source?: string;
        manufacturedDate?: string;
        detentionDate?: string;
        sellByDate?: string;
        useByDate?: string;
        shipByDate?: string;
        fifoDate?: string;
        administrativeReceiptMovements?: Partial<AdministrativeReceiptMovementInProgressInput>[];
        actionImport?: string;
    }
    export interface AdministrativeReceiptLineInProgressBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        receipt: AdministrativeReceipt;
        expectedInput: ExpectedInput;
        expectedInputLine: ExpectedInputLine;
        splitLineNumber: integer;
        depositor: Depositor;
        lineNumber: integer;
        status: ReceiptLineStatus;
        product: Product;
        receivedQuantityInConsumptionUnit: string;
        inputContainer: ProductContainer;
        lotNumber: string;
        supportNumber: string;
        reservationNumber: string;
        stockStatus: StockNature;
        store: Store;
        isExclusiveStore: boolean;
        isDispute: boolean;
        isPutaway: boolean;
        source: Origin;
        manufacturedDate: string;
        detentionDate: string;
        sellByDate: string;
        useByDate: string;
        shipByDate: string;
        fifoDate: string;
        administrativeReceiptMovements: ClientCollection<AdministrativeReceiptMovementInProgress>;
        actionImport: string;
    }
    export interface AdministrativeReceiptLineInProgress$Lookups {
        site: QueryOperation<Site>;
        receipt: QueryOperation<AdministrativeReceipt>;
        expectedInput: QueryOperation<ExpectedInput>;
        expectedInputLine: QueryOperation<ExpectedInputLine>;
        depositor: QueryOperation<Depositor>;
        product: QueryOperation<Product>;
        inputContainer: QueryOperation<ProductContainer>;
        stockStatus: QueryOperation<StockNature>;
        store: QueryOperation<Store>;
        source: QueryOperation<Origin>;
    }
    export interface AdministrativeReceiptLineInProgress$Operations {
        query: QueryOperation<AdministrativeReceiptLineInProgress>;
        read: ReadOperation<AdministrativeReceiptLineInProgress>;
        aggregate: {
            read: AggregateReadOperation<AdministrativeReceiptLineInProgress>;
            query: AggregateQueryOperation<AdministrativeReceiptLineInProgress>;
        };
        lookups(
            dataOrId: string | { data: AdministrativeReceiptLineInProgressInput },
        ): AdministrativeReceiptLineInProgress$Lookups;
        getDefaults: GetDefaultsOperation<AdministrativeReceiptLineInProgress>;
    }
    export interface AdministrativeReceiptLineValidated extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        receipt: AdministrativeReceipt;
        expectedInput: ExpectedInput;
        expectedInputLine: ExpectedInputLine;
        splitLineNumber: integer;
        depositor: Depositor;
        lineNumber: integer;
        status: ReceiptLineStatus;
        product: Product;
        receivedQuantityInConsumptionUnit: string;
        inputContainer: ProductContainer;
        lotNumber: string;
        supportNumber: string;
        reservationNumber: string;
        stockStatus: StockNature;
        store: Store;
        isExclusiveStore: boolean;
        isDispute: boolean;
        isPutaway: boolean;
        source: Origin;
        manufacturedDate: string;
        detentionDate: string;
        sellByDate: string;
        useByDate: string;
        shipByDate: string;
        fifoDate: string;
        administrativeReceiptMovements: ClientCollection<AdministrativeReceiptMovementValidated>;
    }
    export interface AdministrativeReceiptLineValidatedInput extends ClientNodeInput {
        site?: string;
        receipt?: string;
        expectedInput?: string;
        expectedInputLine?: integer | string;
        splitLineNumber?: integer | string;
        depositor?: string;
        lineNumber?: integer | string;
        status?: ReceiptLineStatus;
        product?: string;
        receivedQuantityInConsumptionUnit?: decimal | string;
        inputContainer?: string;
        lotNumber?: string;
        supportNumber?: string;
        reservationNumber?: string;
        stockStatus?: string;
        store?: string;
        isExclusiveStore?: boolean | string;
        isDispute?: boolean | string;
        isPutaway?: boolean | string;
        source?: string;
        manufacturedDate?: string;
        detentionDate?: string;
        sellByDate?: string;
        useByDate?: string;
        shipByDate?: string;
        fifoDate?: string;
    }
    export interface AdministrativeReceiptLineValidatedBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        receipt: AdministrativeReceipt;
        expectedInput: ExpectedInput;
        expectedInputLine: ExpectedInputLine;
        splitLineNumber: integer;
        depositor: Depositor;
        lineNumber: integer;
        status: ReceiptLineStatus;
        product: Product;
        receivedQuantityInConsumptionUnit: string;
        inputContainer: ProductContainer;
        lotNumber: string;
        supportNumber: string;
        reservationNumber: string;
        stockStatus: StockNature;
        store: Store;
        isExclusiveStore: boolean;
        isDispute: boolean;
        isPutaway: boolean;
        source: Origin;
        manufacturedDate: string;
        detentionDate: string;
        sellByDate: string;
        useByDate: string;
        shipByDate: string;
        fifoDate: string;
        administrativeReceiptMovements: ClientCollection<AdministrativeReceiptMovementValidated>;
    }
    export interface AdministrativeReceiptLineValidated$Lookups {
        site: QueryOperation<Site>;
        receipt: QueryOperation<AdministrativeReceipt>;
        expectedInput: QueryOperation<ExpectedInput>;
        expectedInputLine: QueryOperation<ExpectedInputLine>;
        depositor: QueryOperation<Depositor>;
        product: QueryOperation<Product>;
        inputContainer: QueryOperation<ProductContainer>;
        stockStatus: QueryOperation<StockNature>;
        store: QueryOperation<Store>;
        source: QueryOperation<Origin>;
    }
    export interface AdministrativeReceiptLineValidated$Operations {
        query: QueryOperation<AdministrativeReceiptLineValidated>;
        read: ReadOperation<AdministrativeReceiptLineValidated>;
        aggregate: {
            read: AggregateReadOperation<AdministrativeReceiptLineValidated>;
            query: AggregateQueryOperation<AdministrativeReceiptLineValidated>;
        };
        lookups(
            dataOrId: string | { data: AdministrativeReceiptLineValidatedInput },
        ): AdministrativeReceiptLineValidated$Lookups;
        getDefaults: GetDefaultsOperation<AdministrativeReceiptLineValidated>;
    }
    export interface AdministrativeReceiptMovementInProgress extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        receipt: AdministrativeReceipt;
        lineNumber: integer;
        receiptMovementNumber: integer;
        depositor: Depositor;
        product: Product;
        numberOfContainers: string;
        container: ProductContainer;
        numberOfConsumptionUnit: string;
        homogeneousQuantity: string;
        homogeneousContainer: ProductContainer;
        receiptLine: AdministrativeReceiptLineInProgress;
    }
    export interface AdministrativeReceiptMovementInProgressInput extends ClientNodeInput {
        site?: string;
        receipt?: string;
        lineNumber?: integer | string;
        receiptMovementNumber?: integer | string;
        depositor?: string;
        product?: string;
        numberOfContainers?: decimal | string;
        container?: string;
        numberOfConsumptionUnit?: decimal | string;
        homogeneousQuantity?: decimal | string;
        homogeneousContainer?: string;
        receiptLine?: string;
    }
    export interface AdministrativeReceiptMovementInProgressBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        receipt: AdministrativeReceipt;
        lineNumber: integer;
        receiptMovementNumber: integer;
        depositor: Depositor;
        product: Product;
        numberOfContainers: string;
        container: ProductContainer;
        numberOfConsumptionUnit: string;
        homogeneousQuantity: string;
        homogeneousContainer: ProductContainer;
        receiptLine: AdministrativeReceiptLineInProgress;
    }
    export interface AdministrativeReceiptMovementInProgress$Lookups {
        site: QueryOperation<Site>;
        receipt: QueryOperation<AdministrativeReceipt>;
        depositor: QueryOperation<Depositor>;
        product: QueryOperation<Product>;
        container: QueryOperation<ProductContainer>;
        homogeneousContainer: QueryOperation<ProductContainer>;
        receiptLine: QueryOperation<AdministrativeReceiptLineInProgress>;
    }
    export interface AdministrativeReceiptMovementInProgress$Operations {
        query: QueryOperation<AdministrativeReceiptMovementInProgress>;
        read: ReadOperation<AdministrativeReceiptMovementInProgress>;
        aggregate: {
            read: AggregateReadOperation<AdministrativeReceiptMovementInProgress>;
            query: AggregateQueryOperation<AdministrativeReceiptMovementInProgress>;
        };
        lookups(
            dataOrId: string | { data: AdministrativeReceiptMovementInProgressInput },
        ): AdministrativeReceiptMovementInProgress$Lookups;
        getDefaults: GetDefaultsOperation<AdministrativeReceiptMovementInProgress>;
    }
    export interface AdministrativeReceiptMovementValidated extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        receipt: AdministrativeReceipt;
        lineNumber: integer;
        receiptMovementNumber: integer;
        depositor: Depositor;
        product: Product;
        numberOfContainers: string;
        container: ProductContainer;
        numberOfConsumptionUnit: string;
        homogeneousQuantity: string;
        homogeneousContainer: ProductContainer;
        receiptLine: AdministrativeReceiptLineValidated;
    }
    export interface AdministrativeReceiptMovementValidatedInput extends ClientNodeInput {
        site?: string;
        receipt?: string;
        lineNumber?: integer | string;
        receiptMovementNumber?: integer | string;
        depositor?: string;
        product?: string;
        numberOfContainers?: decimal | string;
        container?: string;
        numberOfConsumptionUnit?: decimal | string;
        homogeneousQuantity?: decimal | string;
        homogeneousContainer?: string;
        receiptLine?: string;
    }
    export interface AdministrativeReceiptMovementValidatedBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        receipt: AdministrativeReceipt;
        lineNumber: integer;
        receiptMovementNumber: integer;
        depositor: Depositor;
        product: Product;
        numberOfContainers: string;
        container: ProductContainer;
        numberOfConsumptionUnit: string;
        homogeneousQuantity: string;
        homogeneousContainer: ProductContainer;
        receiptLine: AdministrativeReceiptLineValidated;
    }
    export interface AdministrativeReceiptMovementValidated$Lookups {
        site: QueryOperation<Site>;
        receipt: QueryOperation<AdministrativeReceipt>;
        depositor: QueryOperation<Depositor>;
        product: QueryOperation<Product>;
        container: QueryOperation<ProductContainer>;
        homogeneousContainer: QueryOperation<ProductContainer>;
        receiptLine: QueryOperation<AdministrativeReceiptLineValidated>;
    }
    export interface AdministrativeReceiptMovementValidated$Operations {
        query: QueryOperation<AdministrativeReceiptMovementValidated>;
        read: ReadOperation<AdministrativeReceiptMovementValidated>;
        aggregate: {
            read: AggregateReadOperation<AdministrativeReceiptMovementValidated>;
            query: AggregateQueryOperation<AdministrativeReceiptMovementValidated>;
        };
        lookups(
            dataOrId: string | { data: AdministrativeReceiptMovementValidatedInput },
        ): AdministrativeReceiptMovementValidated$Lookups;
        getDefaults: GetDefaultsOperation<AdministrativeReceiptMovementValidated>;
    }
    export interface AdministrativeReceipt extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        carrierAppointment: AppointmentManagement;
        carrier: Carrier;
        carrierName: string;
        carriageReference: string;
        transportationMethod: TransportMode;
        store: Store;
        dock: Location;
        date: string;
        time: string;
        numberOfLoads: integer;
        grossWeight: string;
        status: ReceiptStatus;
        duration: string;
        inProgressLines: ClientCollection<AdministrativeReceiptLineInProgress>;
        validatedLines: ClientCollection<AdministrativeReceiptLineValidated>;
    }
    export interface AdministrativeReceiptInput extends ClientNodeInput {
        site?: string;
        code?: string;
        carrierAppointment?: string;
        carrier?: string;
        carrierName?: string;
        carriageReference?: string;
        transportationMethod?: string;
        store?: string;
        dock?: string;
        date?: string;
        time?: string;
        numberOfLoads?: integer | string;
        grossWeight?: decimal | string;
        status?: ReceiptStatus;
        duration?: string;
        inProgressLines?: Partial<AdministrativeReceiptLineInProgressInput>[];
        operatorCode?: string;
    }
    export interface AdministrativeReceiptBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        carrierAppointment: AppointmentManagement;
        carrier: Carrier;
        carrierName: string;
        carriageReference: string;
        transportationMethod: TransportMode;
        store: Store;
        dock: Location;
        date: string;
        time: string;
        numberOfLoads: integer;
        grossWeight: string;
        status: ReceiptStatus;
        duration: string;
        inProgressLines: ClientCollection<AdministrativeReceiptLineInProgress>;
        validatedLines: ClientCollection<AdministrativeReceiptLineValidated>;
        operatorCode: string;
    }
    export interface AdministrativeReceipt$Mutations {
        validateReceipt: Node$Operation<
            {
                parameter?: AdministrativeReceiptInput;
            },
            AdministrativeReceipt
        >;
    }
    export interface AdministrativeReceipt$Lookups {
        site: QueryOperation<Site>;
        carrierAppointment: QueryOperation<AppointmentManagement>;
        carrier: QueryOperation<Carrier>;
        transportationMethod: QueryOperation<TransportMode>;
        store: QueryOperation<Store>;
        dock: QueryOperation<Location>;
    }
    export interface AdministrativeReceipt$Operations {
        query: QueryOperation<AdministrativeReceipt>;
        read: ReadOperation<AdministrativeReceipt>;
        aggregate: {
            read: AggregateReadOperation<AdministrativeReceipt>;
            query: AggregateQueryOperation<AdministrativeReceipt>;
        };
        mutations: AdministrativeReceipt$Mutations;
        lookups(dataOrId: string | { data: AdministrativeReceiptInput }): AdministrativeReceipt$Lookups;
        getDefaults: GetDefaultsOperation<AdministrativeReceipt>;
    }
    export interface DirectInputAddresses extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        address: string;
    }
    export interface DirectInputAddressesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        depositor?: string;
        code?: string;
        address?: string;
    }
    export interface DirectInputAddressesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        address: string;
    }
    export interface DirectInputAddresses$Operations {
        query: QueryOperation<DirectInputAddresses>;
        read: ReadOperation<DirectInputAddresses>;
        aggregate: {
            read: AggregateReadOperation<DirectInputAddresses>;
            query: AggregateQueryOperation<DirectInputAddresses>;
        };
        getDefaults: GetDefaultsOperation<DirectInputAddresses>;
    }
    export interface DirectInputLine extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        directInput: DirectInput;
        lineNumber: integer;
        linePointerNumber: integer;
        referenceNumber: string;
        product: Product;
        multipleProduct: string;
        numberOfConsumptionUnit: string;
        numberOfContainers: string;
        container: ProductContainer;
        inputContainer: ProductContainer;
        movementCode: MovementCode;
        supportNumber: string;
        reservationNumber: string;
        lotNumber: string;
        stockStatus: StockNature;
        fifoDate: string;
        receiptDate: string;
        manufacturedDate: string;
        detentionDate: string;
        sellByDate: string;
        useByDate: string;
        shipByDate: string;
        status: InputLineStatus;
        numberOfConsumptionUnitStored: string;
        receipt: AdministrativeReceipt;
        receiptLineNumber: integer;
        expectedInputLineNumber: integer;
        inputLineType: string;
        imposedStore: Store;
        isExclusiveStore: boolean;
        isKeyInSerialNumber: boolean;
        source: Origin;
        isCustomerReturn: boolean;
        addressedReceiptMovements: ClientCollection<ReceiptMovementAddressed>;
        closedReceiptMovements: ClientCollection<ReceiptMovementClosed>;
        inProgressReceiptMovements: ClientCollection<ReceiptMovementInProgress>;
        numberOfConsumptionUnitRemaining: string;
    }
    export interface DirectInputLineInput extends ClientNodeInput {
        site?: string;
        depositor?: string;
        directInput?: string;
        lineNumber?: integer | string;
        linePointerNumber?: integer | string;
        referenceNumber?: string;
        product?: string;
        multipleProduct?: string;
        numberOfConsumptionUnit?: decimal | string;
        numberOfContainers?: decimal | string;
        container?: string;
        inputContainer?: string;
        movementCode?: string;
        supportNumber?: string;
        reservationNumber?: string;
        lotNumber?: string;
        stockStatus?: string;
        fifoDate?: string;
        receiptDate?: string;
        manufacturedDate?: string;
        detentionDate?: string;
        sellByDate?: string;
        useByDate?: string;
        shipByDate?: string;
        status?: InputLineStatus;
        numberOfConsumptionUnitStored?: decimal | string;
        receipt?: string;
        receiptLineNumber?: integer | string;
        expectedInputLineNumber?: integer | string;
        inputLineType?: string;
        imposedStore?: string;
        isExclusiveStore?: boolean | string;
        isKeyInSerialNumber?: boolean | string;
        source?: string;
        isCustomerReturn?: boolean | string;
        addressedReceiptMovements?: Partial<ReceiptMovementAddressedInput>[];
    }
    export interface DirectInputLineBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        directInput: DirectInput;
        lineNumber: integer;
        linePointerNumber: integer;
        referenceNumber: string;
        product: Product;
        multipleProduct: string;
        numberOfConsumptionUnit: string;
        numberOfContainers: string;
        container: ProductContainer;
        inputContainer: ProductContainer;
        movementCode: MovementCode;
        supportNumber: string;
        reservationNumber: string;
        lotNumber: string;
        stockStatus: StockNature;
        fifoDate: string;
        receiptDate: string;
        manufacturedDate: string;
        detentionDate: string;
        sellByDate: string;
        useByDate: string;
        shipByDate: string;
        status: InputLineStatus;
        numberOfConsumptionUnitStored: string;
        receipt: AdministrativeReceipt;
        receiptLineNumber: integer;
        expectedInputLineNumber: integer;
        inputLineType: string;
        imposedStore: Store;
        isExclusiveStore: boolean;
        isKeyInSerialNumber: boolean;
        source: Origin;
        isCustomerReturn: boolean;
        addressedReceiptMovements: ClientCollection<ReceiptMovementAddressed>;
        closedReceiptMovements: ClientCollection<ReceiptMovementClosed>;
        inProgressReceiptMovements: ClientCollection<ReceiptMovementInProgress>;
        numberOfConsumptionUnitRemaining: string;
    }
    export interface DirectInputLine$Lookups {
        site: QueryOperation<Site>;
        depositor: QueryOperation<Depositor>;
        directInput: QueryOperation<DirectInput>;
        product: QueryOperation<Product>;
        container: QueryOperation<ProductContainer>;
        inputContainer: QueryOperation<ProductContainer>;
        movementCode: QueryOperation<MovementCode>;
        stockStatus: QueryOperation<StockNature>;
        receipt: QueryOperation<AdministrativeReceipt>;
        imposedStore: QueryOperation<Store>;
        source: QueryOperation<Origin>;
    }
    export interface DirectInputLine$Operations {
        query: QueryOperation<DirectInputLine>;
        read: ReadOperation<DirectInputLine>;
        aggregate: {
            read: AggregateReadOperation<DirectInputLine>;
            query: AggregateQueryOperation<DirectInputLine>;
        };
        lookups(dataOrId: string | { data: DirectInputLineInput }): DirectInputLine$Lookups;
        getDefaults: GetDefaultsOperation<DirectInputLine>;
    }
    export interface DirectInputSupplierNames extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        supplierName: string;
    }
    export interface DirectInputSupplierNamesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        depositor?: string;
        code?: string;
        supplierName?: string;
    }
    export interface DirectInputSupplierNamesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        supplierName: string;
    }
    export interface DirectInputSupplierNames$Operations {
        query: QueryOperation<DirectInputSupplierNames>;
        read: ReadOperation<DirectInputSupplierNames>;
        aggregate: {
            read: AggregateReadOperation<DirectInputSupplierNames>;
            query: AggregateQueryOperation<DirectInputSupplierNames>;
        };
        getDefaults: GetDefaultsOperation<DirectInputSupplierNames>;
    }
    export interface DirectInput extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        movementCode: MovementCode;
        referenceNumber: string;
        date: string;
        supplier: Supplier;
        postalCode: string;
        country: Country;
        countryName: string;
        city: string;
        region: string;
        telephone: string;
        fax: string;
        carrier: Carrier;
        carrierName: string;
        carriageReference: string;
        transportationMethod: TransportMode;
        status: InputHeaderStatus;
        expectedInputNumber: string;
        receipt: AdministrativeReceipt;
        receiptDate: string;
        transmittedFromL3: TransmissionL3;
        isControlled: boolean;
        isCrossDocking: boolean;
        lines: ClientCollection<DirectInputLine>;
        addresses: ClientCollection<DirectInputAddresses>;
        supplierNames: ClientCollection<DirectInputSupplierNames>;
    }
    export interface DirectInputInput extends ClientNodeInput {
        site?: string;
        depositor?: string;
        code?: string;
        movementCode?: string;
        referenceNumber?: string;
        date?: string;
        supplier?: string;
        postalCode?: string;
        country?: string;
        countryName?: string;
        city?: string;
        region?: string;
        telephone?: string;
        fax?: string;
        carrier?: string;
        carrierName?: string;
        carriageReference?: string;
        transportationMethod?: string;
        status?: InputHeaderStatus;
        expectedInputNumber?: string;
        receipt?: string;
        receiptDate?: string;
        transmittedFromL3?: TransmissionL3;
        isControlled?: boolean | string;
        isCrossDocking?: boolean | string;
        lines?: Partial<DirectInputLineInput>[];
        addresses?: Partial<DirectInputAddressesInput>[];
        supplierNames?: Partial<DirectInputSupplierNamesInput>[];
    }
    export interface DirectInputBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        movementCode: MovementCode;
        referenceNumber: string;
        date: string;
        supplier: Supplier;
        postalCode: string;
        country: Country;
        countryName: string;
        city: string;
        region: string;
        telephone: string;
        fax: string;
        carrier: Carrier;
        carrierName: string;
        carriageReference: string;
        transportationMethod: TransportMode;
        status: InputHeaderStatus;
        expectedInputNumber: string;
        receipt: AdministrativeReceipt;
        receiptDate: string;
        transmittedFromL3: TransmissionL3;
        isControlled: boolean;
        isCrossDocking: boolean;
        lines: ClientCollection<DirectInputLine>;
        addresses: ClientCollection<DirectInputAddressesBinding>;
        supplierNames: ClientCollection<DirectInputSupplierNamesBinding>;
    }
    export interface DirectInput$Lookups {
        site: QueryOperation<Site>;
        depositor: QueryOperation<Depositor>;
        movementCode: QueryOperation<MovementCode>;
        supplier: QueryOperation<Supplier>;
        country: QueryOperation<Country>;
        carrier: QueryOperation<Carrier>;
        transportationMethod: QueryOperation<TransportMode>;
        receipt: QueryOperation<AdministrativeReceipt>;
    }
    export interface DirectInput$Operations {
        query: QueryOperation<DirectInput>;
        read: ReadOperation<DirectInput>;
        aggregate: {
            read: AggregateReadOperation<DirectInput>;
            query: AggregateQueryOperation<DirectInput>;
        };
        lookups(dataOrId: string | { data: DirectInputInput }): DirectInput$Lookups;
        getDefaults: GetDefaultsOperation<DirectInput>;
    }
    export interface ExpectedInputAddresses extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        address: string;
    }
    export interface ExpectedInputAddressesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        depositor?: string;
        code?: string;
        address?: string;
    }
    export interface ExpectedInputAddressesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        address: string;
    }
    export interface ExpectedInputAddresses$Operations {
        query: QueryOperation<ExpectedInputAddresses>;
        read: ReadOperation<ExpectedInputAddresses>;
        aggregate: {
            read: AggregateReadOperation<ExpectedInputAddresses>;
            query: AggregateQueryOperation<ExpectedInputAddresses>;
        };
        getDefaults: GetDefaultsOperation<ExpectedInputAddresses>;
    }
    export interface ExpectedInputLine extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        expectedInput: ExpectedInput;
        lineNumber: integer;
        referenceNumber: string;
        product: Product;
        inputContainer: ProductContainer;
        supportNumber: string;
        reservationNumber: string;
        lotNumber: string;
        movementCode: MovementCode;
        source: Origin;
        stockStatus: StockNature;
        store: Store;
        isExclusiveStore: boolean;
        multipleProducts: string;
        isCustomerReturn: boolean;
        receiptDate: string;
        manufacturedDate: string;
        detentionDate: string;
        sellByDate: string;
        useByDate: string;
        shipByDate: string;
        fifoDate: string;
        status: ExpectedInputLineStatus;
        expectedQuantityInConsumptionUnit: string;
        remainingQuantityInConsumptionUnit: string;
        receivedQuantityInConsumptionUnit: string;
        disputedQuantityInConsumptionUnit: string;
    }
    export interface ExpectedInputLineInput extends ClientNodeInput {
        site?: string;
        depositor?: string;
        expectedInput?: string;
        lineNumber?: integer | string;
        referenceNumber?: string;
        product?: string;
        inputContainer?: string;
        supportNumber?: string;
        reservationNumber?: string;
        lotNumber?: string;
        movementCode?: string;
        source?: string;
        stockStatus?: string;
        store?: string;
        isExclusiveStore?: boolean | string;
        multipleProducts?: string;
        isCustomerReturn?: boolean | string;
        receiptDate?: string;
        manufacturedDate?: string;
        detentionDate?: string;
        sellByDate?: string;
        useByDate?: string;
        shipByDate?: string;
        fifoDate?: string;
        status?: ExpectedInputLineStatus;
        expectedQuantityInConsumptionUnit?: decimal | string;
        remainingQuantityInConsumptionUnit?: decimal | string;
        receivedQuantityInConsumptionUnit?: decimal | string;
        disputedQuantityInConsumptionUnit?: decimal | string;
    }
    export interface ExpectedInputLineBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        expectedInput: ExpectedInput;
        lineNumber: integer;
        referenceNumber: string;
        product: Product;
        inputContainer: ProductContainer;
        supportNumber: string;
        reservationNumber: string;
        lotNumber: string;
        movementCode: MovementCode;
        source: Origin;
        stockStatus: StockNature;
        store: Store;
        isExclusiveStore: boolean;
        multipleProducts: string;
        isCustomerReturn: boolean;
        receiptDate: string;
        manufacturedDate: string;
        detentionDate: string;
        sellByDate: string;
        useByDate: string;
        shipByDate: string;
        fifoDate: string;
        status: ExpectedInputLineStatus;
        expectedQuantityInConsumptionUnit: string;
        remainingQuantityInConsumptionUnit: string;
        receivedQuantityInConsumptionUnit: string;
        disputedQuantityInConsumptionUnit: string;
    }
    export interface ExpectedInputLine$Lookups {
        site: QueryOperation<Site>;
        depositor: QueryOperation<Depositor>;
        expectedInput: QueryOperation<ExpectedInput>;
        product: QueryOperation<Product>;
        inputContainer: QueryOperation<ProductContainer>;
        movementCode: QueryOperation<MovementCode>;
        source: QueryOperation<Origin>;
        stockStatus: QueryOperation<StockNature>;
        store: QueryOperation<Store>;
    }
    export interface ExpectedInputLine$Operations {
        query: QueryOperation<ExpectedInputLine>;
        read: ReadOperation<ExpectedInputLine>;
        aggregate: {
            read: AggregateReadOperation<ExpectedInputLine>;
            query: AggregateQueryOperation<ExpectedInputLine>;
        };
        lookups(dataOrId: string | { data: ExpectedInputLineInput }): ExpectedInputLine$Lookups;
        getDefaults: GetDefaultsOperation<ExpectedInputLine>;
    }
    export interface ExpectedInputSupplierNames extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        supplierName: string;
    }
    export interface ExpectedInputSupplierNamesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        depositor?: string;
        code?: string;
        supplierName?: string;
    }
    export interface ExpectedInputSupplierNamesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        supplierName: string;
    }
    export interface ExpectedInputSupplierNames$Operations {
        query: QueryOperation<ExpectedInputSupplierNames>;
        read: ReadOperation<ExpectedInputSupplierNames>;
        aggregate: {
            read: AggregateReadOperation<ExpectedInputSupplierNames>;
            query: AggregateQueryOperation<ExpectedInputSupplierNames>;
        };
        getDefaults: GetDefaultsOperation<ExpectedInputSupplierNames>;
    }
    export interface ExpectedInput extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        date: string;
        time: string;
        receiptMode: ReceiptMode;
        movementCode: MovementCode;
        referenceNumber: string;
        carrierAppointment: AppointmentManagement;
        appointmentDate: string;
        appointmentTime: string;
        supplier: Supplier;
        postalCode: string;
        countryCode: Country;
        countryName: string;
        city: string;
        region: string;
        telephone: string;
        fax: string;
        carrier: Carrier;
        carrierName: string;
        carriageReference: string;
        transportationMethod: TransportMode;
        status: ExpectedInputStatus;
        lastReceipt: AdministrativeReceipt;
        previousReceipt: AdministrativeReceipt;
        transmittedFromL3: TransmissionL3;
        isQualityControlManagement: boolean;
        orderNumber: string;
        orderReference: string;
        lines: ClientCollection<ExpectedInputLine>;
        addresses: ClientCollection<ExpectedInputAddresses>;
        supplierNames: ClientCollection<ExpectedInputSupplierNames>;
    }
    export interface ExpectedInputInput extends ClientNodeInput {
        site?: string;
        depositor?: string;
        code?: string;
        date?: string;
        time?: string;
        receiptMode?: string;
        movementCode?: string;
        referenceNumber?: string;
        carrierAppointment?: string;
        appointmentDate?: string;
        appointmentTime?: string;
        supplier?: string;
        postalCode?: string;
        countryCode?: string;
        countryName?: string;
        city?: string;
        region?: string;
        telephone?: string;
        fax?: string;
        carrier?: string;
        carrierName?: string;
        carriageReference?: string;
        transportationMethod?: string;
        status?: ExpectedInputStatus;
        lastReceipt?: string;
        previousReceipt?: string;
        transmittedFromL3?: TransmissionL3;
        isQualityControlManagement?: boolean | string;
        orderNumber?: string;
        orderReference?: string;
        lines?: Partial<ExpectedInputLineInput>[];
        addresses?: Partial<ExpectedInputAddressesInput>[];
        supplierNames?: Partial<ExpectedInputSupplierNamesInput>[];
    }
    export interface ExpectedInputBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        date: string;
        time: string;
        receiptMode: ReceiptMode;
        movementCode: MovementCode;
        referenceNumber: string;
        carrierAppointment: AppointmentManagement;
        appointmentDate: string;
        appointmentTime: string;
        supplier: Supplier;
        postalCode: string;
        countryCode: Country;
        countryName: string;
        city: string;
        region: string;
        telephone: string;
        fax: string;
        carrier: Carrier;
        carrierName: string;
        carriageReference: string;
        transportationMethod: TransportMode;
        status: ExpectedInputStatus;
        lastReceipt: AdministrativeReceipt;
        previousReceipt: AdministrativeReceipt;
        transmittedFromL3: TransmissionL3;
        isQualityControlManagement: boolean;
        orderNumber: string;
        orderReference: string;
        lines: ClientCollection<ExpectedInputLine>;
        addresses: ClientCollection<ExpectedInputAddressesBinding>;
        supplierNames: ClientCollection<ExpectedInputSupplierNamesBinding>;
    }
    export interface ExpectedInput$Lookups {
        site: QueryOperation<Site>;
        depositor: QueryOperation<Depositor>;
        receiptMode: QueryOperation<ReceiptMode>;
        movementCode: QueryOperation<MovementCode>;
        carrierAppointment: QueryOperation<AppointmentManagement>;
        supplier: QueryOperation<Supplier>;
        countryCode: QueryOperation<Country>;
        carrier: QueryOperation<Carrier>;
        transportationMethod: QueryOperation<TransportMode>;
        lastReceipt: QueryOperation<AdministrativeReceipt>;
        previousReceipt: QueryOperation<AdministrativeReceipt>;
    }
    export interface ExpectedInput$Operations {
        query: QueryOperation<ExpectedInput>;
        read: ReadOperation<ExpectedInput>;
        aggregate: {
            read: AggregateReadOperation<ExpectedInput>;
            query: AggregateQueryOperation<ExpectedInput>;
        };
        lookups(dataOrId: string | { data: ExpectedInputInput }): ExpectedInput$Lookups;
        getDefaults: GetDefaultsOperation<ExpectedInput>;
    }
    export interface ReceiptMovementAddressedContainerLevels extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        directInput: string;
        directInputLine: integer;
        code: string;
        containerLevel: ProductContainer;
        quantityOfConsumptionUnitPerLevel: string;
    }
    export interface ReceiptMovementAddressedContainerLevelsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        depositor?: string;
        directInput?: string;
        directInputLine?: integer | string;
        code?: string;
        containerLevel?: string;
        quantityOfConsumptionUnitPerLevel?: decimal | string;
    }
    export interface ReceiptMovementAddressedContainerLevelsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        directInput: string;
        directInputLine: integer;
        code: string;
        containerLevel: ProductContainer;
        quantityOfConsumptionUnitPerLevel: string;
    }
    export interface ReceiptMovementAddressedContainerLevels$Lookups {
        containerLevel: QueryOperation<ProductContainer>;
    }
    export interface ReceiptMovementAddressedContainerLevels$Operations {
        query: QueryOperation<ReceiptMovementAddressedContainerLevels>;
        read: ReadOperation<ReceiptMovementAddressedContainerLevels>;
        aggregate: {
            read: AggregateReadOperation<ReceiptMovementAddressedContainerLevels>;
            query: AggregateQueryOperation<ReceiptMovementAddressedContainerLevels>;
        };
        lookups(
            dataOrId: string | { data: ReceiptMovementAddressedContainerLevelsInput },
        ): ReceiptMovementAddressedContainerLevels$Lookups;
        getDefaults: GetDefaultsOperation<ReceiptMovementAddressedContainerLevels>;
    }
    export interface ReceiptMovementAddressed extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        directInput: DirectInput;
        directInputLine: DirectInputLine;
        code: string;
        store: Store;
        imposedStore: Store;
        isExclusiveStore: boolean;
        location: Location;
        locationType: LocationType;
        stockObject: StockObject;
        containerNumber: string;
        product: Product;
        stockStatus: StockNature;
        source: Origin;
        lotNumber: string;
        reservationNumber: string;
        supportNumber: string;
        numberOfContainers: string;
        container: ProductContainer;
        quantityInConsumptionUnit: string;
        level: ContainerLevel;
        homogeneousQuantity: string;
        homogeneousContainer: ProductContainer;
        homogeneousContainerCoefficient: string;
        movementCode: MovementCode;
        status: InputMovementStatus;
        fifoDate: string;
        receiptDate: string;
        manufacturedDate: string;
        detentionDate: string;
        sellByDate: string;
        useByDate: string;
        shipByDate: string;
        storingList: StoringList;
        storingListLineNumber: integer;
        movementType: MovementType;
        serialNumbers: ClientCollection<SerialNumber>;
        containerLevels: ClientCollection<ReceiptMovementAddressedContainerLevels>;
    }
    export interface ReceiptMovementAddressedInput extends ClientNodeInput {
        site?: string;
        depositor?: string;
        directInput?: string;
        directInputLine?: integer | string;
        code?: string;
        store?: string;
        imposedStore?: string;
        isExclusiveStore?: boolean | string;
        location?: string;
        locationType?: LocationType;
        stockObject?: string;
        containerNumber?: string;
        product?: string;
        stockStatus?: string;
        source?: string;
        lotNumber?: string;
        reservationNumber?: string;
        supportNumber?: string;
        numberOfContainers?: decimal | string;
        container?: string;
        quantityInConsumptionUnit?: decimal | string;
        level?: ContainerLevel;
        homogeneousQuantity?: decimal | string;
        homogeneousContainer?: string;
        homogeneousContainerCoefficient?: decimal | string;
        movementCode?: string;
        status?: InputMovementStatus;
        fifoDate?: string;
        receiptDate?: string;
        manufacturedDate?: string;
        detentionDate?: string;
        sellByDate?: string;
        useByDate?: string;
        shipByDate?: string;
        storingList?: string;
        storingListLineNumber?: integer | string;
        movementType?: MovementType;
        serialNumbers?: Partial<SerialNumberInput>[];
        controlCode?: string;
        containerLevels?: Partial<ReceiptMovementAddressedContainerLevelsInput>[];
    }
    export interface ReceiptMovementAddressedBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        directInput: DirectInput;
        directInputLine: DirectInputLine;
        code: string;
        store: Store;
        imposedStore: Store;
        isExclusiveStore: boolean;
        location: Location;
        locationType: LocationType;
        stockObject: StockObject;
        containerNumber: string;
        product: Product;
        stockStatus: StockNature;
        source: Origin;
        lotNumber: string;
        reservationNumber: string;
        supportNumber: string;
        numberOfContainers: string;
        container: ProductContainer;
        quantityInConsumptionUnit: string;
        level: ContainerLevel;
        homogeneousQuantity: string;
        homogeneousContainer: ProductContainer;
        homogeneousContainerCoefficient: string;
        movementCode: MovementCode;
        status: InputMovementStatus;
        fifoDate: string;
        receiptDate: string;
        manufacturedDate: string;
        detentionDate: string;
        sellByDate: string;
        useByDate: string;
        shipByDate: string;
        storingList: StoringList;
        storingListLineNumber: integer;
        movementType: MovementType;
        serialNumbers: ClientCollection<SerialNumber>;
        controlCode: string;
        containerLevels: ClientCollection<ReceiptMovementAddressedContainerLevelsBinding>;
    }
    export interface ReceiptMovementAddressed$Lookups {
        site: QueryOperation<Site>;
        depositor: QueryOperation<Depositor>;
        directInput: QueryOperation<DirectInput>;
        directInputLine: QueryOperation<DirectInputLine>;
        store: QueryOperation<Store>;
        imposedStore: QueryOperation<Store>;
        location: QueryOperation<Location>;
        stockObject: QueryOperation<StockObject>;
        product: QueryOperation<Product>;
        stockStatus: QueryOperation<StockNature>;
        source: QueryOperation<Origin>;
        container: QueryOperation<ProductContainer>;
        homogeneousContainer: QueryOperation<ProductContainer>;
        movementCode: QueryOperation<MovementCode>;
        storingList: QueryOperation<StoringList>;
    }
    export interface ReceiptMovementAddressed$Operations {
        query: QueryOperation<ReceiptMovementAddressed>;
        read: ReadOperation<ReceiptMovementAddressed>;
        aggregate: {
            read: AggregateReadOperation<ReceiptMovementAddressed>;
            query: AggregateQueryOperation<ReceiptMovementAddressed>;
        };
        lookups(dataOrId: string | { data: ReceiptMovementAddressedInput }): ReceiptMovementAddressed$Lookups;
        getDefaults: GetDefaultsOperation<ReceiptMovementAddressed>;
    }
    export interface ReceiptMovementClosedContainerLevels extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        directInput: string;
        directInputLine: integer;
        code: string;
        containerLevel: ProductContainer;
        quantityOfConsumptionUnitPerLevel: string;
    }
    export interface ReceiptMovementClosedContainerLevelsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        depositor?: string;
        directInput?: string;
        directInputLine?: integer | string;
        code?: string;
        containerLevel?: string;
        quantityOfConsumptionUnitPerLevel?: decimal | string;
    }
    export interface ReceiptMovementClosedContainerLevelsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        directInput: string;
        directInputLine: integer;
        code: string;
        containerLevel: ProductContainer;
        quantityOfConsumptionUnitPerLevel: string;
    }
    export interface ReceiptMovementClosedContainerLevels$Lookups {
        containerLevel: QueryOperation<ProductContainer>;
    }
    export interface ReceiptMovementClosedContainerLevels$Operations {
        query: QueryOperation<ReceiptMovementClosedContainerLevels>;
        read: ReadOperation<ReceiptMovementClosedContainerLevels>;
        aggregate: {
            read: AggregateReadOperation<ReceiptMovementClosedContainerLevels>;
            query: AggregateQueryOperation<ReceiptMovementClosedContainerLevels>;
        };
        lookups(
            dataOrId: string | { data: ReceiptMovementClosedContainerLevelsInput },
        ): ReceiptMovementClosedContainerLevels$Lookups;
        getDefaults: GetDefaultsOperation<ReceiptMovementClosedContainerLevels>;
    }
    export interface ReceiptMovementClosed extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        directInput: DirectInput;
        directInputLine: DirectInputLine;
        code: string;
        store: Store;
        imposedStore: Store;
        isExclusiveStore: boolean;
        location: Location;
        locationType: LocationType;
        stockObject: StockObject;
        containerNumber: string;
        product: Product;
        stockStatus: StockNature;
        source: Origin;
        lotNumber: string;
        reservationNumber: string;
        supportNumber: string;
        numberOfContainers: string;
        container: ProductContainer;
        quantityInConsumptionUnit: string;
        level: ContainerLevel;
        homogeneousQuantity: string;
        homogeneousContainer: ProductContainer;
        homogeneousContainerCoefficient: string;
        movementCode: MovementCode;
        status: InputMovementStatus;
        fifoDate: string;
        receiptDate: string;
        manufacturedDate: string;
        detentionDate: string;
        sellByDate: string;
        useByDate: string;
        shipByDate: string;
        storingList: StoringList;
        storingListLineNumber: integer;
        movementType: MovementType;
        containerLevels: ClientCollection<ReceiptMovementClosedContainerLevels>;
    }
    export interface ReceiptMovementClosedInput extends ClientNodeInput {
        site?: string;
        depositor?: string;
        directInput?: string;
        directInputLine?: integer | string;
        code?: string;
        store?: string;
        imposedStore?: string;
        isExclusiveStore?: boolean | string;
        location?: string;
        locationType?: LocationType;
        stockObject?: string;
        containerNumber?: string;
        product?: string;
        stockStatus?: string;
        source?: string;
        lotNumber?: string;
        reservationNumber?: string;
        supportNumber?: string;
        numberOfContainers?: decimal | string;
        container?: string;
        quantityInConsumptionUnit?: decimal | string;
        level?: ContainerLevel;
        homogeneousQuantity?: decimal | string;
        homogeneousContainer?: string;
        homogeneousContainerCoefficient?: decimal | string;
        movementCode?: string;
        status?: InputMovementStatus;
        fifoDate?: string;
        receiptDate?: string;
        manufacturedDate?: string;
        detentionDate?: string;
        sellByDate?: string;
        useByDate?: string;
        shipByDate?: string;
        storingList?: string;
        storingListLineNumber?: integer | string;
        movementType?: MovementType;
        containerLevels?: Partial<ReceiptMovementClosedContainerLevelsInput>[];
    }
    export interface ReceiptMovementClosedBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        directInput: DirectInput;
        directInputLine: DirectInputLine;
        code: string;
        store: Store;
        imposedStore: Store;
        isExclusiveStore: boolean;
        location: Location;
        locationType: LocationType;
        stockObject: StockObject;
        containerNumber: string;
        product: Product;
        stockStatus: StockNature;
        source: Origin;
        lotNumber: string;
        reservationNumber: string;
        supportNumber: string;
        numberOfContainers: string;
        container: ProductContainer;
        quantityInConsumptionUnit: string;
        level: ContainerLevel;
        homogeneousQuantity: string;
        homogeneousContainer: ProductContainer;
        homogeneousContainerCoefficient: string;
        movementCode: MovementCode;
        status: InputMovementStatus;
        fifoDate: string;
        receiptDate: string;
        manufacturedDate: string;
        detentionDate: string;
        sellByDate: string;
        useByDate: string;
        shipByDate: string;
        storingList: StoringList;
        storingListLineNumber: integer;
        movementType: MovementType;
        containerLevels: ClientCollection<ReceiptMovementClosedContainerLevelsBinding>;
    }
    export interface ReceiptMovementClosed$Lookups {
        site: QueryOperation<Site>;
        depositor: QueryOperation<Depositor>;
        directInput: QueryOperation<DirectInput>;
        directInputLine: QueryOperation<DirectInputLine>;
        store: QueryOperation<Store>;
        imposedStore: QueryOperation<Store>;
        location: QueryOperation<Location>;
        stockObject: QueryOperation<StockObject>;
        product: QueryOperation<Product>;
        stockStatus: QueryOperation<StockNature>;
        source: QueryOperation<Origin>;
        container: QueryOperation<ProductContainer>;
        homogeneousContainer: QueryOperation<ProductContainer>;
        movementCode: QueryOperation<MovementCode>;
        storingList: QueryOperation<StoringList>;
    }
    export interface ReceiptMovementClosed$Operations {
        query: QueryOperation<ReceiptMovementClosed>;
        read: ReadOperation<ReceiptMovementClosed>;
        aggregate: {
            read: AggregateReadOperation<ReceiptMovementClosed>;
            query: AggregateQueryOperation<ReceiptMovementClosed>;
        };
        lookups(dataOrId: string | { data: ReceiptMovementClosedInput }): ReceiptMovementClosed$Lookups;
        getDefaults: GetDefaultsOperation<ReceiptMovementClosed>;
    }
    export interface ReceiptMovementInProgressContainerLevels extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        directInput: string;
        directInputLine: integer;
        code: string;
        containerLevel: ProductContainer;
        quantityOfConsumptionUnitPerLevel: string;
    }
    export interface ReceiptMovementInProgressContainerLevelsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        depositor?: string;
        directInput?: string;
        directInputLine?: integer | string;
        code?: string;
        containerLevel?: string;
        quantityOfConsumptionUnitPerLevel?: decimal | string;
    }
    export interface ReceiptMovementInProgressContainerLevelsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        directInput: string;
        directInputLine: integer;
        code: string;
        containerLevel: ProductContainer;
        quantityOfConsumptionUnitPerLevel: string;
    }
    export interface ReceiptMovementInProgressContainerLevels$Lookups {
        containerLevel: QueryOperation<ProductContainer>;
    }
    export interface ReceiptMovementInProgressContainerLevels$Operations {
        query: QueryOperation<ReceiptMovementInProgressContainerLevels>;
        read: ReadOperation<ReceiptMovementInProgressContainerLevels>;
        aggregate: {
            read: AggregateReadOperation<ReceiptMovementInProgressContainerLevels>;
            query: AggregateQueryOperation<ReceiptMovementInProgressContainerLevels>;
        };
        lookups(
            dataOrId: string | { data: ReceiptMovementInProgressContainerLevelsInput },
        ): ReceiptMovementInProgressContainerLevels$Lookups;
        getDefaults: GetDefaultsOperation<ReceiptMovementInProgressContainerLevels>;
    }
    export interface ReceiptMovementInProgress extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        directInput: DirectInput;
        directInputLine: DirectInputLine;
        code: string;
        store: Store;
        imposedStore: Store;
        isExclusiveStore: boolean;
        location: Location;
        locationType: LocationType;
        stockObject: StockObject;
        containerNumber: string;
        product: Product;
        stockStatus: StockNature;
        source: Origin;
        lotNumber: string;
        reservationNumber: string;
        supportNumber: string;
        numberOfContainers: string;
        container: ProductContainer;
        quantityInConsumptionUnit: string;
        level: ContainerLevel;
        homogeneousQuantity: string;
        homogeneousContainer: ProductContainer;
        homogeneousContainerCoefficient: string;
        movementCode: MovementCode;
        status: InputMovementStatus;
        fifoDate: string;
        receiptDate: string;
        manufacturedDate: string;
        detentionDate: string;
        sellByDate: string;
        useByDate: string;
        shipByDate: string;
        storingList: StoringList;
        storingListLineNumber: integer;
        movementType: MovementType;
        containerLevels: ClientCollection<ReceiptMovementInProgressContainerLevels>;
    }
    export interface ReceiptMovementInProgressInput extends ClientNodeInput {
        site?: string;
        depositor?: string;
        directInput?: string;
        directInputLine?: integer | string;
        code?: string;
        store?: string;
        imposedStore?: string;
        isExclusiveStore?: boolean | string;
        location?: string;
        locationType?: LocationType;
        stockObject?: string;
        containerNumber?: string;
        product?: string;
        stockStatus?: string;
        source?: string;
        lotNumber?: string;
        reservationNumber?: string;
        supportNumber?: string;
        numberOfContainers?: decimal | string;
        container?: string;
        quantityInConsumptionUnit?: decimal | string;
        level?: ContainerLevel;
        homogeneousQuantity?: decimal | string;
        homogeneousContainer?: string;
        homogeneousContainerCoefficient?: decimal | string;
        movementCode?: string;
        status?: InputMovementStatus;
        fifoDate?: string;
        receiptDate?: string;
        manufacturedDate?: string;
        detentionDate?: string;
        sellByDate?: string;
        useByDate?: string;
        shipByDate?: string;
        storingList?: string;
        storingListLineNumber?: integer | string;
        movementType?: MovementType;
        containerLevels?: Partial<ReceiptMovementInProgressContainerLevelsInput>[];
    }
    export interface ReceiptMovementInProgressBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        directInput: DirectInput;
        directInputLine: DirectInputLine;
        code: string;
        store: Store;
        imposedStore: Store;
        isExclusiveStore: boolean;
        location: Location;
        locationType: LocationType;
        stockObject: StockObject;
        containerNumber: string;
        product: Product;
        stockStatus: StockNature;
        source: Origin;
        lotNumber: string;
        reservationNumber: string;
        supportNumber: string;
        numberOfContainers: string;
        container: ProductContainer;
        quantityInConsumptionUnit: string;
        level: ContainerLevel;
        homogeneousQuantity: string;
        homogeneousContainer: ProductContainer;
        homogeneousContainerCoefficient: string;
        movementCode: MovementCode;
        status: InputMovementStatus;
        fifoDate: string;
        receiptDate: string;
        manufacturedDate: string;
        detentionDate: string;
        sellByDate: string;
        useByDate: string;
        shipByDate: string;
        storingList: StoringList;
        storingListLineNumber: integer;
        movementType: MovementType;
        containerLevels: ClientCollection<ReceiptMovementInProgressContainerLevelsBinding>;
    }
    export interface ReceiptMovementInProgress$Lookups {
        site: QueryOperation<Site>;
        depositor: QueryOperation<Depositor>;
        directInput: QueryOperation<DirectInput>;
        directInputLine: QueryOperation<DirectInputLine>;
        store: QueryOperation<Store>;
        imposedStore: QueryOperation<Store>;
        location: QueryOperation<Location>;
        stockObject: QueryOperation<StockObject>;
        product: QueryOperation<Product>;
        stockStatus: QueryOperation<StockNature>;
        source: QueryOperation<Origin>;
        container: QueryOperation<ProductContainer>;
        homogeneousContainer: QueryOperation<ProductContainer>;
        movementCode: QueryOperation<MovementCode>;
        storingList: QueryOperation<StoringList>;
    }
    export interface ReceiptMovementInProgress$Operations {
        query: QueryOperation<ReceiptMovementInProgress>;
        read: ReadOperation<ReceiptMovementInProgress>;
        aggregate: {
            read: AggregateReadOperation<ReceiptMovementInProgress>;
            query: AggregateQueryOperation<ReceiptMovementInProgress>;
        };
        lookups(dataOrId: string | { data: ReceiptMovementInProgressInput }): ReceiptMovementInProgress$Lookups;
        getDefaults: GetDefaultsOperation<ReceiptMovementInProgress>;
    }
    export interface StoringList extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        status: StoringListPurchaseOrderStatus;
        date: string;
        store: Store;
        directInput: DirectInput;
        identifier: string;
        order: PrintingSequence;
        validationType: ValidationType;
        validatingOperator: Operand;
        validatingUser: string;
        postingDate: string;
        addressedReceiptMovements: ClientCollection<ReceiptMovementAddressed>;
        closedReceiptMovements: ClientCollection<ReceiptMovementClosed>;
    }
    export interface StoringListInput extends ClientNodeInput {
        site?: string;
        depositor?: string;
        code?: string;
        status?: StoringListPurchaseOrderStatus;
        date?: string;
        store?: string;
        directInput?: string;
        identifier?: string;
        order?: PrintingSequence;
        validationType?: ValidationType;
        validatingOperator?: string;
        validatingUser?: string;
        postingDate?: string;
        addressedReceiptMovements?: Partial<ReceiptMovementAddressedInput>[];
        operatorCode?: string;
    }
    export interface StoringListBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        status: StoringListPurchaseOrderStatus;
        date: string;
        store: Store;
        directInput: DirectInput;
        identifier: string;
        order: PrintingSequence;
        validationType: ValidationType;
        validatingOperator: Operand;
        validatingUser: string;
        postingDate: string;
        addressedReceiptMovements: ClientCollection<ReceiptMovementAddressed>;
        closedReceiptMovements: ClientCollection<ReceiptMovementClosed>;
        operatorCode: string;
    }
    export interface StoringList$Mutations {
        putaway: Node$Operation<
            {
                parameter?: StoringListInput;
            },
            StoringList
        >;
    }
    export interface StoringList$Lookups {
        site: QueryOperation<Site>;
        depositor: QueryOperation<Depositor>;
        store: QueryOperation<Store>;
        directInput: QueryOperation<DirectInput>;
        validatingOperator: QueryOperation<Operand>;
    }
    export interface StoringList$Operations {
        query: QueryOperation<StoringList>;
        read: ReadOperation<StoringList>;
        aggregate: {
            read: AggregateReadOperation<StoringList>;
            query: AggregateQueryOperation<StoringList>;
        };
        mutations: StoringList$Mutations;
        lookups(dataOrId: string | { data: StoringListInput }): StoringList$Lookups;
        getDefaults: GetDefaultsOperation<StoringList>;
    }
    export interface SerialNumberExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        product: Product;
        code: string;
        double: integer;
        occurrence: integer;
        linePointerNumber: integer;
        receiptDate: string;
        deliveryOrderLineNumber: integer;
        outputDate: string;
        transmittedToL3: integer;
        stockObject: StockObject;
        serialGroup: SerialGroup;
        validatedStoringList: integer;
        validatedPreparationOrder: integer;
        serialParentGroup: SerialGroup;
        transferDate: string;
        free1: string;
        free2: string;
        free3: string;
        free4: string;
        free5: string;
        voided: integer;
        postponed: integer;
        displayCode: string;
        keyCodeForDuplicates: string;
        directInput: DirectInput;
        inputMovement: ReceiptMovementAddressed;
    }
    export interface SerialNumberInputExtension {
        site?: string;
        depositor?: string;
        product?: string;
        code?: string;
        double?: integer | string;
        occurrence?: integer | string;
        linePointerNumber?: integer | string;
        receiptDate?: string;
        deliveryOrderLineNumber?: integer | string;
        outputDate?: string;
        transmittedToL3?: integer | string;
        stockObject?: string;
        serialGroup?: string;
        validatedStoringList?: integer | string;
        validatedPreparationOrder?: integer | string;
        serialParentGroup?: string;
        transferDate?: string;
        free1?: string;
        free2?: string;
        free3?: string;
        free4?: string;
        free5?: string;
        voided?: integer | string;
        postponed?: integer | string;
        actionImport?: string;
        directInput?: string;
        inputMovement?: string;
    }
    export interface SerialNumberBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        product: Product;
        code: string;
        double: integer;
        occurrence: integer;
        linePointerNumber: integer;
        receiptDate: string;
        deliveryOrderLineNumber: integer;
        outputDate: string;
        transmittedToL3: integer;
        stockObject: StockObject;
        serialGroup: SerialGroup;
        validatedStoringList: integer;
        validatedPreparationOrder: integer;
        serialParentGroup: SerialGroup;
        transferDate: string;
        free1: string;
        free2: string;
        free3: string;
        free4: string;
        free5: string;
        voided: integer;
        postponed: integer;
        displayCode: string;
        keyCodeForDuplicates: string;
        actionImport: string;
        directInput: DirectInput;
        inputMovement: ReceiptMovementAddressed;
    }
    export interface SerialNumberExtension$Lookups {
        directInput: QueryOperation<DirectInput>;
        inputMovement: QueryOperation<ReceiptMovementAddressed>;
    }
    export interface SerialNumberExtension$Operations {
        lookups(dataOrId: string | { data: SerialNumberInput }): SerialNumberExtension$Lookups;
    }
    export interface StockObjectExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        depositor: Depositor;
        product: Product;
        store: Store;
        location: Location;
        storeType: StoreType;
        locationType: LocationType;
        containerNumber: string;
        lotNumber: string;
        supportNumber: string;
        container: ProductContainer;
        containerCoefficient: string;
        numberOfConsumptionUnit: string;
        numberOfContainer: string;
        numberOfConsumptionUnitInPendingInput: string;
        numberOfConsumptionUnitInPendingOutput: string;
        stockStatus: StockNature;
        reservationNumber: string;
        source: Origin;
        stockObjectLinkNumber: string;
        fifoDate: string;
        receiptDate: string;
        manufacturedDate: string;
        detentionDate: string;
        sellByDate: string;
        useByDate: string;
        shipByDate: string;
        unStockingAllocationSequence: integer;
        storingDate: string;
        storingTime: integer;
        homogeneousContainer: ProductContainer;
        homogeneousContainerCoefficient: string;
        homogeneousQuantity: string;
        quantityInContainerCorrespondence: string;
        serialNumbers: ClientCollection<SerialNumber>;
        containerLevels: ClientCollection<StockObjectContainerLevels>;
        directInput: DirectInput;
    }
    export interface StockObjectInputExtension {
        site?: string;
        code?: string;
        depositor?: string;
        product?: string;
        store?: string;
        location?: string;
        storeType?: StoreType;
        locationType?: LocationType;
        containerNumber?: string;
        lotNumber?: string;
        supportNumber?: string;
        container?: string;
        containerCoefficient?: decimal | string;
        numberOfConsumptionUnit?: decimal | string;
        numberOfContainer?: decimal | string;
        numberOfConsumptionUnitInPendingInput?: decimal | string;
        numberOfConsumptionUnitInPendingOutput?: decimal | string;
        stockStatus?: string;
        reservationNumber?: string;
        source?: string;
        stockObjectLinkNumber?: string;
        fifoDate?: string;
        receiptDate?: string;
        manufacturedDate?: string;
        detentionDate?: string;
        sellByDate?: string;
        useByDate?: string;
        shipByDate?: string;
        unStockingAllocationSequence?: integer | string;
        storingDate?: string;
        storingTime?: integer | string;
        homogeneousContainer?: string;
        homogeneousContainerCoefficient?: decimal | string;
        homogeneousQuantity?: decimal | string;
        quantityInContainerCorrespondence?: decimal | string;
        serialNumbers?: Partial<SerialNumberInput>[];
        containerLevels?: Partial<StockObjectContainerLevelsInput>[];
        directInput?: string;
    }
    export interface StockObjectBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        depositor: Depositor;
        product: Product;
        store: Store;
        location: Location;
        storeType: StoreType;
        locationType: LocationType;
        containerNumber: string;
        lotNumber: string;
        supportNumber: string;
        container: ProductContainer;
        containerCoefficient: string;
        numberOfConsumptionUnit: string;
        numberOfContainer: string;
        numberOfConsumptionUnitInPendingInput: string;
        numberOfConsumptionUnitInPendingOutput: string;
        stockStatus: StockNature;
        reservationNumber: string;
        source: Origin;
        stockObjectLinkNumber: string;
        fifoDate: string;
        receiptDate: string;
        manufacturedDate: string;
        detentionDate: string;
        sellByDate: string;
        useByDate: string;
        shipByDate: string;
        unStockingAllocationSequence: integer;
        storingDate: string;
        storingTime: integer;
        homogeneousContainer: ProductContainer;
        homogeneousContainerCoefficient: string;
        homogeneousQuantity: string;
        quantityInContainerCorrespondence: string;
        serialNumbers: ClientCollection<SerialNumber>;
        containerLevels: ClientCollection<StockObjectContainerLevelsBinding>;
        directInput: DirectInput;
    }
    export interface StockObjectExtension$Lookups {
        directInput: QueryOperation<DirectInput>;
    }
    export interface StockObjectExtension$Operations {
        lookups(dataOrId: string | { data: StockObjectInput }): StockObjectExtension$Lookups;
    }
    export interface Package {
        '@sage/wh-input/AdministrativeReceiptLineInProgress': AdministrativeReceiptLineInProgress$Operations;
        '@sage/wh-input/AdministrativeReceiptLineValidated': AdministrativeReceiptLineValidated$Operations;
        '@sage/wh-input/AdministrativeReceiptMovementInProgress': AdministrativeReceiptMovementInProgress$Operations;
        '@sage/wh-input/AdministrativeReceiptMovementValidated': AdministrativeReceiptMovementValidated$Operations;
        '@sage/wh-input/AdministrativeReceipt': AdministrativeReceipt$Operations;
        '@sage/wh-input/DirectInputAddresses': DirectInputAddresses$Operations;
        '@sage/wh-input/DirectInputLine': DirectInputLine$Operations;
        '@sage/wh-input/DirectInputSupplierNames': DirectInputSupplierNames$Operations;
        '@sage/wh-input/DirectInput': DirectInput$Operations;
        '@sage/wh-input/ExpectedInputAddresses': ExpectedInputAddresses$Operations;
        '@sage/wh-input/ExpectedInputLine': ExpectedInputLine$Operations;
        '@sage/wh-input/ExpectedInputSupplierNames': ExpectedInputSupplierNames$Operations;
        '@sage/wh-input/ExpectedInput': ExpectedInput$Operations;
        '@sage/wh-input/ReceiptMovementAddressedContainerLevels': ReceiptMovementAddressedContainerLevels$Operations;
        '@sage/wh-input/ReceiptMovementAddressed': ReceiptMovementAddressed$Operations;
        '@sage/wh-input/ReceiptMovementClosedContainerLevels': ReceiptMovementClosedContainerLevels$Operations;
        '@sage/wh-input/ReceiptMovementClosed': ReceiptMovementClosed$Operations;
        '@sage/wh-input/ReceiptMovementInProgressContainerLevels': ReceiptMovementInProgressContainerLevels$Operations;
        '@sage/wh-input/ReceiptMovementInProgress': ReceiptMovementInProgress$Operations;
        '@sage/wh-input/StoringList': StoringList$Operations;
    }
    export interface GraphApi
        extends Package,
            SageWhMasterData$Package,
            SageWhProductData$Package,
            SageWhStockData$Package,
            SageWhStructure$Package,
            SageWhSystem$Package,
            SageXtremAppMetadata$Package,
            SageXtremX3SystemUtils$Package {}
}
declare module '@sage/wh-input-api' {
    export type * from '@sage/wh-input-api-partial';
}
declare module '@sage/wh-master-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/wh-input-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/wh-product-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/wh-input-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/wh-stock-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/wh-input-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/wh-structure-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/wh-input-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/wh-system-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/wh-input-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-app-metadata-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/wh-input-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-x3-system-utils-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/wh-input-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/wh-stock-data-api-partial' {
    import type {
        SerialNumberBindingExtension,
        SerialNumberExtension,
        SerialNumberExtension$Lookups,
        SerialNumberExtension$Operations,
        SerialNumberInputExtension,
        StockObjectBindingExtension,
        StockObjectExtension,
        StockObjectExtension$Lookups,
        StockObjectExtension$Operations,
        StockObjectInputExtension,
    } from '@sage/wh-input-api';
    export interface SerialNumber extends SerialNumberExtension {}
    export interface SerialNumberBinding extends SerialNumberBindingExtension {}
    export interface SerialNumberInput extends SerialNumberInputExtension {}
    export interface SerialNumber$Lookups extends SerialNumberExtension$Lookups {}
    export interface SerialNumber$Operations extends SerialNumberExtension$Operations {}
    export interface StockObject extends StockObjectExtension {}
    export interface StockObjectBinding extends StockObjectBindingExtension {}
    export interface StockObjectInput extends StockObjectInputExtension {}
    export interface StockObject$Lookups extends StockObjectExtension$Lookups {}
    export interface StockObject$Operations extends StockObjectExtension$Operations {}
}
