import { XLinkProps } from '../model';
export interface TextObject {
    align: string;
    fill: string;
    fontFamily: string;
    fontSize: number;
    fontStyle: string;
    fontWeight?: number;
    leftMargin?: number;
    link?: XLinkProps;
    rightMargin?: number;
    text: string;
    textDecoration?: string;
    valign?: string;
}
export declare function transformXMLToTextObject(xmlText: string): Promise<TextObject[]>;
/**
 * The text must be surrounded with the <TEXTAREA> tags due to a legacy limitation. The X3 supervisor has
 * a special behavior to extract the text from translation: it looks for these tags in the text content so
 * in order not to break that process we need to maintain these tags.
 *  */
export declare const removeLegacyTextFormatTags: (textContent: string) => string;
//# sourceMappingURL=xmlParser.d.ts.map