/// <reference types="react" />
import { ShapeWithText } from '../components/vp-legacy-text';
import { Dict, FontSize, FontStyle, HorizontalAlignment, LineTerminus, Point, VerticalAlignment, XAction, XActionType, XDocument, XEllipseShape, XFill, XImageShape, XLineEndDecoration, XLineEndDecorationType, XShape, XStrokeStyle } from '../model';
import { TextObject } from '../utils/xmlParser';
export interface UpdateShapeInfo {
    shape: Partial<XShape>;
    layerId: string;
    shapeId: string;
}
export interface ShapeChanges {
    x: number;
    y: number;
    rotation?: number;
    scaleX?: number;
    scaleY?: number;
    centerX?: number;
    centerY?: number;
}
export declare const MIN_BOX_SIZE = 10;
export declare const ALL_ANCHORS: string[];
export declare const LINE_ANCHORS: string[];
export declare const HORIZONTAL_ANCHORS: string[];
export declare const VERTICAL_ANCHORS: string[];
export declare const getHexColor: (color?: import("react").ReactText) => string;
export declare const getRgbColor: (color?: import("react").ReactText) => {
    r: number;
    b: number;
    g: number;
};
export declare const rgba2hex: (orig: string) => string;
export declare const getOpacity: (source?: {
    xalpha?: number | undefined;
    xcolor?: string | number | undefined;
} | undefined) => number;
export declare const strokeStyles: Dict<number[] | undefined>;
export declare const getStrokeProperties: (shape: XShape) => Pick<import("konva/types/Shape").ShapeConfig, "stroke" | "strokeWidth" | "dash" | "opacity">;
export interface ArrowProps {
    lineEndType?: XLineEndDecorationType;
    isLineEndFilled?: XLineEndDecoration['xfilled'];
}
export declare const getArrowProperties: (shape: XShape, extremity: "xstart" | "xend") => ArrowProps;
export declare const getHighlightBox: (shape: any, topLeft: Point) => {
    x: number;
    y: number;
    width: number;
    height: number;
};
export declare const getHighlightProperties: () => {
    strokeScaleEnabled: boolean;
    strokeEnabled: boolean;
    stroke: string;
    strokeWidth: number;
    listening: boolean;
};
export declare const getShadowProperties: (shape: XShape) => Pick<import("konva/types/Shape").ShapeConfig, "shadowColor" | "shadowBlur" | "shadowOffsetX" | "shadowOffsetY" | "shadowOpacity" | "shadowEnabled">;
export declare const getFillProperties: (shape: {
    xfillProps?: XFill | undefined;
}) => Partial<import("konva/types/Shape").ShapeConfig>;
export declare const getFontSize: (shape: XShape) => FontSize;
export declare const getFontStyle: (shape: XShape) => FontStyle;
export declare const getHorizontalAlignment: (shape: XShape) => HorizontalAlignment;
export declare const getVerticalAlignment: (shape: XShape) => VerticalAlignment;
export declare const isFillableShape: (shape: XShape) => boolean;
export declare const hasBorder: (shape: XShape) => boolean;
export declare const isLineShape: (shape: XShape) => boolean;
export declare const getStrokeStyle: (shape: XShape) => XStrokeStyle;
export declare const getLineDecorator: (shape: XShape, terminus: LineTerminus) => XLineEndDecorationType;
export declare const hasText: (shape: XShape) => boolean;
export declare const isNewTextContent: (shape: XShape) => boolean;
export declare const getShapeType: (shape: XShape) => "IMAGE" | "ELLIPSE" | "RECTANGLE" | "LINE" | "CIRCLE" | "BEZIER" | "UNSUPPORTED";
export declare const composeXtext: (text: string) => string;
export declare const getRandomId: () => string;
export declare const createLine: ({ x, y }: {
    x: number;
    y: number;
}) => XEllipseShape;
export declare const createEllipse: ({ x, y, isCircle, }: {
    x: number;
    y: number;
    isCircle?: boolean | undefined;
}) => XEllipseShape;
export declare const createAction: (actionId: string, actionType: XActionType) => XAction;
export declare const updateShape: (changes: ShapeChanges, shape: XShape) => Partial<XShape>;
export declare const createTextLinkRectangles: (shape: ShapeWithText, textObjects?: TextObject[]) => XEllipseShape[];
export declare const createRectangle: ({ x, y }: {
    x: number;
    y: number;
}) => XEllipseShape;
export declare const createIcon: ({ x, y, collectionId, resourceId, }: {
    x: number;
    y: number;
    collectionId: string;
    resourceId: string;
}) => any;
export declare const createImage: ({ x, y, imgSrc }: {
    x: number;
    y: number;
    imgSrc: string;
}) => XImageShape;
export declare const isIconShape: (shape: XShape) => boolean;
export declare const isCircleOrEllipse: (shape: XShape) => any;
export declare const getShape: (document: XDocument, uniqueId: string) => XShape | undefined;
export declare const getShapeGroup: (shape: XShape) => number | undefined;
//# sourceMappingURL=shape.d.ts.map